/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.tileprovider.modules;

import android.graphics.drawable.Drawable;
import android.util.Log;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicReference;
import org.osmdroid.config.Configuration;
import org.osmdroid.tileprovider.IRegisterReceiver;
import org.osmdroid.tileprovider.modules.ArchiveFileFactory;
import org.osmdroid.tileprovider.modules.IArchiveFile;
import org.osmdroid.tileprovider.modules.MapTileFileStorageProviderBase;
import org.osmdroid.tileprovider.modules.MapTileModuleProviderBase;
import org.osmdroid.tileprovider.tilesource.ITileSource;
import org.osmdroid.tileprovider.util.StreamUtils;
import org.osmdroid.util.MapTileIndex;
import org.osmdroid.util.TileSystem;

public class MapTileFileArchiveProvider
extends MapTileFileStorageProviderBase {
    private final ArrayList<IArchiveFile> mArchiveFiles = new ArrayList();
    private final AtomicReference<ITileSource> mTileSource = new AtomicReference();
    private final boolean mSpecificArchivesProvided;
    private final boolean ignoreTileSource;

    public MapTileFileArchiveProvider(IRegisterReceiver pRegisterReceiver, ITileSource pTileSource, IArchiveFile[] pArchives) {
        this(pRegisterReceiver, pTileSource, pArchives, false);
    }

    public MapTileFileArchiveProvider(IRegisterReceiver pRegisterReceiver, ITileSource pTileSource, IArchiveFile[] pArchives, boolean ignoreTileSource) {
        super(pRegisterReceiver, Configuration.getInstance().getTileFileSystemThreads(), Configuration.getInstance().getTileFileSystemMaxQueueSize());
        this.ignoreTileSource = ignoreTileSource;
        this.setTileSource(pTileSource);
        if (pArchives == null) {
            this.mSpecificArchivesProvided = false;
            this.findArchiveFiles();
        } else {
            this.mSpecificArchivesProvided = true;
            for (int i = pArchives.length - 1; i >= 0; --i) {
                this.mArchiveFiles.add(pArchives[i]);
            }
        }
    }

    public MapTileFileArchiveProvider(IRegisterReceiver pRegisterReceiver, ITileSource pTileSource) {
        this(pRegisterReceiver, pTileSource, null);
    }

    @Override
    public boolean getUsesDataConnection() {
        return false;
    }

    @Override
    protected String getName() {
        return "File Archive Provider";
    }

    @Override
    protected String getThreadGroupName() {
        return "filearchive";
    }

    @Override
    public TileLoader getTileLoader() {
        return new TileLoader();
    }

    @Override
    public int getMinimumZoomLevel() {
        ITileSource tileSource = this.mTileSource.get();
        return tileSource != null ? tileSource.getMinimumZoomLevel() : 0;
    }

    @Override
    public int getMaximumZoomLevel() {
        ITileSource tileSource = this.mTileSource.get();
        return tileSource != null ? tileSource.getMaximumZoomLevel() : TileSystem.getMaximumZoomLevel();
    }

    @Override
    protected void onMediaMounted() {
        if (!this.mSpecificArchivesProvided) {
            this.findArchiveFiles();
        }
    }

    @Override
    protected void onMediaUnmounted() {
        if (!this.mSpecificArchivesProvided) {
            this.findArchiveFiles();
        }
    }

    @Override
    public void setTileSource(ITileSource pTileSource) {
        this.mTileSource.set(pTileSource);
    }

    @Override
    public void detach() {
        this.clearArcives();
        super.detach();
    }

    private void clearArcives() {
        while (!this.mArchiveFiles.isEmpty()) {
            IArchiveFile t = this.mArchiveFiles.get(0);
            if (t != null) {
                t.close();
            }
            this.mArchiveFiles.remove(0);
        }
    }

    private void findArchiveFiles() {
        File[] files;
        this.clearArcives();
        File cachePaths = Configuration.getInstance().getOsmdroidBasePath();
        if (cachePaths != null && (files = cachePaths.listFiles()) != null) {
            for (File file : files) {
                IArchiveFile archiveFile = ArchiveFileFactory.getArchiveFile(file);
                if (archiveFile == null) continue;
                archiveFile.setIgnoreTileSource(this.ignoreTileSource);
                this.mArchiveFiles.add(archiveFile);
            }
        }
    }

    private synchronized InputStream getInputStream(long pMapTileIndex, ITileSource tileSource) {
        for (IArchiveFile archiveFile : this.mArchiveFiles) {
            InputStream in;
            if (archiveFile == null || (in = archiveFile.getInputStream(tileSource, pMapTileIndex)) == null) continue;
            if (Configuration.getInstance().isDebugMode()) {
                Log.d((String)"OsmDroid", (String)("Found tile " + MapTileIndex.toString(pMapTileIndex) + " in " + archiveFile));
            }
            return in;
        }
        return null;
    }

    protected class TileLoader
    extends MapTileModuleProviderBase.TileLoader {
        protected TileLoader() {
            super(MapTileFileArchiveProvider.this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public Drawable loadTile(long pMapTileIndex) {
            Drawable returnValue = null;
            ITileSource tileSource = (ITileSource)MapTileFileArchiveProvider.this.mTileSource.get();
            if (tileSource == null) {
                return null;
            }
            InputStream inputStream = null;
            try {
                if (Configuration.getInstance().isDebugMode()) {
                    Log.d((String)"OsmDroid", (String)("Archives - Tile doesn't exist: " + MapTileIndex.toString(pMapTileIndex)));
                }
                if ((inputStream = MapTileFileArchiveProvider.this.getInputStream(pMapTileIndex, tileSource)) != null) {
                    Drawable drawable;
                    if (Configuration.getInstance().isDebugMode()) {
                        Log.d((String)"OsmDroid", (String)("Use tile from archive: " + MapTileIndex.toString(pMapTileIndex)));
                    }
                    returnValue = drawable = tileSource.getDrawable(inputStream);
                }
                if (inputStream == null) return returnValue;
            }
            catch (Throwable e) {
                try {
                    Log.e((String)"OsmDroid", (String)"Error loading tile", (Throwable)e);
                    if (inputStream == null) return returnValue;
                }
                catch (Throwable throwable) {
                    if (inputStream == null) throw throwable;
                    StreamUtils.closeStream(inputStream);
                    throw throwable;
                }
                StreamUtils.closeStream(inputStream);
                return returnValue;
            }
            StreamUtils.closeStream(inputStream);
            return returnValue;
        }
    }
}

