/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.tileprovider.modules;

import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.util.Log;
import java.util.concurrent.atomic.AtomicReference;
import org.osmdroid.config.Configuration;
import org.osmdroid.tileprovider.BitmapPool;
import org.osmdroid.tileprovider.MapTileRequestState;
import org.osmdroid.tileprovider.modules.CantContinueException;
import org.osmdroid.tileprovider.modules.IFilesystemCache;
import org.osmdroid.tileprovider.modules.INetworkAvailablityCheck;
import org.osmdroid.tileprovider.modules.MapTileModuleProviderBase;
import org.osmdroid.tileprovider.modules.TileDownloader;
import org.osmdroid.tileprovider.tilesource.ITileSource;
import org.osmdroid.tileprovider.tilesource.OnlineTileSourceBase;
import org.osmdroid.util.TileSystem;
import org.osmdroid.util.UrlBackoff;

public class MapTileDownloader
extends MapTileModuleProviderBase {
    private final IFilesystemCache mFilesystemCache;
    private final AtomicReference<OnlineTileSourceBase> mTileSource = new AtomicReference();
    private final INetworkAvailablityCheck mNetworkAvailablityCheck;
    private final TileLoader mTileLoader = new TileLoader();
    private final UrlBackoff mUrlBackoff = new UrlBackoff();
    private TileDownloader mTileDownloader = new TileDownloader();

    public MapTileDownloader(ITileSource pTileSource) {
        this(pTileSource, null, null);
    }

    public MapTileDownloader(ITileSource pTileSource, IFilesystemCache pFilesystemCache) {
        this(pTileSource, pFilesystemCache, null);
    }

    public MapTileDownloader(ITileSource pTileSource, IFilesystemCache pFilesystemCache, INetworkAvailablityCheck pNetworkAvailablityCheck) {
        this(pTileSource, pFilesystemCache, pNetworkAvailablityCheck, Configuration.getInstance().getTileDownloadThreads(), Configuration.getInstance().getTileDownloadMaxQueueSize());
    }

    public MapTileDownloader(ITileSource pTileSource, IFilesystemCache pFilesystemCache, INetworkAvailablityCheck pNetworkAvailablityCheck, int pThreadPoolSize, int pPendingQueueSize) {
        super(pThreadPoolSize, pPendingQueueSize);
        this.mFilesystemCache = pFilesystemCache;
        this.mNetworkAvailablityCheck = pNetworkAvailablityCheck;
        this.setTileSource(pTileSource);
    }

    public ITileSource getTileSource() {
        return this.mTileSource.get();
    }

    @Override
    public boolean getUsesDataConnection() {
        return true;
    }

    @Override
    protected String getName() {
        return "Online Tile Download Provider";
    }

    @Override
    protected String getThreadGroupName() {
        return "downloader";
    }

    @Override
    public TileLoader getTileLoader() {
        return this.mTileLoader;
    }

    @Override
    public void detach() {
        super.detach();
        if (this.mFilesystemCache != null) {
            this.mFilesystemCache.onDetach();
        }
    }

    @Override
    public int getMinimumZoomLevel() {
        OnlineTileSourceBase tileSource = this.mTileSource.get();
        return tileSource != null ? tileSource.getMinimumZoomLevel() : 0;
    }

    @Override
    public int getMaximumZoomLevel() {
        OnlineTileSourceBase tileSource = this.mTileSource.get();
        return tileSource != null ? tileSource.getMaximumZoomLevel() : TileSystem.getMaximumZoomLevel();
    }

    @Override
    public void setTileSource(ITileSource tileSource) {
        if (tileSource instanceof OnlineTileSourceBase) {
            this.mTileSource.set((OnlineTileSourceBase)tileSource);
        } else {
            this.mTileSource.set(null);
        }
    }

    public void setTileDownloader(TileDownloader pTileDownloader) {
        this.mTileDownloader = pTileDownloader;
    }

    protected class TileLoader
    extends MapTileModuleProviderBase.TileLoader {
        protected TileLoader() {
            super(MapTileDownloader.this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Drawable downloadTile(long pMapTileIndex, int redirectCount, String targetUrl) throws CantContinueException {
            OnlineTileSourceBase tileSource = (OnlineTileSourceBase)MapTileDownloader.this.mTileSource.get();
            if (tileSource == null) {
                return null;
            }
            try {
                tileSource.acquire();
            }
            catch (InterruptedException e) {
                return null;
            }
            try {
                Drawable drawable = MapTileDownloader.this.mTileDownloader.downloadTile(pMapTileIndex, redirectCount, targetUrl, MapTileDownloader.this.mFilesystemCache, tileSource);
                return drawable;
            }
            finally {
                tileSource.release();
            }
        }

        @Override
        public Drawable loadTile(long pMapTileIndex) throws CantContinueException {
            OnlineTileSourceBase tileSource = (OnlineTileSourceBase)MapTileDownloader.this.mTileSource.get();
            if (tileSource == null) {
                return null;
            }
            if (MapTileDownloader.this.mNetworkAvailablityCheck != null && !MapTileDownloader.this.mNetworkAvailablityCheck.getNetworkAvailable()) {
                if (Configuration.getInstance().isDebugMode()) {
                    Log.d((String)"OsmDroid", (String)("Skipping " + MapTileDownloader.this.getName() + " due to NetworkAvailabliltyCheck."));
                }
                return null;
            }
            String tileURLString = tileSource.getTileURLString(pMapTileIndex);
            if (TextUtils.isEmpty((CharSequence)tileURLString)) {
                return null;
            }
            if (MapTileDownloader.this.mUrlBackoff.shouldWait(tileURLString)) {
                return null;
            }
            Drawable result = this.downloadTile(pMapTileIndex, 0, tileURLString);
            if (result == null) {
                MapTileDownloader.this.mUrlBackoff.next(tileURLString);
            } else {
                MapTileDownloader.this.mUrlBackoff.remove(tileURLString);
            }
            return result;
        }

        @Override
        protected void tileLoaded(MapTileRequestState pState, Drawable pDrawable) {
            MapTileDownloader.this.removeTileFromQueues(pState.getMapTile());
            pState.getCallback().mapTileRequestCompleted(pState, null);
            BitmapPool.getInstance().asyncRecycle(pDrawable);
        }
    }
}

