/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.views.overlay;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Canvas;
import android.view.MotionEvent;
import java.util.List;
import org.osmdroid.util.BoundingBox;
import org.osmdroid.util.TileSystem;
import org.osmdroid.views.MapView;
import org.osmdroid.views.Projection;
import org.osmdroid.views.overlay.DefaultOverlayManager;
import org.osmdroid.views.overlay.Overlay;
import org.osmdroid.views.overlay.OverlayManager;
import org.osmdroid.views.overlay.OverlayWithIW;

public class FolderOverlay
extends Overlay {
    protected OverlayManager mOverlayManager = new DefaultOverlayManager(null);
    protected String mName = "";
    protected String mDescription = "";

    @Deprecated
    public FolderOverlay(Context ctx) {
        this();
    }

    public FolderOverlay() {
    }

    public void setName(String name) {
        this.mName = name;
    }

    public String getName() {
        return this.mName;
    }

    public void setDescription(String description) {
        this.mDescription = description;
    }

    public String getDescription() {
        return this.mDescription;
    }

    public List<Overlay> getItems() {
        return this.mOverlayManager;
    }

    public boolean add(Overlay item) {
        boolean b = this.mOverlayManager.add(item);
        if (b) {
            this.recalculateBounds();
        }
        return b;
    }

    private void recalculateBounds() {
        double minLat = Double.MAX_VALUE;
        double minLon = Double.MAX_VALUE;
        double maxLat = -1.7976931348623157E308;
        double maxLon = -1.7976931348623157E308;
        for (Overlay gp : this.mOverlayManager) {
            BoundingBox box = gp.getBounds();
            minLat = Math.min(minLat, box.getLatSouth());
            minLon = Math.min(minLon, box.getLonWest());
            maxLat = Math.max(maxLat, box.getLatNorth());
            maxLon = Math.max(maxLon, box.getLonEast());
        }
        if (minLat == Double.MAX_VALUE) {
            TileSystem tileSystem = MapView.getTileSystem();
            this.mBounds = new BoundingBox(tileSystem.getMaxLatitude(), tileSystem.getMaxLongitude(), tileSystem.getMinLatitude(), tileSystem.getMinLongitude());
        } else {
            this.mBounds = new BoundingBox(maxLat, maxLon, minLat, minLon);
        }
    }

    public boolean remove(Overlay item) {
        boolean b = this.mOverlayManager.remove(item);
        if (b) {
            this.recalculateBounds();
        }
        return b;
    }

    @Override
    @SuppressLint(value={"WrongCall"})
    public void draw(Canvas pCanvas, Projection pProjection) {
        this.mOverlayManager.onDraw(pCanvas, pProjection);
    }

    @Override
    @SuppressLint(value={"WrongCall"})
    public void draw(Canvas pCanvas, MapView pMapView, boolean pShadow) {
        if (pShadow) {
            return;
        }
        this.mOverlayManager.onDraw(pCanvas, pMapView);
    }

    @Override
    public boolean onSingleTapUp(MotionEvent e, MapView mapView) {
        if (this.isEnabled()) {
            return this.mOverlayManager.onSingleTapUp(e, mapView);
        }
        return false;
    }

    @Override
    public boolean onSingleTapConfirmed(MotionEvent e, MapView mapView) {
        if (this.isEnabled()) {
            return this.mOverlayManager.onSingleTapConfirmed(e, mapView);
        }
        return false;
    }

    @Override
    public boolean onLongPress(MotionEvent e, MapView mapView) {
        if (this.isEnabled()) {
            return this.mOverlayManager.onLongPress(e, mapView);
        }
        return false;
    }

    @Override
    public boolean onTouchEvent(MotionEvent e, MapView mapView) {
        if (this.isEnabled()) {
            return this.mOverlayManager.onTouchEvent(e, mapView);
        }
        return false;
    }

    @Override
    public boolean onDoubleTap(MotionEvent e, MapView mapView) {
        if (this.isEnabled()) {
            return this.mOverlayManager.onDoubleTap(e, mapView);
        }
        return false;
    }

    public void closeAllInfoWindows() {
        for (Overlay overlay : this.mOverlayManager) {
            if (overlay instanceof FolderOverlay) {
                ((FolderOverlay)overlay).closeAllInfoWindows();
                continue;
            }
            if (!(overlay instanceof OverlayWithIW)) continue;
            ((OverlayWithIW)overlay).closeInfoWindow();
        }
    }

    @Override
    public void onDetach(MapView mapView) {
        if (this.mOverlayManager != null) {
            this.mOverlayManager.onDetach(mapView);
        }
        this.mOverlayManager = null;
    }
}

