/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.util;

import org.osmdroid.util.MapTileContainer;
import org.osmdroid.util.MapTileIndex;

public class MapTileList
implements MapTileContainer {
    private long[] mTileIndices;
    private int mSize;

    public void clear() {
        this.mSize = 0;
    }

    public int getSize() {
        return this.mSize;
    }

    public long get(int pIndex) {
        return this.mTileIndices[pIndex];
    }

    public void put(long pTileIndex) {
        this.ensureCapacity(this.mSize + 1);
        this.mTileIndices[this.mSize++] = pTileIndex;
    }

    public void put(int pZoom, int pLeft, int pTop, int pRight, int pBottom) {
        int max = 1 << pZoom;
        int spanX = pRight - pLeft + 1 + (pRight < pLeft ? max : 0);
        int spanY = pBottom - pTop + 1 + (pBottom < pTop ? max : 0);
        this.ensureCapacity(this.getSize() + spanX * spanY);
        for (int i = 0; i < spanX; ++i) {
            for (int j = 0; j < spanY; ++j) {
                int x = (pLeft + i) % max;
                int y = (pTop + j) % max;
                this.put(MapTileIndex.getTileIndex(pZoom, x, y));
            }
        }
    }

    public void put(int pZoom) {
        int max = 1 << pZoom;
        this.put(pZoom, 0, 0, max - 1, max - 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ensureCapacity(int pCapacity) {
        if (pCapacity == 0) {
            return;
        }
        if (this.mTileIndices != null && this.mTileIndices.length >= pCapacity) {
            return;
        }
        MapTileList mapTileList = this;
        synchronized (mapTileList) {
            long[] tmp = new long[pCapacity];
            if (this.mTileIndices != null) {
                System.arraycopy(this.mTileIndices, 0, tmp, 0, this.mTileIndices.length);
            }
            this.mTileIndices = tmp;
        }
    }

    @Override
    public boolean contains(long pTileIndex) {
        if (this.mTileIndices == null) {
            return false;
        }
        for (int i = 0; i < this.mSize; ++i) {
            if (this.mTileIndices[i] != pTileIndex) continue;
            return true;
        }
        return false;
    }

    public long[] toArray() {
        long[] result = new long[this.mSize];
        if (this.mTileIndices != null) {
            System.arraycopy(this.mTileIndices, 0, result, 0, this.mSize);
        }
        return result;
    }
}

