/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.util;

import java.util.concurrent.atomic.AtomicBoolean;

public class GarbageCollector {
    private final AtomicBoolean mRunning = new AtomicBoolean(false);
    private final Runnable mAction;

    public GarbageCollector(Runnable pAction) {
        this.mAction = pAction;
    }

    public boolean gc() {
        if (this.mRunning.getAndSet(true)) {
            return false;
        }
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    GarbageCollector.this.mAction.run();
                }
                finally {
                    GarbageCollector.this.mRunning.set(false);
                }
            }
        });
        thread.setName("GarbageCollector");
        thread.setPriority(1);
        thread.start();
        return true;
    }

    public boolean isRunning() {
        return this.mRunning.get();
    }
}

