/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.util;

public class Delay {
    private final long[] mDurations;
    private long mDuration;
    private long mNextTime;
    private int mIndex;

    public Delay(long pDuration) {
        this.mDurations = null;
        this.mDuration = pDuration;
        this.next();
    }

    public Delay(long[] pDurations) {
        if (pDurations == null || pDurations.length == 0) {
            throw new IllegalArgumentException();
        }
        this.mDurations = pDurations;
        this.next();
    }

    public long next() {
        long duration;
        if (this.mDurations == null) {
            duration = this.mDuration;
        } else {
            duration = this.mDurations[this.mIndex];
            if (this.mIndex < this.mDurations.length - 1) {
                ++this.mIndex;
            }
        }
        this.mNextTime = this.now() + duration;
        return duration;
    }

    public boolean shouldWait() {
        return this.now() < this.mNextTime;
    }

    private long now() {
        return System.nanoTime() / 1000000L;
    }
}

