/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.views.overlay;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Point;
import android.graphics.Rect;
import android.view.MotionEvent;
import org.osmdroid.util.GeoPoint;
import org.osmdroid.util.PointL;
import org.osmdroid.util.RectL;
import org.osmdroid.util.SpeechBalloonHelper;
import org.osmdroid.views.MapView;
import org.osmdroid.views.Projection;
import org.osmdroid.views.overlay.Overlay;

public class SpeechBalloonOverlay
extends Overlay {
    private final SpeechBalloonHelper mHelper = new SpeechBalloonHelper();
    private final RectL mRect = new RectL();
    private final PointL mPoint = new PointL();
    private final PointL mIntersection1 = new PointL();
    private final PointL mIntersection2 = new PointL();
    private final Path mPath = new Path();
    private final Rect mTextRect = new Rect();
    private final Point mPixel = new Point();
    private String mTitle;
    private GeoPoint mGeoPoint;
    private Paint mBackground;
    private Paint mForeground;
    private int mMargin;
    private double mRadius;
    private int mOffsetX;
    private int mOffsetY;
    private boolean mDraggable = true;
    private boolean mIsDragged;
    private float mDragStartX;
    private float mDragStartY;
    private float mDragDeltaX;
    private float mDragDeltaY;
    private Paint mDragBackground;
    private Paint mDragForeground;

    public void setTitle(String pTitle) {
        this.mTitle = pTitle;
    }

    public void setGeoPoint(GeoPoint pGeoPoint) {
        this.mGeoPoint = pGeoPoint;
    }

    public void setBackground(Paint pBackground) {
        this.mBackground = pBackground;
    }

    public void setForeground(Paint pForeground) {
        this.mForeground = pForeground;
    }

    public void setDragBackground(Paint pDragBackground) {
        this.mDragBackground = pDragBackground;
    }

    public void setDragForeground(Paint pDragForeground) {
        this.mDragForeground = pDragForeground;
    }

    public void setMargin(int pMargin) {
        this.mMargin = pMargin;
    }

    public void setRadius(long pRadius) {
        this.mRadius = pRadius;
    }

    public void setOffset(int pOffsetX, int pOffsetY) {
        this.mOffsetX = pOffsetX;
        this.mOffsetY = pOffsetY;
    }

    @Override
    public void draw(Canvas pCanvas, Projection pProjection) {
        Paint foreground;
        Paint background;
        if (this.mIsDragged) {
            background = this.mDragBackground != null ? this.mDragBackground : this.mBackground;
            foreground = this.mDragForeground != null ? this.mDragForeground : this.mForeground;
        } else {
            background = this.mBackground;
            foreground = this.mForeground;
        }
        if (this.mGeoPoint == null) {
            return;
        }
        if (this.mTitle == null || this.mTitle.trim().length() == 0) {
            return;
        }
        if (foreground == null || background == null) {
            return;
        }
        pProjection.toPixels(this.mGeoPoint, this.mPixel);
        String text = this.mTitle;
        foreground.getTextBounds(text, 0, text.length(), this.mTextRect);
        this.mPoint.set(this.mPixel.x, this.mPixel.y);
        this.mTextRect.offset((int)((float)(this.mPoint.x + (long)this.mOffsetX) + this.mDragDeltaX), (int)((float)(this.mPoint.y + (long)this.mOffsetY) + this.mDragDeltaY));
        this.mTextRect.top -= this.mMargin;
        this.mTextRect.left -= this.mMargin;
        this.mTextRect.right += this.mMargin;
        this.mTextRect.bottom += this.mMargin;
        this.mRect.set(this.mTextRect.left, this.mTextRect.top, this.mTextRect.right, this.mTextRect.bottom);
        int corner = this.mHelper.compute(this.mRect, this.mPoint, this.mRadius, this.mIntersection1, this.mIntersection2);
        pCanvas.drawRect((float)this.mTextRect.left, (float)this.mTextRect.top, (float)this.mTextRect.right, (float)this.mTextRect.bottom, background);
        if (corner != -1) {
            this.mPath.reset();
            this.mPath.moveTo((float)this.mPoint.x, (float)this.mPoint.y);
            this.mPath.lineTo((float)this.mIntersection1.x, (float)this.mIntersection1.y);
            this.mPath.lineTo((float)this.mIntersection2.x, (float)this.mIntersection2.y);
            this.mPath.close();
            pCanvas.drawPath(this.mPath, background);
        }
        pCanvas.drawText(text, (float)(this.mTextRect.left + this.mMargin), (float)(this.mTextRect.bottom - this.mMargin), foreground);
    }

    @Override
    public boolean onLongPress(MotionEvent event, MapView mapView) {
        boolean touched = this.hitTest(event, mapView);
        if (touched && this.mDraggable) {
            this.mIsDragged = true;
            this.mDragStartX = event.getX();
            this.mDragStartY = event.getY();
            this.mDragDeltaX = 0.0f;
            this.mDragDeltaY = 0.0f;
            mapView.invalidate();
        }
        return touched;
    }

    @Override
    public boolean onTouchEvent(MotionEvent event, MapView mapView) {
        if (this.mDraggable && this.mIsDragged) {
            if (event.getAction() == 1) {
                this.mDragDeltaX = event.getX() - this.mDragStartX;
                this.mDragDeltaY = event.getY() - this.mDragStartY;
                this.mOffsetX = (int)((float)this.mOffsetX + this.mDragDeltaX);
                this.mOffsetY = (int)((float)this.mOffsetY + this.mDragDeltaY);
                this.mDragDeltaX = 0.0f;
                this.mDragDeltaY = 0.0f;
                this.mIsDragged = false;
                mapView.invalidate();
                return true;
            }
            if (event.getAction() == 2) {
                this.mDragDeltaX = event.getX() - this.mDragStartX;
                this.mDragDeltaY = event.getY() - this.mDragStartY;
                mapView.invalidate();
                return true;
            }
        }
        return false;
    }

    private boolean hitTest(MotionEvent event, MapView mapView) {
        return this.mRect.contains((int)event.getX(), (int)event.getY());
    }
}

