/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.views.overlay.gestures;

import android.content.Context;
import android.view.Menu;
import android.view.MenuItem;
import android.view.MotionEvent;
import org.osmdroid.views.MapView;
import org.osmdroid.views.overlay.IOverlayMenuProvider;
import org.osmdroid.views.overlay.Overlay;
import org.osmdroid.views.overlay.gestures.RotationGestureDetector;

public class RotationGestureOverlay
extends Overlay
implements RotationGestureDetector.RotationListener,
IOverlayMenuProvider {
    private static final boolean SHOW_ROTATE_MENU_ITEMS = false;
    private static final int MENU_ENABLED = RotationGestureOverlay.getSafeMenuId();
    private static final int MENU_ROTATE_CCW = RotationGestureOverlay.getSafeMenuId();
    private static final int MENU_ROTATE_CW = RotationGestureOverlay.getSafeMenuId();
    private final RotationGestureDetector mRotationDetector;
    private MapView mMapView;
    private boolean mOptionsMenuEnabled = true;
    long timeLastSet = 0L;
    final long deltaTime = 25L;
    float currentAngle = 0.0f;

    @Deprecated
    public RotationGestureOverlay(Context context, MapView mapView) {
        this(mapView);
    }

    public RotationGestureOverlay(MapView mapView) {
        this.mMapView = mapView;
        this.mRotationDetector = new RotationGestureDetector(this);
    }

    @Override
    public boolean onTouchEvent(MotionEvent event, MapView mapView) {
        this.mRotationDetector.onTouch(event);
        return super.onTouchEvent(event, mapView);
    }

    @Override
    public void onRotate(float deltaAngle) {
        this.currentAngle += deltaAngle;
        if (System.currentTimeMillis() - 25L > this.timeLastSet) {
            this.timeLastSet = System.currentTimeMillis();
            this.mMapView.setMapOrientation(this.mMapView.getMapOrientation() + this.currentAngle);
        }
    }

    @Override
    public void onDetach(MapView map) {
        this.mMapView = null;
    }

    @Override
    public boolean isOptionsMenuEnabled() {
        return this.mOptionsMenuEnabled;
    }

    @Override
    public boolean onCreateOptionsMenu(Menu pMenu, int pMenuIdOffset, MapView pMapView) {
        pMenu.add(0, MENU_ENABLED + pMenuIdOffset, 0, (CharSequence)"Enable rotation").setIcon(17301569);
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean onOptionsItemSelected(MenuItem pItem, int pMenuIdOffset, MapView pMapView) {
        if (pItem.getItemId() == MENU_ENABLED + pMenuIdOffset) {
            if (this.isEnabled()) {
                this.mMapView.setMapOrientation(0.0f);
                this.setEnabled(false);
                return false;
            }
            this.setEnabled(true);
            return true;
        }
        if (pItem.getItemId() == MENU_ROTATE_CCW + pMenuIdOffset) {
            this.mMapView.setMapOrientation(this.mMapView.getMapOrientation() - 10.0f);
            return false;
        }
        if (pItem.getItemId() != MENU_ROTATE_CW + pMenuIdOffset) return false;
        this.mMapView.setMapOrientation(this.mMapView.getMapOrientation() + 10.0f);
        return false;
    }

    @Override
    public boolean onPrepareOptionsMenu(Menu pMenu, int pMenuIdOffset, MapView pMapView) {
        pMenu.findItem(MENU_ENABLED + pMenuIdOffset).setTitle((CharSequence)(this.isEnabled() ? "Disable rotation" : "Enable rotation"));
        return false;
    }

    @Override
    public void setOptionsMenuEnabled(boolean enabled) {
        this.mOptionsMenuEnabled = enabled;
    }

    @Override
    public void setEnabled(boolean pEnabled) {
        this.mRotationDetector.setEnabled(pEnabled);
        super.setEnabled(pEnabled);
    }
}

