/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.views.overlay;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import org.osmdroid.util.GeoPoint;
import org.osmdroid.views.Projection;
import org.osmdroid.views.overlay.Overlay;

@Deprecated
public class GroundOverlay4
extends Overlay {
    private final Paint mPaint = new Paint();
    private Matrix mMatrix = new Matrix();
    protected float mBearing = 0.0f;
    protected float mTransparency;
    private Bitmap mImage;
    private final float[] mMatrixSrc = new float[8];
    private final float[] mMatrixDst = new float[8];
    private GeoPoint mTopLeft;
    private GeoPoint mTopRight;
    private GeoPoint mBottomRight;
    private GeoPoint mBottomLeft;

    public GroundOverlay4() {
        this.setTransparency(0.0f);
    }

    protected Paint getPaint() {
        return this.mPaint;
    }

    protected Matrix getMatrix() {
        return this.mMatrix;
    }

    public Bitmap getImage() {
        return this.mImage;
    }

    public float getBearing() {
        return this.mBearing;
    }

    public void setBearing(float pBearing) {
        this.mBearing = pBearing;
    }

    public void setTransparency(float pTransparency) {
        this.mTransparency = pTransparency;
        this.mPaint.setAlpha(255 - (int)(this.mTransparency * 255.0f));
    }

    public float getTransparency() {
        return this.mTransparency;
    }

    @Override
    public void draw(Canvas pCanvas, Projection pProjection) {
        if (this.mImage == null) {
            return;
        }
        this.computeMatrix(pProjection);
        pCanvas.drawBitmap(this.getImage(), this.getMatrix(), this.getPaint());
    }

    public void setImage(Bitmap pImage) {
        this.mImage = pImage;
        if (this.getImage() == null) {
            return;
        }
        int width = this.getImage().getWidth();
        int height = this.getImage().getHeight();
        this.mMatrixSrc[0] = 0.0f;
        this.mMatrixSrc[1] = 0.0f;
        this.mMatrixSrc[2] = width;
        this.mMatrixSrc[3] = 0.0f;
        this.mMatrixSrc[4] = width;
        this.mMatrixSrc[5] = height;
        this.mMatrixSrc[6] = 0.0f;
        this.mMatrixSrc[7] = height;
    }

    public void setPosition(GeoPoint pTopLeft, GeoPoint pTopRight, GeoPoint pBottomRight, GeoPoint pBottomLeft) {
        this.mTopLeft = new GeoPoint(pTopLeft);
        this.mTopRight = new GeoPoint(pTopRight);
        this.mBottomRight = new GeoPoint(pBottomRight);
        this.mBottomLeft = new GeoPoint(pBottomLeft);
    }

    protected void computeMatrix(Projection pProjection) {
        long topLeftCornerX = pProjection.getLongPixelXFromLongitude(this.mTopLeft.getLongitude());
        long topLeftCornerY = pProjection.getLongPixelYFromLatitude(this.mTopLeft.getLatitude());
        long topRightCornerX = pProjection.getLongPixelXFromLongitude(this.mTopRight.getLongitude());
        long topRightCornerY = pProjection.getLongPixelYFromLatitude(this.mTopRight.getLatitude());
        long bottomRightCornerX = pProjection.getLongPixelXFromLongitude(this.mBottomRight.getLongitude());
        long bottomRightCornerY = pProjection.getLongPixelYFromLatitude(this.mBottomRight.getLatitude());
        long bottomLeftCornerX = pProjection.getLongPixelXFromLongitude(this.mBottomLeft.getLongitude());
        long bottomLeftCornerY = pProjection.getLongPixelYFromLatitude(this.mBottomLeft.getLatitude());
        this.mMatrixDst[0] = topLeftCornerX;
        this.mMatrixDst[1] = topLeftCornerY;
        this.mMatrixDst[2] = topRightCornerX;
        this.mMatrixDst[3] = topRightCornerY;
        this.mMatrixDst[4] = bottomRightCornerX;
        this.mMatrixDst[5] = bottomRightCornerY;
        this.mMatrixDst[6] = bottomLeftCornerX;
        this.mMatrixDst[7] = bottomLeftCornerY;
        this.getMatrix().setPolyToPoly(this.mMatrixSrc, 0, this.mMatrixDst, 0, 4);
    }
}

