/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.util;

import java.util.ArrayList;
import org.osmdroid.util.GeoPoint;

public class PointReducer {
    public static ArrayList<GeoPoint> reduceWithTolerance(ArrayList<GeoPoint> shape, double tolerance) {
        int n = shape.size();
        if (tolerance <= 0.0 || n < 3) {
            return shape;
        }
        boolean[] marked = new boolean[n];
        for (int i = 1; i < n - 1; ++i) {
            marked[i] = false;
        }
        marked[n - 1] = true;
        marked[0] = true;
        PointReducer.douglasPeuckerReduction(shape, marked, tolerance, 0, n - 1);
        ArrayList<GeoPoint> newShape = new ArrayList<GeoPoint>(n);
        for (int i = 0; i < n; ++i) {
            if (!marked[i]) continue;
            newShape.add(shape.get(i));
        }
        return newShape;
    }

    private static void douglasPeuckerReduction(ArrayList<GeoPoint> shape, boolean[] marked, double tolerance, int firstIdx, int lastIdx) {
        if (lastIdx <= firstIdx + 1) {
            return;
        }
        double maxDistance = 0.0;
        int indexFarthest = 0;
        GeoPoint firstPoint = shape.get(firstIdx);
        GeoPoint lastPoint = shape.get(lastIdx);
        for (int idx = firstIdx + 1; idx < lastIdx; ++idx) {
            GeoPoint point = shape.get(idx);
            double distance = PointReducer.orthogonalDistance(point, firstPoint, lastPoint);
            if (!(distance > maxDistance)) continue;
            maxDistance = distance;
            indexFarthest = idx;
        }
        if (maxDistance > tolerance) {
            marked[indexFarthest] = true;
            PointReducer.douglasPeuckerReduction(shape, marked, tolerance, firstIdx, indexFarthest);
            PointReducer.douglasPeuckerReduction(shape, marked, tolerance, indexFarthest, lastIdx);
        }
    }

    public static double orthogonalDistance(GeoPoint point, GeoPoint lineStart, GeoPoint lineEnd) {
        double area = Math.abs((lineStart.getLatitude() * lineEnd.getLongitude() + lineEnd.getLatitude() * point.getLongitude() + point.getLatitude() * lineStart.getLongitude() - lineEnd.getLatitude() * lineStart.getLongitude() - point.getLatitude() * lineEnd.getLongitude() - lineStart.getLatitude() * point.getLongitude()) / 2.0);
        double bottom = Math.hypot(lineStart.getLatitude() - lineEnd.getLatitude(), lineStart.getLongitude() - lineEnd.getLongitude());
        return area / bottom * 2.0;
    }
}

