/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.tileprovider.modules;

import android.util.Log;
import java.io.File;
import java.util.ArrayList;
import org.osmdroid.tileprovider.IMapTileProviderCallback;
import org.osmdroid.tileprovider.IRegisterReceiver;
import org.osmdroid.tileprovider.MapTileProviderArray;
import org.osmdroid.tileprovider.modules.ArchiveFileFactory;
import org.osmdroid.tileprovider.modules.IArchiveFile;
import org.osmdroid.tileprovider.modules.MapTileApproximater;
import org.osmdroid.tileprovider.modules.MapTileFileArchiveProvider;
import org.osmdroid.tileprovider.tilesource.FileBasedTileSource;

public class OfflineTileProvider
extends MapTileProviderArray
implements IMapTileProviderCallback {
    private IArchiveFile[] archives;

    public OfflineTileProvider(IRegisterReceiver pRegisterReceiver, File[] source) {
        super(FileBasedTileSource.getSource(source[0].getName()), pRegisterReceiver);
        ArrayList<IArchiveFile> files = new ArrayList<IArchiveFile>();
        for (File file : source) {
            IArchiveFile temp = ArchiveFileFactory.getArchiveFile(file);
            if (temp != null) {
                files.add(temp);
                continue;
            }
            Log.w((String)"OsmDroid", (String)("Skipping " + file + ", no tile provider is registered to handle the file extension"));
        }
        this.archives = new IArchiveFile[files.size()];
        this.archives = files.toArray(this.archives);
        MapTileFileArchiveProvider mapTileFileArchiveProvider = new MapTileFileArchiveProvider(pRegisterReceiver, this.getTileSource(), this.archives);
        this.mTileProviderList.add(mapTileFileArchiveProvider);
        MapTileApproximater approximationProvider = new MapTileApproximater();
        this.mTileProviderList.add(approximationProvider);
        approximationProvider.addProvider(mapTileFileArchiveProvider);
    }

    public IArchiveFile[] getArchives() {
        return this.archives;
    }

    @Override
    public void detach() {
        if (this.archives != null) {
            for (IArchiveFile file : this.archives) {
                file.close();
            }
        }
        super.detach();
    }

    @Override
    protected boolean isDowngradedMode(long pMapTileIndex) {
        return true;
    }
}

