/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.util;

import org.osmdroid.util.MyMath;
import org.osmdroid.util.PointL;
import org.osmdroid.util.RectL;
import org.osmdroid.util.SegmentIntersection;

public class SpeechBalloonHelper {
    public static final int CORNER_INSIDE = -1;
    public static final int CORNER_NONE = 0;
    public static final int CORNER_LEFT = 1;
    public static final int CORNER_RIGHT = 2;
    public static final int CORNER_TOP = 4;
    public static final int CORNER_BOTTOM = 8;
    private final PointL mTrianglePoint = new PointL();
    private RectL mRect;
    private PointL mPoint;

    public int compute(RectL pInputRect, PointL pInputPoint, double pInputRadius, PointL pOutputIntersection1, PointL pOutputIntersection2) {
        this.mRect = pInputRect;
        this.mPoint = pInputPoint;
        if (pInputRect.contains(this.mPoint.x, this.mPoint.y)) {
            return -1;
        }
        double angle = MyMath.computeAngle(this.mRect.centerX(), this.mRect.centerY(), this.mPoint.x, this.mPoint.y);
        this.computeCirclePoint(this.mTrianglePoint, pInputRadius, angle, false);
        int corner1 = this.checkIntersection(pOutputIntersection1);
        this.computeCirclePoint(this.mTrianglePoint, pInputRadius, angle, true);
        int corner2 = this.checkIntersection(pOutputIntersection2);
        if (corner1 == corner2) {
            return 0;
        }
        return corner1 | corner2;
    }

    private int checkIntersection(PointL pIntersection) {
        if (this.mPoint.y <= this.mRect.top && this.checkIntersectionY(this.mRect.top, pIntersection)) {
            return 4;
        }
        if (this.mPoint.y >= this.mRect.bottom && this.checkIntersectionY(this.mRect.bottom, pIntersection)) {
            return 8;
        }
        if (this.mPoint.x <= this.mRect.left && this.checkIntersectionX(this.mRect.left, pIntersection)) {
            return 1;
        }
        if (this.mPoint.x >= this.mRect.right && this.checkIntersectionX(this.mRect.right, pIntersection)) {
            return 2;
        }
        throw new IllegalArgumentException();
    }

    private boolean checkIntersectionX(long pX, PointL pIntersection) {
        return SegmentIntersection.intersection(this.mPoint.x, this.mPoint.y, this.mTrianglePoint.x, this.mTrianglePoint.y, pX, this.mRect.top, pX, this.mRect.bottom, pIntersection);
    }

    private boolean checkIntersectionY(long pY, PointL pIntersection) {
        return SegmentIntersection.intersection(this.mPoint.x, this.mPoint.y, this.mTrianglePoint.x, this.mTrianglePoint.y, this.mRect.left, pY, this.mRect.right, pY, pIntersection);
    }

    private void computeCirclePoint(PointL pDestination, double pRadius, double pAngle, boolean pFirst) {
        MyMath.computeCirclePoint(this.mRect.centerX(), this.mRect.centerY(), pRadius, pAngle + 1.5707963267948966 * (double)(pFirst ? 1 : -1), pDestination);
    }
}

