/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.util;

import org.osmdroid.views.util.constants.MathConstants;

public class MyMath
implements MathConstants {
    private MyMath() {
    }

    public static double gudermannInverse(double aLatitude) {
        return Math.log(Math.tan(0.7853981633974483 + Math.PI / 180 * aLatitude / 2.0));
    }

    public static double gudermann(double y) {
        return 57.29577951308232 * Math.atan(Math.sinh(y));
    }

    public static int mod(int number, int modulus) {
        if (number > 0) {
            return number % modulus;
        }
        while (number < 0) {
            number += modulus;
        }
        return number;
    }

    public static long floorToLong(double pValue) {
        long result = (long)pValue;
        if ((double)result <= pValue) {
            return result;
        }
        return result - 1L;
    }

    public static int floorToInt(double pValue) {
        int result = (int)pValue;
        if ((double)result <= pValue) {
            return result;
        }
        return result - 1;
    }
}

