/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public class GEMFFile {
    private static final long FILE_SIZE_LIMIT = 0x40000000L;
    private static final int FILE_COPY_BUFFER_SIZE = 1024;
    private static final int VERSION = 4;
    private static final int TILE_SIZE = 256;
    private static final int U32_SIZE = 4;
    private static final int U64_SIZE = 8;
    private final String mLocation;
    private final List<RandomAccessFile> mFiles = new ArrayList<RandomAccessFile>();
    private final List<String> mFileNames = new ArrayList<String>();
    private final List<GEMFRange> mRangeData = new ArrayList<GEMFRange>();
    private final List<Long> mFileSizes = new ArrayList<Long>();
    private final LinkedHashMap<Integer, String> mSources = new LinkedHashMap();
    private boolean mSourceLimited = false;
    private int mCurrentSource = 0;

    public GEMFFile(File pLocation) throws FileNotFoundException, IOException {
        this(pLocation.getAbsolutePath());
    }

    public GEMFFile(String pLocation) throws FileNotFoundException, IOException {
        this.mLocation = pLocation;
        this.openFiles();
        this.readHeader();
    }

    public GEMFFile(String pLocation, List<File> pSourceFolders) throws FileNotFoundException, IOException {
        TreeSet yList;
        this.mLocation = pLocation;
        LinkedHashMap dirIndex = new LinkedHashMap();
        for (File sourceDir : pSourceFolders) {
            LinkedHashMap zList = new LinkedHashMap();
            for (File file : sourceDir.listFiles()) {
                try {
                    Integer.parseInt(file.getName());
                }
                catch (NumberFormatException e) {
                    continue;
                }
                LinkedHashMap xList = new LinkedHashMap();
                for (File xDir : file.listFiles()) {
                    try {
                        Integer.parseInt(xDir.getName());
                    }
                    catch (NumberFormatException e) {
                        continue;
                    }
                    yList = new LinkedHashMap<Integer, File>();
                    for (File yFile : xDir.listFiles()) {
                        try {
                            Integer.parseInt(yFile.getName().substring(0, yFile.getName().indexOf(46)));
                        }
                        catch (NumberFormatException e) {
                            continue;
                        }
                        ((HashMap)((Object)yList)).put(Integer.parseInt(yFile.getName().substring(0, yFile.getName().indexOf(46))), yFile);
                    }
                    xList.put(new Integer(xDir.getName()), yList);
                }
                zList.put(Integer.parseInt(file.getName()), xList);
            }
            dirIndex.put(sourceDir.getName(), zList);
        }
        LinkedHashMap<String, Integer> sourceIndex = new LinkedHashMap<String, Integer>();
        LinkedHashMap<Integer, String> indexSource = new LinkedHashMap<Integer, String>();
        int si = 0;
        for (String source : dirIndex.keySet()) {
            sourceIndex.put(source, new Integer(si));
            indexSource.put(new Integer(si), source);
            ++si;
        }
        ArrayList<GEMFRange> ranges = new ArrayList<GEMFRange>();
        for (String source : dirIndex.keySet()) {
            for (Object zoom : ((LinkedHashMap)dirIndex.get(source)).keySet()) {
                Iterator x22;
                LinkedHashMap ySets = new LinkedHashMap();
                for (Iterator x22 : new TreeSet(((LinkedHashMap)((LinkedHashMap)dirIndex.get(source)).get(zoom)).keySet())) {
                    List<Integer> ySet = new ArrayList();
                    for (Integer y : ((LinkedHashMap)((LinkedHashMap)((LinkedHashMap)dirIndex.get(source)).get(zoom)).get(x22)).keySet()) {
                        ySet.add(y);
                    }
                    if (ySet.size() == 0) continue;
                    Collections.sort(ySet);
                    if (!ySets.containsKey(ySet)) {
                        ySets.put(ySet, new ArrayList());
                    }
                    ((List)ySets.get(ySet)).add(x22);
                }
                LinkedHashMap xSets = new LinkedHashMap();
                for (List<Integer> ySet : ySets.keySet()) {
                    TreeSet xList = new TreeSet((Collection)ySets.get(ySet));
                    ArrayList<Integer> xSet = new ArrayList<Integer>();
                    for (int i = ((Integer)xList.first()).intValue(); i < (Integer)xList.last() + 1; ++i) {
                        if (xList.contains(new Integer(i))) {
                            xSet.add(new Integer(i));
                            continue;
                        }
                        if (xSet.size() <= 0) continue;
                        xSets.put(ySet, xSet);
                        xSet = new ArrayList();
                    }
                    if (xSet.size() <= 0) continue;
                    xSets.put(ySet, xSet);
                }
                x22 = xSets.keySet().iterator();
                while (x22.hasNext()) {
                    List xSet = (List)x22.next();
                    yList = new TreeSet(xSet);
                    TreeSet xList = new TreeSet((Collection)ySets.get(xSet));
                    GEMFRange range = new GEMFRange();
                    range.zoom = zoom;
                    range.sourceIndex = (Integer)sourceIndex.get(source);
                    range.xMin = (Integer)xList.first();
                    range.xMax = (Integer)xList.last();
                    for (int i = ((Integer)yList.first()).intValue(); i < (Integer)yList.last() + 1; ++i) {
                        if (yList.contains(new Integer(i))) {
                            if (range.yMin == null) {
                                range.yMin = i;
                            }
                            range.yMax = i;
                            continue;
                        }
                        if (range.yMin == null) continue;
                        ranges.add(range);
                        range = new GEMFRange();
                        range.zoom = zoom;
                        range.sourceIndex = (Integer)sourceIndex.get(source);
                        range.xMin = (Integer)xList.first();
                        range.xMax = (Integer)xList.last();
                    }
                    if (range.yMin == null) continue;
                    ranges.add(range);
                }
            }
        }
        int source_list_size = 0;
        for (String string : sourceIndex.keySet()) {
            source_list_size += 8 + string.length();
        }
        long offset = 12 + source_list_size + ranges.size() * 32 + 4;
        for (GEMFRange range : ranges) {
            range.offset = offset;
            for (int x = range.xMin.intValue(); x < range.xMax + 1; ++x) {
                for (int y = range.yMin.intValue(); y < range.yMax + 1; ++y) {
                    offset += 12L;
                }
            }
        }
        long headerSize = offset;
        RandomAccessFile gemfFile = new RandomAccessFile(pLocation, "rw");
        gemfFile.writeInt(4);
        gemfFile.writeInt(256);
        gemfFile.writeInt(sourceIndex.size());
        for (String source : sourceIndex.keySet()) {
            gemfFile.writeInt((Integer)sourceIndex.get(source));
            gemfFile.writeInt(source.length());
            gemfFile.write(source.getBytes());
        }
        gemfFile.writeInt(ranges.size());
        for (GEMFRange range : ranges) {
            gemfFile.writeInt(range.zoom);
            gemfFile.writeInt(range.xMin);
            gemfFile.writeInt(range.xMax);
            gemfFile.writeInt(range.yMin);
            gemfFile.writeInt(range.yMax);
            gemfFile.writeInt(range.sourceIndex);
            gemfFile.writeLong(range.offset);
        }
        for (GEMFRange range : ranges) {
            for (int x = range.xMin.intValue(); x < range.xMax + 1; ++x) {
                for (int y = range.yMin.intValue(); y < range.yMax + 1; ++y) {
                    gemfFile.writeLong(offset);
                    long fileSize = ((File)((LinkedHashMap)((LinkedHashMap)((LinkedHashMap)dirIndex.get(indexSource.get(range.sourceIndex))).get(range.zoom)).get(x)).get(y)).length();
                    gemfFile.writeInt((int)fileSize);
                    offset += fileSize;
                }
            }
        }
        byte[] buf = new byte[1024];
        long currentOffset = headerSize;
        int fileIndex = 0;
        for (GEMFRange range : ranges) {
            for (int x = range.xMin.intValue(); x < range.xMax + 1; ++x) {
                for (int y = range.yMin.intValue(); y < range.yMax + 1; ++y) {
                    long fileSize = ((File)((LinkedHashMap)((LinkedHashMap)((LinkedHashMap)dirIndex.get(indexSource.get(range.sourceIndex))).get(range.zoom)).get(x)).get(y)).length();
                    if (currentOffset + fileSize > 0x40000000L) {
                        gemfFile.close();
                        gemfFile = new RandomAccessFile(pLocation + "-" + ++fileIndex, "rw");
                        currentOffset = 0L;
                    } else {
                        currentOffset += fileSize;
                    }
                    FileInputStream tile = new FileInputStream((File)((LinkedHashMap)((LinkedHashMap)((LinkedHashMap)dirIndex.get(indexSource.get(range.sourceIndex))).get(range.zoom)).get(x)).get(y));
                    int read = tile.read(buf, 0, 1024);
                    while (read != -1) {
                        gemfFile.write(buf, 0, read);
                        read = tile.read(buf, 0, 1024);
                    }
                    tile.close();
                }
            }
        }
        gemfFile.close();
        this.openFiles();
        this.readHeader();
    }

    public void close() throws IOException {
        for (RandomAccessFile file : this.mFiles) {
            file.close();
        }
    }

    private void openFiles() throws FileNotFoundException {
        File nextFile;
        File base = new File(this.mLocation);
        this.mFiles.add(new RandomAccessFile(base, "r"));
        this.mFileNames.add(base.getPath());
        int i = 0;
        while ((nextFile = new File(this.mLocation + "-" + ++i)).exists()) {
            this.mFiles.add(new RandomAccessFile(nextFile, "r"));
            this.mFileNames.add(nextFile.getPath());
        }
    }

    private void readHeader() throws IOException {
        RandomAccessFile baseFile = this.mFiles.get(0);
        for (RandomAccessFile file : this.mFiles) {
            this.mFileSizes.add(file.length());
        }
        int version = baseFile.readInt();
        if (version != 4) {
            throw new IOException("Bad file version: " + version);
        }
        int tile_size = baseFile.readInt();
        if (tile_size != 256) {
            throw new IOException("Bad tile size: " + tile_size);
        }
        int sourceCount = baseFile.readInt();
        for (int i = 0; i < sourceCount; ++i) {
            int sourceIndex = baseFile.readInt();
            int sourceNameLength = baseFile.readInt();
            byte[] nameData = new byte[sourceNameLength];
            baseFile.read(nameData, 0, sourceNameLength);
            String sourceName = new String(nameData);
            this.mSources.put(new Integer(sourceIndex), sourceName);
        }
        int num_ranges = baseFile.readInt();
        for (int i = 0; i < num_ranges; ++i) {
            GEMFRange rs = new GEMFRange();
            rs.zoom = baseFile.readInt();
            rs.xMin = baseFile.readInt();
            rs.xMax = baseFile.readInt();
            rs.yMin = baseFile.readInt();
            rs.yMax = baseFile.readInt();
            rs.sourceIndex = baseFile.readInt();
            rs.offset = baseFile.readLong();
            this.mRangeData.add(rs);
        }
    }

    public String getName() {
        return this.mLocation;
    }

    public LinkedHashMap<Integer, String> getSources() {
        return this.mSources;
    }

    public void selectSource(int pSource) {
        if (this.mSources.containsKey(new Integer(pSource))) {
            this.mSourceLimited = true;
            this.mCurrentSource = pSource;
        }
    }

    public void acceptAnySource() {
        this.mSourceLimited = false;
    }

    public Set<Integer> getZoomLevels() {
        TreeSet<Integer> zoomLevels = new TreeSet<Integer>();
        for (GEMFRange rs : this.mRangeData) {
            zoomLevels.add(rs.zoom);
        }
        return zoomLevels;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getInputStream(int pX, int pY, int pZ) {
        GEMFRange range = null;
        for (GEMFRange rs : this.mRangeData) {
            if (pZ != rs.zoom || pX < rs.xMin || pX > rs.xMax || pY < rs.yMin || pY > rs.yMax || this.mSourceLimited && rs.sourceIndex != this.mCurrentSource) continue;
            range = rs;
            break;
        }
        if (range == null) {
            return null;
        }
        ByteArrayInputStream returnValue = null;
        GEMFInputStream stream = null;
        ByteArrayOutputStream byteBuffer = null;
        try {
            int index;
            int numY = range.yMax + 1 - range.yMin;
            int xIndex = pX - range.xMin;
            int yIndex = pY - range.yMin;
            long offset = xIndex * numY + yIndex;
            offset *= 12L;
            RandomAccessFile baseFile = this.mFiles.get(0);
            baseFile.seek(offset += range.offset.longValue());
            long dataOffset = baseFile.readLong();
            int dataLength = baseFile.readInt();
            RandomAccessFile pDataFile = this.mFiles.get(0);
            if (dataOffset > this.mFileSizes.get(0)) {
                int fileListCount = this.mFileSizes.size();
                for (index = 0; index < fileListCount - 1 && dataOffset > this.mFileSizes.get(index); dataOffset -= this.mFileSizes.get(index).longValue(), ++index) {
                }
                pDataFile = this.mFiles.get(index);
            }
            pDataFile.seek(dataOffset);
            stream = new GEMFInputStream(this.mFileNames.get(index), dataOffset, dataLength);
            byteBuffer = new ByteArrayOutputStream();
            int bufferSize = 1024;
            byte[] buffer = new byte[bufferSize];
            int len = 0;
            while (stream.available() > 0) {
                len = stream.read(buffer);
                if (len <= 0) continue;
                byteBuffer.write(buffer, 0, len);
            }
            byte[] bits = byteBuffer.toByteArray();
            returnValue = new ByteArrayInputStream(bits);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (byteBuffer != null) {
                try {
                    byteBuffer.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return returnValue;
    }

    class GEMFInputStream
    extends InputStream {
        RandomAccessFile raf;
        int remainingBytes;

        GEMFInputStream(String filePath, long offset, int length) throws IOException {
            this.raf = new RandomAccessFile(filePath, "r");
            this.raf.seek(offset);
            this.remainingBytes = length;
        }

        @Override
        public int available() {
            return this.remainingBytes;
        }

        @Override
        public void close() throws IOException {
            this.raf.close();
        }

        @Override
        public boolean markSupported() {
            return false;
        }

        @Override
        public int read(byte[] buffer, int offset, int length) throws IOException {
            int read = this.raf.read(buffer, offset, length > this.remainingBytes ? this.remainingBytes : length);
            this.remainingBytes -= read;
            return read;
        }

        @Override
        public int read() throws IOException {
            if (this.remainingBytes > 0) {
                --this.remainingBytes;
                return this.raf.read();
            }
            throw new IOException("End of stream");
        }

        @Override
        public long skip(long byteCount) {
            return 0L;
        }
    }

    private class GEMFRange {
        Integer zoom;
        Integer xMin;
        Integer xMax;
        Integer yMin;
        Integer yMax;
        Integer sourceIndex;
        Long offset;

        private GEMFRange() {
        }

        public String toString() {
            return String.format("GEMF Range: source=%d, zoom=%d, x=%d-%d, y=%d-%d, offset=0x%08X", this.sourceIndex, this.zoom, this.xMin, this.xMax, this.yMin, this.yMax, this.offset);
        }
    }
}

