/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.tileprovider.modules;

import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.util.Log;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.Map;
import org.osmdroid.config.Configuration;
import org.osmdroid.tileprovider.modules.CantContinueException;
import org.osmdroid.tileprovider.modules.IFilesystemCache;
import org.osmdroid.tileprovider.tilesource.BitmapTileSourceBase;
import org.osmdroid.tileprovider.tilesource.OnlineTileSourceBase;
import org.osmdroid.tileprovider.util.Counters;
import org.osmdroid.tileprovider.util.StreamUtils;
import org.osmdroid.util.MapTileIndex;

public class TileDownloader {
    public Drawable downloadTile(long pMapTileIndex, IFilesystemCache pFilesystemCache, OnlineTileSourceBase pTileSource) throws CantContinueException {
        return this.downloadTile(pMapTileIndex, 0, pTileSource.getTileURLString(pMapTileIndex), pFilesystemCache, pTileSource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Drawable downloadTile(long pMapTileIndex, int redirectCount, String targetUrl, IFilesystemCache pFilesystemCache, OnlineTileSourceBase pTileSource) throws CantContinueException {
        Drawable drawable;
        ByteArrayOutputStream dataStream;
        ByteArrayInputStream byteStream;
        HttpURLConnection c;
        BufferedOutputStream out;
        InputStream in;
        block50: {
            String redirectUrl;
            block49: {
                URL old;
                block48: {
                    if (redirectCount > 3) {
                        return null;
                    }
                    in = null;
                    out = null;
                    c = null;
                    byteStream = null;
                    dataStream = null;
                    try {
                        String tileURLString = targetUrl;
                        if (Configuration.getInstance().isDebugMode()) {
                            Log.d((String)"OsmDroid", (String)("Downloading Maptile from url: " + tileURLString));
                        }
                        if (TextUtils.isEmpty((CharSequence)tileURLString)) {
                            Drawable drawable2 = null;
                            return drawable2;
                        }
                        c = Configuration.getInstance().getHttpProxy() != null ? (HttpURLConnection)new URL(tileURLString).openConnection(Configuration.getInstance().getHttpProxy()) : (HttpURLConnection)new URL(tileURLString).openConnection();
                        c.setUseCaches(true);
                        c.setRequestProperty(Configuration.getInstance().getUserAgentHttpHeader(), Configuration.getInstance().getUserAgentValue());
                        for (Map.Entry<String, String> entry : Configuration.getInstance().getAdditionalHttpRequestProperties().entrySet()) {
                            c.setRequestProperty(entry.getKey(), entry.getValue());
                        }
                        c.connect();
                        if (c.getResponseCode() != 200) {
                            switch (c.getResponseCode()) {
                                case 301: 
                                case 302: 
                                case 307: 
                                case 308: {
                                    if (Configuration.getInstance().isMapTileDownloaderFollowRedirects()) {
                                        redirectUrl = c.getHeaderField("Location");
                                        if (redirectUrl == null) break;
                                        if (redirectUrl.startsWith("/")) {
                                            old = new URL(targetUrl);
                                            int port = old.getPort();
                                            boolean secure = targetUrl.toLowerCase().startsWith("https://");
                                            if (port == -1) {
                                                port = targetUrl.toLowerCase().startsWith("http://") ? 80 : 443;
                                            }
                                            redirectUrl = (secure ? "https://" : "http") + old.getHost() + ":" + port + redirectUrl;
                                        }
                                        Log.i((String)"OsmDroid", (String)("Http redirect for MapTile: " + MapTileIndex.toString(pMapTileIndex) + " HTTP response: " + c.getResponseMessage() + " to url " + redirectUrl));
                                        old = this.downloadTile(pMapTileIndex, redirectCount + 1, redirectUrl, pFilesystemCache, pTileSource);
                                        StreamUtils.closeStream(in);
                                        break block48;
                                    }
                                }
                                default: {
                                    Log.w((String)"OsmDroid", (String)("Problem downloading MapTile: " + MapTileIndex.toString(pMapTileIndex) + " HTTP response: " + c.getResponseMessage()));
                                    if (Configuration.getInstance().isDebugMapTileDownloader()) {
                                        Log.d((String)"OsmDroid", (String)tileURLString);
                                    }
                                    ++Counters.tileDownloadErrors;
                                    in = c.getErrorStream();
                                    redirectUrl = null;
                                    StreamUtils.closeStream(in);
                                    break block49;
                                }
                            }
                        }
                        String mime = c.getHeaderField("Content-Type");
                        if (Configuration.getInstance().isDebugMapTileDownloader()) {
                            Log.d((String)"OsmDroid", (String)(tileURLString + " success, mime is " + mime));
                        }
                        if (mime != null && !mime.toLowerCase().contains("image")) {
                            Log.w((String)"OsmDroid", (String)(tileURLString + " success, however the mime type does not appear to be an image " + mime));
                        }
                        in = c.getInputStream();
                        dataStream = new ByteArrayOutputStream();
                        out = new BufferedOutputStream(dataStream, 8192);
                        long expirationTime = this.computeExpirationTime(c.getHeaderField("Expires"), c.getHeaderField("Cache-Control"), System.currentTimeMillis());
                        StreamUtils.copy(in, out);
                        ((OutputStream)out).flush();
                        byte[] data = dataStream.toByteArray();
                        byteStream = new ByteArrayInputStream(data);
                        if (pFilesystemCache != null) {
                            pFilesystemCache.saveFile(pTileSource, pMapTileIndex, byteStream, expirationTime);
                            byteStream.reset();
                        }
                        drawable = pTileSource.getDrawable(byteStream);
                        StreamUtils.closeStream(in);
                        break block50;
                    }
                    catch (UnknownHostException e) {
                        Log.w((String)"OsmDroid", (String)("UnknownHostException downloading MapTile: " + MapTileIndex.toString(pMapTileIndex) + " : " + e));
                        ++Counters.tileDownloadErrors;
                        return null;
                    }
                    catch (BitmapTileSourceBase.LowMemoryException e) {
                        ++Counters.countOOM;
                        Log.w((String)"OsmDroid", (String)("LowMemoryException downloading MapTile: " + MapTileIndex.toString(pMapTileIndex) + " : " + e));
                        throw new CantContinueException(e);
                    }
                    catch (FileNotFoundException e) {
                        ++Counters.tileDownloadErrors;
                        Log.w((String)"OsmDroid", (String)("Tile not found: " + MapTileIndex.toString(pMapTileIndex) + " : " + e));
                        return null;
                    }
                    catch (IOException e) {
                        ++Counters.tileDownloadErrors;
                        Log.w((String)"OsmDroid", (String)("IOException downloading MapTile: " + MapTileIndex.toString(pMapTileIndex) + " : " + e));
                        return null;
                    }
                    catch (Throwable e) {
                        ++Counters.tileDownloadErrors;
                        Log.e((String)"OsmDroid", (String)("Error downloading MapTile: " + MapTileIndex.toString(pMapTileIndex)), (Throwable)e);
                        return null;
                    }
                }
                StreamUtils.closeStream(out);
                StreamUtils.closeStream(byteStream);
                StreamUtils.closeStream(dataStream);
                try {
                    c.disconnect();
                    return old;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return old;
            }
            StreamUtils.closeStream(out);
            StreamUtils.closeStream(byteStream);
            StreamUtils.closeStream(dataStream);
            try {
                c.disconnect();
                return redirectUrl;
            }
            catch (Exception old) {
                // empty catch block
            }
            return redirectUrl;
        }
        StreamUtils.closeStream(out);
        StreamUtils.closeStream(byteStream);
        StreamUtils.closeStream(dataStream);
        try {
            c.disconnect();
            return drawable;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return drawable;
        finally {
            StreamUtils.closeStream(in);
            StreamUtils.closeStream(out);
            StreamUtils.closeStream(byteStream);
            StreamUtils.closeStream(dataStream);
            try {
                c.disconnect();
            }
            catch (Exception e) {}
        }
    }

    public Long getHttpExpiresTime(String pHttpExpiresHeader) {
        block3: {
            if (pHttpExpiresHeader != null && pHttpExpiresHeader.length() > 0) {
                try {
                    Date dateExpires = Configuration.getInstance().getHttpHeaderDateTimeFormat().parse(pHttpExpiresHeader);
                    return dateExpires.getTime();
                }
                catch (Exception ex) {
                    if (!Configuration.getInstance().isDebugMapTileDownloader()) break block3;
                    Log.d((String)"OsmDroid", (String)("Unable to parse expiration tag for tile, server returned " + pHttpExpiresHeader), (Throwable)ex);
                }
            }
        }
        return null;
    }

    public Long getHttpCacheControlDuration(String pHttpCacheControlHeader) {
        block4: {
            if (pHttpCacheControlHeader != null && pHttpCacheControlHeader.length() > 0) {
                try {
                    String[] parts = pHttpCacheControlHeader.split(", ");
                    String maxAge = "max-age=";
                    for (String part : parts) {
                        int pos = part.indexOf("max-age=");
                        if (pos != 0) continue;
                        String durationString = part.substring("max-age=".length());
                        return Long.valueOf(durationString);
                    }
                }
                catch (Exception ex) {
                    if (!Configuration.getInstance().isDebugMapTileDownloader()) break block4;
                    Log.d((String)"OsmDroid", (String)("Unable to parse cache control tag for tile, server returned " + pHttpCacheControlHeader), (Throwable)ex);
                }
            }
        }
        return null;
    }

    public long computeExpirationTime(String pHttpExpiresHeader, String pHttpCacheControlHeader, long pNow) {
        Long override = Configuration.getInstance().getExpirationOverrideDuration();
        if (override != null) {
            return pNow + override;
        }
        long extension = Configuration.getInstance().getExpirationExtendedDuration();
        Long cacheControlDuration = this.getHttpCacheControlDuration(pHttpCacheControlHeader);
        if (cacheControlDuration != null) {
            return pNow + cacheControlDuration * 1000L + extension;
        }
        Long httpExpiresTime = this.getHttpExpiresTime(pHttpExpiresHeader);
        if (httpExpiresTime != null) {
            return httpExpiresTime + extension;
        }
        return pNow + 604800000L + extension;
    }
}

