/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.tileprovider;

import android.graphics.drawable.Drawable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.osmdroid.tileprovider.MapTileCache;
import org.osmdroid.tileprovider.modules.CantContinueException;
import org.osmdroid.tileprovider.modules.MapTileModuleProviderBase;
import org.osmdroid.util.GarbageCollector;
import org.osmdroid.util.MapTileArea;
import org.osmdroid.util.MapTileAreaList;

public class MapTilePreCache {
    private final List<MapTileModuleProviderBase> mProviders = new ArrayList<MapTileModuleProviderBase>();
    private final MapTileAreaList mTileAreas = new MapTileAreaList();
    private Iterator<Long> mTileIndices;
    private final MapTileCache mCache;
    private final GarbageCollector mGC = new GarbageCollector(new Runnable(){

        @Override
        public void run() {
            long next;
            while ((next = MapTilePreCache.this.next()) != -1L) {
                MapTilePreCache.this.search(next);
            }
        }
    });

    public MapTilePreCache(MapTileCache pCache) {
        this.mCache = pCache;
    }

    public void addProvider(MapTileModuleProviderBase pProvider) {
        this.mProviders.add(pProvider);
    }

    public void fill() {
        if (this.mGC.isRunning()) {
            return;
        }
        this.refresh();
        this.mGC.gc();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refresh() {
        MapTileAreaList mapTileAreaList = this.mTileAreas;
        synchronized (mapTileAreaList) {
            int index = 0;
            for (MapTileArea area : this.mCache.getAdditionalMapTileList().getList()) {
                MapTileArea copy;
                if (index < this.mTileAreas.getList().size()) {
                    copy = this.mTileAreas.getList().get(index);
                } else {
                    copy = new MapTileArea();
                    this.mTileAreas.getList().add(copy);
                }
                copy.set(area);
                ++index;
            }
            while (index < this.mTileAreas.getList().size()) {
                this.mTileAreas.getList().remove(this.mTileAreas.getList().size() - 1);
            }
            this.mTileIndices = this.mTileAreas.iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long next() {
        long index;
        Drawable drawable;
        do {
            MapTileAreaList mapTileAreaList = this.mTileAreas;
            synchronized (mapTileAreaList) {
                if (!this.mTileIndices.hasNext()) {
                    return -1L;
                }
                index = this.mTileIndices.next();
            }
        } while ((drawable = this.mCache.getMapTile(index)) != null);
        return index;
    }

    private void search(long pMapTileIndex) {
        for (MapTileModuleProviderBase provider : this.mProviders) {
            try {
                Drawable drawable = provider.getTileLoader().loadTile(pMapTileIndex);
                if (drawable == null) continue;
                this.mCache.putTile(pMapTileIndex, drawable);
                return;
            }
            catch (CantContinueException cantContinueException) {
            }
        }
    }
}

