/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.views.overlay.simplefastpoint;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Point;
import android.view.MotionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.osmdroid.api.IGeoPoint;
import org.osmdroid.util.BoundingBox;
import org.osmdroid.util.GeoPoint;
import org.osmdroid.views.MapView;
import org.osmdroid.views.Projection;
import org.osmdroid.views.overlay.Overlay;
import org.osmdroid.views.overlay.simplefastpoint.LabelledGeoPoint;
import org.osmdroid.views.overlay.simplefastpoint.SimpleFastPointOverlayOptions;
import org.osmdroid.views.overlay.simplefastpoint.StyledLabelledGeoPoint;

public class SimpleFastPointOverlay
extends Overlay {
    private final SimpleFastPointOverlayOptions mStyle;
    private final PointAdapter mPointList;
    private final BoundingBox mBoundingBox;
    private Integer mSelectedPoint;
    private OnClickListener clickListener;
    private List<StyledLabelledPoint> gridIndex;
    private boolean[][] gridBool;
    private int gridWid;
    private int gridHei;
    private int viewWid;
    private int viewHei;
    private boolean hasMoved = false;
    private int numLabels;
    private BoundingBox startBoundingBox;
    private Projection startProjection;
    private BoundingBox prevBoundingBox = new BoundingBox(0.0, 0.0, 0.0, 0.0);

    public SimpleFastPointOverlay(PointAdapter pointList, SimpleFastPointOverlayOptions style) {
        this.mStyle = style;
        this.mPointList = pointList;
        Double east = null;
        Double west = null;
        Double north = null;
        Double south = null;
        for (IGeoPoint p : this.mPointList) {
            if (p == null) continue;
            if (east == null || p.getLongitude() > east) {
                east = p.getLongitude();
            }
            if (west == null || p.getLongitude() < west) {
                west = p.getLongitude();
            }
            if (north == null || p.getLatitude() > north) {
                north = p.getLatitude();
            }
            if (south != null && !(p.getLatitude() < south)) continue;
            south = p.getLatitude();
        }
        this.mBoundingBox = east != null ? new BoundingBox(north, east, south, west) : null;
    }

    public SimpleFastPointOverlay(PointAdapter pointList) {
        this(pointList, SimpleFastPointOverlayOptions.getDefaultStyle());
    }

    private void updateGrid(MapView mapView) {
        this.viewWid = mapView.getWidth();
        this.viewHei = mapView.getHeight();
        this.gridWid = (int)Math.floor((float)this.viewWid / (float)this.mStyle.mCellSize) + 1;
        this.gridHei = (int)Math.floor((float)this.viewHei / (float)this.mStyle.mCellSize) + 1;
        this.gridBool = new boolean[this.gridWid][this.gridHei];
    }

    private void computeGrid(MapView pMapView) {
        BoundingBox viewBBox;
        this.startBoundingBox = viewBBox = pMapView.getBoundingBox();
        this.startProjection = pMapView.getProjection();
        if (viewBBox.getLatNorth() != this.prevBoundingBox.getLatNorth() || viewBBox.getLatSouth() != this.prevBoundingBox.getLatSouth() || viewBBox.getLonWest() != this.prevBoundingBox.getLonWest() || viewBBox.getLonEast() != this.prevBoundingBox.getLonEast()) {
            this.prevBoundingBox = new BoundingBox(viewBBox.getLatNorth(), viewBBox.getLonEast(), viewBBox.getLatSouth(), viewBBox.getLonWest());
            if (this.gridBool == null || this.viewHei != pMapView.getHeight() || this.viewWid != pMapView.getWidth()) {
                this.updateGrid(pMapView);
            } else {
                for (boolean[] row : this.gridBool) {
                    Arrays.fill(row, false);
                }
            }
            Point mPositionPixels = new Point();
            Projection pj = pMapView.getProjection();
            this.gridIndex = new ArrayList<StyledLabelledPoint>();
            this.numLabels = 0;
            for (IGeoPoint pt1 : this.mPointList) {
                if (pt1 == null || !(pt1.getLatitude() > viewBBox.getLatSouth()) || !(pt1.getLatitude() < viewBBox.getLatNorth()) || !(pt1.getLongitude() > viewBBox.getLonWest()) || !(pt1.getLongitude() < viewBBox.getLonEast())) continue;
                pj.toPixels(pt1, mPositionPixels);
                int gridX = (int)Math.floor((float)mPositionPixels.x / (float)this.mStyle.mCellSize);
                int gridY = (int)Math.floor((float)mPositionPixels.y / (float)this.mStyle.mCellSize);
                if (gridX >= this.gridWid || gridY >= this.gridHei || gridX < 0 || gridY < 0 || this.gridBool[gridX][gridY]) continue;
                this.gridBool[gridX][gridY] = true;
                this.gridIndex.add(new StyledLabelledPoint(mPositionPixels, this.mPointList.isLabelled() ? ((LabelledGeoPoint)pt1).getLabel() : null, this.mPointList.isStyled() ? ((StyledLabelledGeoPoint)pt1).getPointStyle() : null, this.mPointList.isStyled() ? ((StyledLabelledGeoPoint)pt1).getTextStyle() : null));
                ++this.numLabels;
            }
        }
    }

    @Override
    public boolean onTouchEvent(MotionEvent event, MapView mapView) {
        if (this.mStyle.mAlgorithm != SimpleFastPointOverlayOptions.RenderingAlgorithm.MAXIMUM_OPTIMIZATION) {
            return false;
        }
        switch (event.getAction()) {
            case 0: {
                this.startBoundingBox = mapView.getBoundingBox();
                this.startProjection = mapView.getProjection();
                break;
            }
            case 2: {
                this.hasMoved = true;
                break;
            }
            case 1: {
                this.hasMoved = false;
                this.startBoundingBox = mapView.getBoundingBox();
                this.startProjection = mapView.getProjection();
                mapView.invalidate();
            }
        }
        return false;
    }

    @Override
    public boolean onSingleTapConfirmed(MotionEvent event, MapView mapView) {
        if (!this.mStyle.mClickable) {
            return false;
        }
        Float minHyp = null;
        int closest = -1;
        Point tmp = new Point();
        Projection pj = mapView.getProjection();
        for (int i = 0; i < this.mPointList.size(); ++i) {
            if (this.mPointList.get(i) == null) continue;
            pj.toPixels(this.mPointList.get(i), tmp);
            if (Math.abs(event.getX() - (float)tmp.x) > 50.0f || Math.abs(event.getY() - (float)tmp.y) > 50.0f) continue;
            float hyp = (event.getX() - (float)tmp.x) * (event.getX() - (float)tmp.x) + (event.getY() - (float)tmp.y) * (event.getY() - (float)tmp.y);
            if (minHyp != null && !(hyp < minHyp.floatValue())) continue;
            minHyp = Float.valueOf(hyp);
            closest = i;
        }
        if (minHyp == null) {
            return false;
        }
        this.setSelectedPoint(closest);
        mapView.invalidate();
        if (this.clickListener != null) {
            this.clickListener.onClick(this.mPointList, closest);
        }
        return true;
    }

    public void setSelectedPoint(Integer toSelect) {
        this.mSelectedPoint = toSelect == null || toSelect < 0 || toSelect >= this.mPointList.size() ? null : toSelect;
    }

    public Integer getSelectedPoint() {
        return this.mSelectedPoint;
    }

    public BoundingBox getBoundingBox() {
        return this.mBoundingBox;
    }

    public void setOnClickListener(OnClickListener listener) {
        this.clickListener = listener;
    }

    @Override
    public void draw(Canvas canvas, MapView mapView, boolean b) {
        if (b) {
            return;
        }
        Point mPositionPixels = new Point();
        Projection pj = mapView.getProjection();
        if (this.mStyle.mPointStyle != null || this.mPointList.isStyled()) {
            switch (this.mStyle.mAlgorithm) {
                case MAXIMUM_OPTIMIZATION: {
                    if (this.gridBool == null || !this.hasMoved && !mapView.isAnimating()) {
                        this.computeGrid(mapView);
                    }
                    GeoPoint nw = new GeoPoint(this.startBoundingBox.getLatNorth(), this.startBoundingBox.getLonWest());
                    GeoPoint se = new GeoPoint(this.startBoundingBox.getLatSouth(), this.startBoundingBox.getLonEast());
                    Point pNw = pj.toPixels(nw, null);
                    Point pSe = pj.toPixels(se, null);
                    Point pStartSe = this.startProjection.toPixels(se, null);
                    Point dGz = new Point(pSe.x - pStartSe.x, pSe.y - pStartSe.y);
                    Point dd = new Point(dGz.x - pNw.x, dGz.y - pNw.y);
                    boolean showLabels = this.mStyle.mLabelPolicy == SimpleFastPointOverlayOptions.LabelPolicy.DENSITY_THRESHOLD && this.numLabels <= this.mStyle.mMaxNShownLabels || this.mStyle.mLabelPolicy == SimpleFastPointOverlayOptions.LabelPolicy.ZOOM_THRESHOLD && mapView.getZoomLevelDouble() >= (double)this.mStyle.mMinZoomShowLabels;
                    for (StyledLabelledPoint slp : this.gridIndex) {
                        Paint textStyle;
                        float tx = slp.x * dd.x / pStartSe.x;
                        float ty = slp.y * dd.y / pStartSe.y;
                        this.drawPointAt(canvas, (float)(slp.x + pNw.x) + tx, (float)(slp.y + pNw.y) + ty, this.mPointList.isLabelled() && showLabels, slp.mlabel, this.mPointList.isStyled() && slp.mPointStyle != null ? slp.mPointStyle : this.mStyle.mPointStyle, this.mPointList.isStyled() && (textStyle = slp.mTextStyle) != null ? textStyle : this.mStyle.mTextStyle);
                    }
                    break;
                }
                case MEDIUM_OPTIMIZATION: {
                    if (this.gridBool == null || this.viewHei != mapView.getHeight() || this.viewWid != mapView.getWidth()) {
                        this.updateGrid(mapView);
                    } else {
                        for (boolean[] row : this.gridBool) {
                            Arrays.fill(row, false);
                        }
                    }
                    boolean showLabels = this.mStyle.mLabelPolicy == SimpleFastPointOverlayOptions.LabelPolicy.ZOOM_THRESHOLD && mapView.getZoomLevelDouble() >= (double)this.mStyle.mMinZoomShowLabels;
                    BoundingBox viewBBox = mapView.getBoundingBox();
                    for (IGeoPoint pt1 : this.mPointList) {
                        Paint textStyle;
                        if (pt1 == null || !(pt1.getLatitude() > viewBBox.getLatSouth()) || !(pt1.getLatitude() < viewBBox.getLatNorth()) || !(pt1.getLongitude() > viewBBox.getLonWest()) || !(pt1.getLongitude() < viewBBox.getLonEast())) continue;
                        pj.toPixels(pt1, mPositionPixels);
                        int gridX = (int)Math.floor((float)mPositionPixels.x / (float)this.mStyle.mCellSize);
                        int gridY = (int)Math.floor((float)mPositionPixels.y / (float)this.mStyle.mCellSize);
                        if (gridX >= this.gridWid || gridY >= this.gridHei || gridX < 0 || gridY < 0 || this.gridBool[gridX][gridY]) continue;
                        this.gridBool[gridX][gridY] = true;
                        this.drawPointAt(canvas, mPositionPixels.x, mPositionPixels.y, this.mPointList.isLabelled() && showLabels, this.mPointList.isLabelled() ? ((LabelledGeoPoint)pt1).getLabel() : null, this.mPointList.isStyled() && ((StyledLabelledGeoPoint)pt1).getPointStyle() != null ? ((StyledLabelledGeoPoint)pt1).getPointStyle() : this.mStyle.mPointStyle, this.mPointList.isStyled() && (textStyle = ((StyledLabelledGeoPoint)pt1).getTextStyle()) != null ? textStyle : this.mStyle.mTextStyle);
                    }
                    break;
                }
                case NO_OPTIMIZATION: {
                    boolean showLabels = this.mStyle.mLabelPolicy == SimpleFastPointOverlayOptions.LabelPolicy.ZOOM_THRESHOLD && mapView.getZoomLevelDouble() >= (double)this.mStyle.mMinZoomShowLabels;
                    BoundingBox viewBBox = mapView.getBoundingBox();
                    for (IGeoPoint pt1 : this.mPointList) {
                        Paint textStyle;
                        if (pt1 == null || !(pt1.getLatitude() > viewBBox.getLatSouth()) || !(pt1.getLatitude() < viewBBox.getLatNorth()) || !(pt1.getLongitude() > viewBBox.getLonWest()) || !(pt1.getLongitude() < viewBBox.getLonEast())) continue;
                        pj.toPixels(pt1, mPositionPixels);
                        this.drawPointAt(canvas, mPositionPixels.x, mPositionPixels.y, this.mPointList.isLabelled() && showLabels, this.mPointList.isLabelled() ? ((LabelledGeoPoint)pt1).getLabel() : null, this.mPointList.isStyled() && ((StyledLabelledGeoPoint)pt1).getPointStyle() != null ? ((StyledLabelledGeoPoint)pt1).getPointStyle() : this.mStyle.mPointStyle, this.mPointList.isStyled() && (textStyle = ((StyledLabelledGeoPoint)pt1).getTextStyle()) != null ? textStyle : this.mStyle.mTextStyle);
                    }
                    break;
                }
            }
        }
        if (this.mSelectedPoint != null && this.mSelectedPoint < this.mPointList.size() && this.mPointList.get(this.mSelectedPoint) != null && this.mStyle.mSelectedPointStyle != null) {
            pj.toPixels(this.mPointList.get(this.mSelectedPoint), mPositionPixels);
            if (this.mStyle.mSymbol == SimpleFastPointOverlayOptions.Shape.CIRCLE) {
                canvas.drawCircle((float)mPositionPixels.x, (float)mPositionPixels.y, this.mStyle.mSelectedCircleRadius, this.mStyle.mSelectedPointStyle);
            } else {
                canvas.drawRect((float)mPositionPixels.x - this.mStyle.mSelectedCircleRadius, (float)mPositionPixels.y - this.mStyle.mSelectedCircleRadius, (float)mPositionPixels.x + this.mStyle.mSelectedCircleRadius, (float)mPositionPixels.y + this.mStyle.mSelectedCircleRadius, this.mStyle.mSelectedPointStyle);
            }
        }
    }

    protected void drawPointAt(Canvas canvas, float x, float y, boolean showLabel, String label, Paint pointStyle, Paint textStyle) {
        if (this.mStyle.mSymbol == SimpleFastPointOverlayOptions.Shape.CIRCLE) {
            canvas.drawCircle(x, y, this.mStyle.mCircleRadius, pointStyle);
        } else {
            canvas.drawRect(x - this.mStyle.mCircleRadius, y - this.mStyle.mCircleRadius, x + this.mStyle.mCircleRadius, y + this.mStyle.mCircleRadius, pointStyle);
        }
        if (showLabel && label != null) {
            canvas.drawText(label, x, y - this.mStyle.mCircleRadius - 5.0f, textStyle);
        }
    }

    public static interface OnClickListener {
        public void onClick(PointAdapter var1, Integer var2);
    }

    public static interface PointAdapter
    extends Iterable<IGeoPoint> {
        public int size();

        public IGeoPoint get(int var1);

        public boolean isLabelled();

        public boolean isStyled();
    }

    public class StyledLabelledPoint
    extends Point {
        private String mlabel;
        private Paint mPointStyle;
        private Paint mTextStyle;

        public StyledLabelledPoint(Point point, String label, Paint pointStyle, Paint textStyle) {
            super(point);
            this.mlabel = label;
            this.mPointStyle = pointStyle;
            this.mTextStyle = textStyle;
        }
    }
}

