/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.views.overlay.infowindow;

import android.content.Context;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import java.util.ArrayList;
import org.osmdroid.api.IGeoPoint;
import org.osmdroid.config.Configuration;
import org.osmdroid.util.GeoPoint;
import org.osmdroid.views.MapView;

public abstract class InfoWindow {
    protected View mView;
    protected boolean mIsVisible;
    protected MapView mMapView;
    protected Object mRelatedObject;
    private IGeoPoint lastPosition = null;
    private float mCurrentMapRotation = 0.0f;
    private double mCurrentMapZoom = 0.0;
    private IGeoPoint mCurrentCenter = null;
    private int mCurrentRenderPointX = Integer.MIN_VALUE;
    private int mCurrentRenderPointY = Integer.MIN_VALUE;

    public InfoWindow(int layoutResId, MapView mapView) {
        this.mMapView = mapView;
        this.mIsVisible = false;
        ViewGroup parent = (ViewGroup)mapView.getParent();
        Context context = mapView.getContext();
        LayoutInflater inflater = (LayoutInflater)context.getSystemService("layout_inflater");
        this.mView = inflater.inflate(layoutResId, parent, false);
        this.mView.setTag((Object)this);
    }

    public InfoWindow(View v, MapView mapView) {
        this.mMapView = mapView;
        this.mIsVisible = false;
        this.mView = v;
        this.mView.setTag((Object)this);
    }

    public void setRelatedObject(Object relatedObject) {
        this.mRelatedObject = relatedObject;
    }

    public Object getRelatedObject() {
        return this.mRelatedObject;
    }

    public MapView getMapView() {
        return this.mMapView;
    }

    public View getView() {
        return this.mView;
    }

    public void open(Object object, GeoPoint position, int offsetX, int offsetY) {
        boolean render = false;
        if (this.mCurrentRenderPointX != offsetX || this.mCurrentRenderPointY != offsetY) {
            render = true;
        }
        if (this.mCurrentCenter == null) {
            render = true;
        }
        if (this.mCurrentCenter != null && this.mMapView != null) {
            IGeoPoint mapCenter = this.mMapView.getMapCenter();
            if (mapCenter.getLatitude() != this.mCurrentCenter.getLatitude() || mapCenter.getLongitude() != this.mCurrentCenter.getLongitude()) {
                render = true;
            }
            if (this.mMapView.getZoomLevelDouble() != this.mCurrentMapZoom) {
                render = true;
            }
            if (this.mMapView.getMapOrientation() != this.mCurrentMapRotation) {
                render = true;
            }
        }
        if (!render && !position.equals(this.lastPosition)) {
            render = true;
        }
        if (render) {
            this.close();
            this.mRelatedObject = object;
            this.lastPosition = position;
            this.mCurrentRenderPointX = offsetX;
            this.mCurrentRenderPointY = offsetY;
            this.onOpen(object);
            MapView.LayoutParams lp = new MapView.LayoutParams(-2, -2, position, 8, offsetX, offsetY);
            if (this.mMapView != null && this.mView != null) {
                this.mCurrentCenter = this.mMapView.getMapCenter();
                this.mCurrentMapZoom = this.mMapView.getZoomLevelDouble();
                this.mCurrentMapRotation = this.mMapView.getMapOrientation();
                this.mMapView.addView(this.mView, lp);
                this.mIsVisible = true;
            } else {
                Log.w((String)"OsmDroid", (String)("Error trapped, InfoWindow.open mMapView: " + (this.mMapView == null ? "null" : "ok") + " mView: " + (this.mView == null ? "null" : "ok")));
            }
        }
    }

    public void close() {
        if (this.mIsVisible) {
            this.mIsVisible = false;
            ((ViewGroup)this.mView.getParent()).removeView(this.mView);
            this.onClose();
        }
        this.mCurrentRenderPointX = Integer.MIN_VALUE;
        this.mCurrentRenderPointY = Integer.MIN_VALUE;
    }

    public void onDetach() {
        this.close();
        if (this.mView != null) {
            this.mView.setTag(null);
        }
        this.mView = null;
        this.mMapView = null;
        if (Configuration.getInstance().isDebugMode()) {
            Log.d((String)"OsmDroid", (String)"Marked detached");
        }
    }

    public boolean isOpen() {
        return this.mIsVisible;
    }

    public static void closeAllInfoWindowsOn(MapView mapView) {
        ArrayList<InfoWindow> opened = InfoWindow.getOpenedInfoWindowsOn(mapView);
        for (InfoWindow infoWindow : opened) {
            infoWindow.close();
        }
    }

    public static ArrayList<InfoWindow> getOpenedInfoWindowsOn(MapView mapView) {
        int count = mapView.getChildCount();
        ArrayList<InfoWindow> opened = new ArrayList<InfoWindow>(count);
        for (int i = 0; i < count; ++i) {
            View child = mapView.getChildAt(i);
            Object tag = child.getTag();
            if (tag == null || !(tag instanceof InfoWindow)) continue;
            InfoWindow infoWindow = (InfoWindow)tag;
            opened.add(infoWindow);
        }
        return opened;
    }

    public abstract void onOpen(Object var1);

    public abstract void onClose();
}

