/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.util;

import org.osmdroid.util.MapTileIndex;

public class MapTileList {
    private long[] mTileIndices;
    private int mSize;

    public MapTileList() {
        this(1);
    }

    public MapTileList(int initialCapacity) {
        this.mTileIndices = new long[initialCapacity];
    }

    public void clear() {
        this.mSize = 0;
    }

    public int getSize() {
        return this.mSize;
    }

    public long get(int pIndex) {
        return this.mTileIndices[pIndex];
    }

    public void put(long pTileIndex) {
        this.ensureCapacity(this.mSize + 1);
        this.mTileIndices[this.mSize++] = pTileIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ensureCapacity(int pCapacity) {
        if (this.mTileIndices.length >= pCapacity) {
            return;
        }
        MapTileList mapTileList = this;
        synchronized (mapTileList) {
            long[] tmp = new long[pCapacity];
            System.arraycopy(this.mTileIndices, 0, tmp, 0, this.mTileIndices.length);
            this.mTileIndices = tmp;
        }
    }

    public boolean contains(long pTileIndex) {
        for (int i = 0; i < this.mSize; ++i) {
            if (this.mTileIndices[i] != pTileIndex) continue;
            return true;
        }
        return false;
    }

    public void populateFrom(MapTileList pSource, int pZoomDelta) {
        for (int i = 0; i < pSource.mSize; ++i) {
            long sourceIndex = pSource.mTileIndices[i];
            int sourceZoom = MapTileIndex.getZoom(sourceIndex);
            int destZoom = sourceZoom + pZoomDelta;
            if (destZoom < 0 || destZoom > MapTileIndex.mMaxZoomLevel) continue;
            int sourceX = MapTileIndex.getX(sourceIndex);
            int sourceY = MapTileIndex.getY(sourceIndex);
            if (pZoomDelta <= 0) {
                this.put(MapTileIndex.getTileIndex(destZoom, sourceX >> -pZoomDelta, sourceY >> -pZoomDelta));
                continue;
            }
            int power = 1 << pZoomDelta;
            int destX = sourceX << pZoomDelta;
            int destY = sourceY << pZoomDelta;
            for (int j = 0; j < power; ++j) {
                for (int k = 0; k < power; ++k) {
                    this.put(MapTileIndex.getTileIndex(destZoom, destX + j, destY + k));
                }
            }
        }
    }

    public long[] toArray() {
        long[] result = new long[this.mSize];
        System.arraycopy(this.mTileIndices, 0, result, 0, this.mSize);
        return result;
    }
}

