/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.views;

import android.animation.Animator;
import android.animation.ValueAnimator;
import android.annotation.TargetApi;
import android.graphics.Point;
import android.os.Build;
import android.view.View;
import android.view.animation.Animation;
import android.view.animation.ScaleAnimation;
import java.util.LinkedList;
import org.osmdroid.api.IGeoPoint;
import org.osmdroid.api.IMapController;
import org.osmdroid.config.Configuration;
import org.osmdroid.events.MapListener;
import org.osmdroid.events.ScrollEvent;
import org.osmdroid.events.ZoomEvent;
import org.osmdroid.util.BoundingBox;
import org.osmdroid.views.MapView;
import org.osmdroid.views.util.MyMath;

public class MapController
implements IMapController,
MapView.OnFirstLayoutListener {
    protected final MapView mMapView;
    private ScaleAnimation mZoomInAnimationOld;
    private ScaleAnimation mZoomOutAnimationOld;
    private double mTargetZoomLevel = 0.0;
    private Animator mCurrentAnimator;
    private ReplayController mReplayController;

    public MapController(MapView mapView) {
        this.mMapView = mapView;
        this.mReplayController = new ReplayController();
        if (!this.mMapView.isLayoutOccurred()) {
            this.mMapView.addOnFirstLayoutListener(this);
        }
        if (Build.VERSION.SDK_INT < 11) {
            ZoomAnimationListener zoomAnimationListener = new ZoomAnimationListener(this);
            this.mZoomInAnimationOld = new ScaleAnimation(1.0f, 2.0f, 1.0f, 2.0f, 1, 0.5f, 1, 0.5f);
            this.mZoomOutAnimationOld = new ScaleAnimation(1.0f, 0.5f, 1.0f, 0.5f, 1, 0.5f, 1, 0.5f);
            this.mZoomInAnimationOld.setDuration((long)Configuration.getInstance().getAnimationSpeedShort());
            this.mZoomOutAnimationOld.setDuration((long)Configuration.getInstance().getAnimationSpeedShort());
            this.mZoomInAnimationOld.setAnimationListener((Animation.AnimationListener)zoomAnimationListener);
            this.mZoomOutAnimationOld.setAnimationListener((Animation.AnimationListener)zoomAnimationListener);
        }
    }

    @Override
    public void onFirstLayout(View v, int left, int top, int right, int bottom) {
        this.mReplayController.replayCalls();
    }

    @Override
    public void zoomToSpan(double latSpan, double lonSpan) {
        double curLonSpan;
        double diffNeededLon;
        if (latSpan <= 0.0 || lonSpan <= 0.0) {
            return;
        }
        if (!this.mMapView.isLayoutOccurred()) {
            this.mReplayController.zoomToSpan(latSpan, lonSpan);
            return;
        }
        BoundingBox bb = this.mMapView.getProjection().getBoundingBox();
        double curZoomLevel = this.mMapView.getProjection().getZoomLevel();
        double curLatSpan = bb.getLatitudeSpan();
        double diffNeededLat = latSpan / curLatSpan;
        double diffNeeded = Math.max(diffNeededLat, diffNeededLon = lonSpan / (curLonSpan = bb.getLongitudeSpan()));
        if (diffNeeded > 1.0) {
            this.mMapView.setZoomLevel(curZoomLevel - (double)MyMath.getNextSquareNumberAbove((float)diffNeeded));
        } else if (diffNeeded < 0.5) {
            this.mMapView.setZoomLevel(curZoomLevel + (double)MyMath.getNextSquareNumberAbove(1.0f / (float)diffNeeded) - 1.0);
        }
    }

    @Override
    public void zoomToSpan(int latSpanE6, int lonSpanE6) {
        this.zoomToSpan((double)latSpanE6 * 1.0E-6, (double)lonSpanE6 * 1.0E-6);
    }

    @Override
    public void animateTo(IGeoPoint point) {
        if (!this.mMapView.isLayoutOccurred()) {
            this.mReplayController.animateTo(point);
            return;
        }
        Point p = this.mMapView.getProjection().toPixels(point, null);
        this.animateTo(p.x, p.y);
    }

    @Override
    public void animateTo(int x, int y) {
        if (!this.mMapView.isLayoutOccurred()) {
            this.mReplayController.animateTo(x, y);
            return;
        }
        if (!this.mMapView.isAnimating()) {
            this.mMapView.mIsFlinging = false;
            int xStart = (int)this.mMapView.getMapScrollX();
            int yStart = (int)this.mMapView.getMapScrollY();
            int dx = x - this.mMapView.getWidth() / 2;
            int dy = y - this.mMapView.getHeight() / 2;
            if (dx != xStart || dy != yStart) {
                this.mMapView.getScroller().startScroll(xStart, yStart, dx, dy, Configuration.getInstance().getAnimationSpeedDefault());
                this.mMapView.postInvalidate();
            }
        }
    }

    @Override
    public void scrollBy(int x, int y) {
        this.mMapView.scrollBy(x, y);
    }

    @Override
    public void setCenter(IGeoPoint point) {
        for (MapListener mapListener : this.mMapView.mListners) {
            mapListener.onScroll(new ScrollEvent(this.mMapView, 0, 0));
        }
        if (!this.mMapView.isLayoutOccurred()) {
            this.mReplayController.setCenter(point);
            return;
        }
        this.mMapView.setExpectedCenter(point);
    }

    @Override
    public void stopPanning() {
        this.mMapView.mIsFlinging = false;
        this.mMapView.getScroller().forceFinished(true);
    }

    @Override
    public void stopAnimation(boolean jumpToTarget) {
        if (!this.mMapView.getScroller().isFinished()) {
            if (jumpToTarget) {
                this.mMapView.mIsFlinging = false;
                this.mMapView.getScroller().abortAnimation();
            } else {
                this.stopPanning();
            }
        }
        if (Build.VERSION.SDK_INT >= 11) {
            Animator currentAnimator = this.mCurrentAnimator;
            if (this.mMapView.mIsAnimating.get()) {
                currentAnimator.end();
            }
        } else if (this.mMapView.mIsAnimating.get()) {
            this.mMapView.clearAnimation();
        }
    }

    @Override
    public int setZoom(int zoomlevel) {
        return (int)this.setZoom((double)zoomlevel);
    }

    @Override
    public double setZoom(double pZoomlevel) {
        return this.mMapView.setZoomLevel(pZoomlevel);
    }

    @Override
    public boolean zoomIn() {
        return this.zoomIn(null);
    }

    @Override
    public boolean zoomIn(Long animationSpeed) {
        return this.zoomTo(this.mMapView.getZoomLevelDouble() + 1.0, animationSpeed);
    }

    @Override
    public boolean zoomInFixing(int xPixel, int yPixel, Long zoomAnimation) {
        return this.zoomToFixing(this.mMapView.getZoomLevelDouble() + 1.0, xPixel, yPixel, zoomAnimation);
    }

    @Override
    public boolean zoomInFixing(int xPixel, int yPixel) {
        return this.zoomInFixing(xPixel, yPixel, null);
    }

    @Override
    public boolean zoomOut(Long animationSpeed) {
        return this.zoomTo(this.mMapView.getZoomLevelDouble() - 1.0, animationSpeed);
    }

    @Override
    public boolean zoomOut() {
        return this.zoomOut(null);
    }

    @Override
    @Deprecated
    public boolean zoomOutFixing(int xPixel, int yPixel) {
        return this.zoomToFixing(this.mMapView.getZoomLevelDouble() - 1.0, xPixel, yPixel, null);
    }

    @Override
    public boolean zoomTo(int zoomLevel) {
        return this.zoomTo(zoomLevel, (Long)null);
    }

    @Override
    public boolean zoomTo(int zoomLevel, Long animationSpeed) {
        return this.zoomTo((double)zoomLevel, animationSpeed);
    }

    @Override
    public boolean zoomToFixing(int zoomLevel, int xPixel, int yPixel, Long zoomAnimationSpeed) {
        return this.zoomToFixing((double)zoomLevel, xPixel, yPixel, zoomAnimationSpeed);
    }

    @Override
    public boolean zoomTo(double pZoomLevel, Long animationSpeed) {
        return this.zoomToFixing(pZoomLevel, this.mMapView.getWidth() / 2, this.mMapView.getHeight() / 2, animationSpeed);
    }

    @Override
    public boolean zoomTo(double pZoomLevel) {
        return this.zoomTo(pZoomLevel, null);
    }

    @Override
    public boolean zoomToFixing(double zoomLevel, int xPixel, int yPixel, Long zoomAnimationSpeed) {
        boolean canZoom;
        zoomLevel = zoomLevel > this.mMapView.getMaxZoomLevel() ? this.mMapView.getMaxZoomLevel() : zoomLevel;
        zoomLevel = zoomLevel < this.mMapView.getMinZoomLevel() ? this.mMapView.getMinZoomLevel() : zoomLevel;
        double currentZoomLevel = this.mMapView.getZoomLevelDouble();
        boolean bl = canZoom = zoomLevel < currentZoomLevel && this.mMapView.canZoomOut() || zoomLevel > currentZoomLevel && this.mMapView.canZoomIn();
        if (!canZoom) {
            return false;
        }
        if (this.mMapView.mIsAnimating.getAndSet(true)) {
            return false;
        }
        for (MapListener mapListener : this.mMapView.mListners) {
            mapListener.onZoom(new ZoomEvent(this.mMapView, zoomLevel));
        }
        this.mMapView.setMultiTouchScaleInitPoint(xPixel, yPixel);
        this.mMapView.startAnimation();
        float end = (float)Math.pow(2.0, zoomLevel - currentZoomLevel);
        if (Build.VERSION.SDK_INT >= 11) {
            ZoomAnimatorListener zoomAnimatorListener = new ZoomAnimatorListener(this);
            ValueAnimator zoomToAnimator = ValueAnimator.ofFloat((float[])new float[]{1.0f, end});
            zoomToAnimator.addListener((Animator.AnimatorListener)zoomAnimatorListener);
            zoomToAnimator.addUpdateListener((ValueAnimator.AnimatorUpdateListener)zoomAnimatorListener);
            if (zoomAnimationSpeed == null) {
                zoomToAnimator.setDuration((long)Configuration.getInstance().getAnimationSpeedShort());
            } else {
                zoomToAnimator.setDuration(zoomAnimationSpeed.longValue());
            }
            this.mCurrentAnimator = zoomToAnimator;
            zoomToAnimator.start();
            return true;
        }
        this.mTargetZoomLevel = zoomLevel;
        if (zoomLevel > currentZoomLevel) {
            this.mMapView.startAnimation((Animation)this.mZoomInAnimationOld);
        } else {
            this.mMapView.startAnimation((Animation)this.mZoomOutAnimationOld);
        }
        ScaleAnimation scaleAnimation = new ScaleAnimation(1.0f, end, 1.0f, end, 1, 0.5f, 1, 0.5f);
        if (zoomAnimationSpeed == null) {
            scaleAnimation.setDuration((long)Configuration.getInstance().getAnimationSpeedShort());
        } else {
            scaleAnimation.setDuration(zoomAnimationSpeed.longValue());
        }
        scaleAnimation.setAnimationListener((Animation.AnimationListener)new ZoomAnimationListener(this));
        return true;
    }

    @Override
    public boolean zoomToFixing(double zoomLevel, int xPixel, int yPixel) {
        return this.zoomToFixing(zoomLevel, xPixel, yPixel, null);
    }

    @Override
    public boolean zoomToFixing(int zoomLevel, int xPixel, int yPixel) {
        return this.zoomToFixing(zoomLevel, xPixel, yPixel, (Long)null);
    }

    protected void onAnimationStart() {
        this.mMapView.mIsAnimating.set(true);
    }

    protected void onAnimationEnd() {
        this.mMapView.mIsAnimating.set(false);
        this.mMapView.resetMultiTouchScale();
        if (Build.VERSION.SDK_INT >= 11) {
            this.mCurrentAnimator = null;
        } else {
            this.mMapView.clearAnimation();
            this.mZoomInAnimationOld.reset();
            this.mZoomOutAnimationOld.reset();
            this.setZoom(this.mTargetZoomLevel);
        }
    }

    private class ReplayController {
        private LinkedList<ReplayClass> mReplayList = new LinkedList();

        private ReplayController() {
        }

        public void animateTo(IGeoPoint geoPoint) {
            this.mReplayList.add(new ReplayClass(ReplayType.AnimateToGeoPoint, null, geoPoint));
        }

        public void animateTo(int x, int y) {
            this.mReplayList.add(new ReplayClass(ReplayType.AnimateToPoint, new Point(x, y), null));
        }

        public void setCenter(IGeoPoint geoPoint) {
            this.mReplayList.add(new ReplayClass(ReplayType.SetCenterPoint, null, geoPoint));
        }

        public void zoomToSpan(int x, int y) {
            this.mReplayList.add(new ReplayClass(ReplayType.ZoomToSpanPoint, new Point(x, y), null));
        }

        public void zoomToSpan(double x, double y) {
            this.mReplayList.add(new ReplayClass(ReplayType.ZoomToSpanPoint, new Point((int)(x * 1000000.0), (int)(y * 1000000.0)), null));
        }

        public void replayCalls() {
            for (ReplayClass replay : this.mReplayList) {
                switch (replay.mReplayType) {
                    case AnimateToGeoPoint: {
                        if (replay.mGeoPoint == null) break;
                        MapController.this.animateTo(replay.mGeoPoint);
                        break;
                    }
                    case AnimateToPoint: {
                        if (replay.mPoint == null) break;
                        MapController.this.animateTo(((ReplayClass)replay).mPoint.x, ((ReplayClass)replay).mPoint.y);
                        break;
                    }
                    case SetCenterPoint: {
                        if (replay.mGeoPoint == null) break;
                        MapController.this.setCenter(replay.mGeoPoint);
                        break;
                    }
                    case ZoomToSpanPoint: {
                        if (replay.mPoint == null) break;
                        MapController.this.zoomToSpan(((ReplayClass)replay).mPoint.x, ((ReplayClass)replay).mPoint.y);
                    }
                }
            }
            this.mReplayList.clear();
        }

        private class ReplayClass {
            private ReplayType mReplayType;
            private Point mPoint;
            private IGeoPoint mGeoPoint;

            public ReplayClass(ReplayType mReplayType, Point mPoint, IGeoPoint mGeoPoint) {
                this.mReplayType = mReplayType;
                this.mPoint = mPoint;
                this.mGeoPoint = mGeoPoint;
            }
        }
    }

    private static enum ReplayType {
        ZoomToSpanPoint,
        AnimateToPoint,
        AnimateToGeoPoint,
        SetCenterPoint;

    }

    protected static class ZoomAnimationListener
    implements Animation.AnimationListener {
        private MapController mMapController;

        public ZoomAnimationListener(MapController mapController) {
            this.mMapController = mapController;
        }

        public void onAnimationStart(Animation animation) {
            this.mMapController.onAnimationStart();
        }

        public void onAnimationEnd(Animation animation) {
            this.mMapController.onAnimationEnd();
        }

        public void onAnimationRepeat(Animation animation) {
        }
    }

    @TargetApi(value=11)
    private static class ZoomAnimatorListener
    implements Animator.AnimatorListener,
    ValueAnimator.AnimatorUpdateListener {
        private MapController mMapController;

        public ZoomAnimatorListener(MapController mapController) {
            this.mMapController = mapController;
        }

        public void onAnimationStart(Animator animator) {
            this.mMapController.onAnimationStart();
        }

        public void onAnimationEnd(Animator animator) {
            this.mMapController.onAnimationEnd();
        }

        public void onAnimationCancel(Animator animator) {
        }

        public void onAnimationRepeat(Animator animator) {
        }

        public void onAnimationUpdate(ValueAnimator valueAnimator) {
            this.mMapController.mMapView.setMultiTouchScale(((Float)valueAnimator.getAnimatedValue()).floatValue());
            this.mMapController.mMapView.invalidate();
        }
    }
}

