/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.tileprovider.modules;

import android.graphics.drawable.Drawable;
import android.util.Log;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import org.osmdroid.config.Configuration;
import org.osmdroid.tileprovider.ExpirableBitmapDrawable;
import org.osmdroid.tileprovider.MapTileRequestState;
import org.osmdroid.tileprovider.modules.ConfigurablePriorityThreadFactory;
import org.osmdroid.tileprovider.tilesource.ITileSource;
import org.osmdroid.util.MapTileIndex;

public abstract class MapTileModuleProviderBase {
    private final ExecutorService mExecutor;
    protected final Object mQueueLockObject = new Object();
    protected final HashMap<Long, MapTileRequestState> mWorking;
    protected final LinkedHashMap<Long, MapTileRequestState> mPending;

    protected abstract String getName();

    protected abstract String getThreadGroupName();

    public abstract TileLoader getTileLoader();

    public abstract boolean getUsesDataConnection();

    public abstract int getMinimumZoomLevel();

    public abstract int getMaximumZoomLevel();

    public abstract void setTileSource(ITileSource var1);

    public MapTileModuleProviderBase(int pThreadPoolSize, final int pPendingQueueSize) {
        if (pPendingQueueSize < pThreadPoolSize) {
            Log.w((String)"OsmDroid", (String)"The pending queue size is smaller than the thread pool size. Automatically reducing the thread pool size.");
            pThreadPoolSize = pPendingQueueSize;
        }
        this.mExecutor = Executors.newFixedThreadPool(pThreadPoolSize, new ConfigurablePriorityThreadFactory(5, this.getThreadGroupName()));
        this.mWorking = new HashMap();
        this.mPending = new LinkedHashMap<Long, MapTileRequestState>(pPendingQueueSize + 2, 0.1f, true){
            private static final long serialVersionUID = 6455337315681858866L;

            @Override
            protected boolean removeEldestEntry(Map.Entry<Long, MapTileRequestState> pEldest) {
                if (this.size() > pPendingQueueSize) {
                    Long result = null;
                    Iterator<Long> iterator = MapTileModuleProviderBase.this.mPending.keySet().iterator();
                    while (result == null && iterator.hasNext()) {
                        Long mapTileIndex = iterator.next();
                        if (MapTileModuleProviderBase.this.mWorking.containsKey(mapTileIndex)) continue;
                        result = mapTileIndex;
                    }
                    if (result != null) {
                        MapTileRequestState state = MapTileModuleProviderBase.this.mPending.get(result);
                        MapTileModuleProviderBase.this.removeTileFromQueues(result);
                        state.getCallback().mapTileRequestFailedExceedsMaxQueueSize(state);
                    }
                }
                return false;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadMapTileAsync(MapTileRequestState pState) {
        if (this.mExecutor.isShutdown()) {
            return;
        }
        Object object = this.mQueueLockObject;
        synchronized (object) {
            if (Configuration.getInstance().isDebugTileProviders()) {
                Log.d((String)"OsmDroid", (String)("MapTileModuleProviderBase.loadMaptileAsync() on provider: " + this.getName() + " for tile: " + MapTileIndex.toString(pState.getMapTile())));
                if (this.mPending.containsKey(pState.getMapTile())) {
                    Log.d((String)"OsmDroid", (String)"MapTileModuleProviderBase.loadMaptileAsync() tile already exists in request queue for modular provider. Moving to front of queue.");
                } else {
                    Log.d((String)"OsmDroid", (String)"MapTileModuleProviderBase.loadMaptileAsync() adding tile to request queue for modular provider.");
                }
            }
            this.mPending.put(pState.getMapTile(), pState);
        }
        try {
            this.mExecutor.execute(this.getTileLoader());
        }
        catch (RejectedExecutionException e) {
            Log.w((String)"OsmDroid", (String)"RejectedExecutionException", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearQueue() {
        Object object = this.mQueueLockObject;
        synchronized (object) {
            this.mPending.clear();
            this.mWorking.clear();
        }
    }

    public void detach() {
        this.clearQueue();
        this.mExecutor.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeTileFromQueues(long pMapTileIndex) {
        Object object = this.mQueueLockObject;
        synchronized (object) {
            if (Configuration.getInstance().isDebugTileProviders()) {
                Log.d((String)"OsmDroid", (String)("MapTileModuleProviderBase.removeTileFromQueues() on provider: " + this.getName() + " for tile: " + MapTileIndex.toString(pMapTileIndex)));
            }
            this.mPending.remove(pMapTileIndex);
            this.mWorking.remove(pMapTileIndex);
        }
    }

    public class CantContinueException
    extends Exception {
        private static final long serialVersionUID = 146526524087765133L;

        public CantContinueException(String pDetailMessage) {
            super(pDetailMessage);
        }

        public CantContinueException(Throwable pThrowable) {
            super(pThrowable);
        }
    }

    public abstract class TileLoader
    implements Runnable {
        public abstract Drawable loadTile(long var1) throws CantContinueException;

        @Deprecated
        protected Drawable loadTile(MapTileRequestState pState) throws CantContinueException {
            return this.loadTile(pState.getMapTile());
        }

        protected void onTileLoaderInit() {
        }

        protected void onTileLoaderShutdown() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected MapTileRequestState nextTile() {
            Object object = MapTileModuleProviderBase.this.mQueueLockObject;
            synchronized (object) {
                Long result = null;
                for (Long mapTileIndex : MapTileModuleProviderBase.this.mPending.keySet()) {
                    if (MapTileModuleProviderBase.this.mWorking.containsKey(mapTileIndex)) continue;
                    if (Configuration.getInstance().isDebugTileProviders()) {
                        Log.d((String)"OsmDroid", (String)("TileLoader.nextTile() on provider: " + MapTileModuleProviderBase.this.getName() + " found tile in working queue: " + MapTileIndex.toString(mapTileIndex)));
                    }
                    result = mapTileIndex;
                }
                if (result != null) {
                    if (Configuration.getInstance().isDebugTileProviders()) {
                        Log.d((String)"OsmDroid", (String)("TileLoader.nextTile() on provider: " + MapTileModuleProviderBase.this.getName() + " adding tile to working queue: " + result));
                    }
                    MapTileModuleProviderBase.this.mWorking.put(result, MapTileModuleProviderBase.this.mPending.get(result));
                }
                return result != null ? MapTileModuleProviderBase.this.mPending.get(result) : null;
            }
        }

        protected void tileLoaded(MapTileRequestState pState, Drawable pDrawable) {
            if (Configuration.getInstance().isDebugTileProviders()) {
                Log.d((String)"OsmDroid", (String)("TileLoader.tileLoaded() on provider: " + MapTileModuleProviderBase.this.getName() + " with tile: " + MapTileIndex.toString(pState.getMapTile())));
            }
            MapTileModuleProviderBase.this.removeTileFromQueues(pState.getMapTile());
            ExpirableBitmapDrawable.setState(pDrawable, -1);
            pState.getCallback().mapTileRequestCompleted(pState, pDrawable);
        }

        protected void tileLoadedExpired(MapTileRequestState pState, Drawable pDrawable) {
            if (Configuration.getInstance().isDebugTileProviders()) {
                Log.d((String)"OsmDroid", (String)("TileLoader.tileLoadedExpired() on provider: " + MapTileModuleProviderBase.this.getName() + " with tile: " + MapTileIndex.toString(pState.getMapTile())));
            }
            MapTileModuleProviderBase.this.removeTileFromQueues(pState.getMapTile());
            ExpirableBitmapDrawable.setState(pDrawable, -2);
            pState.getCallback().mapTileRequestExpiredTile(pState, pDrawable);
        }

        protected void tileLoadedScaled(MapTileRequestState pState, Drawable pDrawable) {
            if (Configuration.getInstance().isDebugTileProviders()) {
                Log.d((String)"OsmDroid", (String)("TileLoader.tileLoadedScaled() on provider: " + MapTileModuleProviderBase.this.getName() + " with tile: " + MapTileIndex.toString(pState.getMapTile())));
            }
            MapTileModuleProviderBase.this.removeTileFromQueues(pState.getMapTile());
            ExpirableBitmapDrawable.setState(pDrawable, -3);
            pState.getCallback().mapTileRequestExpiredTile(pState, pDrawable);
        }

        protected void tileLoadedFailed(MapTileRequestState pState) {
            if (Configuration.getInstance().isDebugTileProviders()) {
                Log.d((String)"OsmDroid", (String)("TileLoader.tileLoadedFailed() on provider: " + MapTileModuleProviderBase.this.getName() + " with tile: " + MapTileIndex.toString(pState.getMapTile())));
            }
            MapTileModuleProviderBase.this.removeTileFromQueues(pState.getMapTile());
            pState.getCallback().mapTileRequestFailed(pState);
        }

        @Override
        public final void run() {
            MapTileRequestState state;
            this.onTileLoaderInit();
            Drawable result = null;
            while ((state = this.nextTile()) != null) {
                if (Configuration.getInstance().isDebugTileProviders()) {
                    Log.d((String)"OsmDroid", (String)("TileLoader.run() processing next tile: " + MapTileIndex.toString(state.getMapTile()) + ", pending:" + MapTileModuleProviderBase.this.mPending.size() + ", working:" + MapTileModuleProviderBase.this.mWorking.size()));
                }
                try {
                    result = null;
                    result = this.loadTile(state.getMapTile());
                }
                catch (CantContinueException e) {
                    Log.i((String)"OsmDroid", (String)("Tile loader can't continue: " + MapTileIndex.toString(state.getMapTile())), (Throwable)e);
                    MapTileModuleProviderBase.this.clearQueue();
                }
                catch (Throwable e) {
                    Log.i((String)"OsmDroid", (String)("Error downloading tile: " + MapTileIndex.toString(state.getMapTile())), (Throwable)e);
                }
                if (result == null) {
                    this.tileLoadedFailed(state);
                    continue;
                }
                if (ExpirableBitmapDrawable.getState(result) == -2) {
                    this.tileLoadedExpired(state, result);
                    continue;
                }
                if (ExpirableBitmapDrawable.getState(result) == -3) {
                    this.tileLoadedScaled(state, result);
                    continue;
                }
                this.tileLoaded(state, result);
            }
            this.onTileLoaderShutdown();
        }
    }
}

