/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.tileprovider.modules;

import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.util.Log;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import org.osmdroid.tileprovider.modules.IArchiveFile;
import org.osmdroid.tileprovider.tilesource.ITileSource;
import org.osmdroid.util.MapTileIndex;

public class DatabaseFileArchive
implements IArchiveFile {
    public static final String TABLE = "tiles";
    public static final String COLUMN_PROVIDER = "provider";
    public static final String COLUMN_TILE = "tile";
    public static final String COLUMN_KEY = "key";
    static final String[] tile_column = new String[]{"tile"};
    private SQLiteDatabase mDatabase;
    private boolean mIgnoreTileSource = false;

    public DatabaseFileArchive() {
    }

    private DatabaseFileArchive(SQLiteDatabase pDatabase) {
        this.mDatabase = pDatabase;
    }

    public static DatabaseFileArchive getDatabaseFileArchive(File pFile) throws SQLiteException {
        return new DatabaseFileArchive(SQLiteDatabase.openDatabase((String)pFile.getAbsolutePath(), null, (int)0));
    }

    @Override
    public void setIgnoreTileSource(boolean pIgnoreTileSource) {
        this.mIgnoreTileSource = pIgnoreTileSource;
    }

    @Override
    public Set<String> getTileSources() {
        HashSet<String> ret = new HashSet<String>();
        try {
            Cursor cur = this.mDatabase.rawQuery("SELECT distinct provider FROM tiles", null);
            while (cur.moveToNext()) {
                ret.add(cur.getString(0));
            }
            cur.close();
        }
        catch (Exception e) {
            Log.w((String)"OsmDroid", (String)"Error getting tile sources: ", (Throwable)e);
        }
        return ret;
    }

    @Override
    public void init(File pFile) throws Exception {
        this.mDatabase = SQLiteDatabase.openDatabase((String)pFile.getAbsolutePath(), null, (int)17);
    }

    public byte[] getImage(ITileSource pTileSource, long pMapTileIndex) {
        try {
            byte[] bits = null;
            String[] tile = new String[]{COLUMN_TILE};
            long x = MapTileIndex.getX(pMapTileIndex);
            long y = MapTileIndex.getY(pMapTileIndex);
            long z = MapTileIndex.getZoom(pMapTileIndex);
            long index = ((z << (int)z) + x << (int)z) + y;
            Cursor cur = !this.mIgnoreTileSource ? this.mDatabase.query(TABLE, tile, "key = " + index + " and " + COLUMN_PROVIDER + " = ?", new String[]{pTileSource.name()}, null, null, null) : this.mDatabase.query(TABLE, tile, "key = " + index, null, null, null, null);
            if (cur.getCount() != 0) {
                cur.moveToFirst();
                bits = cur.getBlob(0);
            }
            cur.close();
            if (bits != null) {
                return bits;
            }
        }
        catch (Throwable e) {
            Log.w((String)"OsmDroid", (String)("Error getting db stream: " + MapTileIndex.toString(pMapTileIndex)), (Throwable)e);
        }
        return null;
    }

    @Override
    public InputStream getInputStream(ITileSource pTileSource, long pMapTileIndex) {
        try {
            ByteArrayInputStream ret = null;
            byte[] bits = this.getImage(pTileSource, pMapTileIndex);
            if (bits != null) {
                ret = new ByteArrayInputStream(bits);
            }
            if (ret != null) {
                return ret;
            }
        }
        catch (Throwable e) {
            Log.w((String)"OsmDroid", (String)("Error getting db stream: " + MapTileIndex.toString(pMapTileIndex)), (Throwable)e);
        }
        return null;
    }

    @Override
    public void close() {
        this.mDatabase.close();
    }

    public String toString() {
        return "DatabaseFileArchive [mDatabase=" + this.mDatabase.getPath() + "]";
    }
}

