/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.tileprovider;

import android.graphics.drawable.Drawable;
import android.util.Log;
import java.util.HashMap;
import org.osmdroid.config.Configuration;
import org.osmdroid.tileprovider.BitmapPool;
import org.osmdroid.util.MapTileList;

public class MapTileCache {
    private TileRemovedListener mTileRemovedListener;
    private final HashMap<Long, Drawable> mCachedTiles = new HashMap();
    private final MapTileList mMapTileList = new MapTileList();
    private final MapTileList mAdditionalMapTileList = new MapTileList();
    private final MapTileList mGC = new MapTileList();
    private int mCapacity;

    public MapTileCache() {
        this(Configuration.getInstance().getCacheMapTileCount());
    }

    public MapTileCache(int aMaximumCacheSize) {
        this.ensureCapacity(aMaximumCacheSize);
    }

    public void ensureCapacity(int pCapacity) {
        if (this.mCapacity < pCapacity) {
            Log.i((String)"OsmDroid", (String)("Tile cache increased from " + this.mCapacity + " to " + pCapacity));
            this.mCapacity = pCapacity;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Drawable getMapTile(long pMapTileIndex) {
        HashMap<Long, Drawable> hashMap = this.mCachedTiles;
        synchronized (hashMap) {
            return this.mCachedTiles.get(pMapTileIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putTile(long pMapTileIndex, Drawable aDrawable) {
        if (aDrawable != null) {
            HashMap<Long, Drawable> hashMap = this.mCachedTiles;
            synchronized (hashMap) {
                this.mCachedTiles.put(pMapTileIndex, aDrawable);
            }
        }
    }

    public void garbageCollection() {
        int size = this.mCachedTiles.size();
        int toBeRemoved = size - this.mCapacity;
        if (toBeRemoved <= 0) {
            return;
        }
        this.mAdditionalMapTileList.clear();
        this.mAdditionalMapTileList.populateFrom(this.mMapTileList, -1);
        this.mAdditionalMapTileList.populateFrom(this.mMapTileList, 1);
        this.populateSyncCachedTiles(this.mGC);
        for (int i = 0; i < this.mGC.getSize(); ++i) {
            long index = this.mGC.get(i);
            if (this.mMapTileList.contains(index) || this.mAdditionalMapTileList.contains(index)) continue;
            this.remove(index);
            if (--toBeRemoved == 0) break;
        }
    }

    public MapTileList getMapTileList() {
        return this.mMapTileList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsTile(long pMapTileIndex) {
        HashMap<Long, Drawable> hashMap = this.mCachedTiles;
        synchronized (hashMap) {
            return this.mCachedTiles.containsKey(pMapTileIndex);
        }
    }

    public void clear() {
        MapTileList list = new MapTileList(this.mCachedTiles.size());
        this.populateSyncCachedTiles(list);
        for (int i = 0; i < list.getSize(); ++i) {
            long index = list.get(i);
            this.remove(index);
        }
        this.mCachedTiles.clear();
    }

    public void remove(long pMapTileIndex) {
        Drawable drawable = this.mCachedTiles.remove(pMapTileIndex);
        if (this.getTileRemovedListener() != null) {
            this.getTileRemovedListener().onTileRemoved(pMapTileIndex);
        }
        BitmapPool.getInstance().asyncRecycle(drawable);
    }

    public TileRemovedListener getTileRemovedListener() {
        return this.mTileRemovedListener;
    }

    public void setTileRemovedListener(TileRemovedListener tileRemovedListener) {
        this.mTileRemovedListener = tileRemovedListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateSyncCachedTiles(MapTileList pList) {
        HashMap<Long, Drawable> hashMap = this.mCachedTiles;
        synchronized (hashMap) {
            pList.ensureCapacity(this.mCachedTiles.size());
            pList.clear();
            for (long index : this.mCachedTiles.keySet()) {
                pList.put(index);
            }
        }
    }

    public int getSize() {
        return this.mCachedTiles.size();
    }

    public static interface TileRemovedListener {
        public void onTileRemoved(long var1);
    }
}

