/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.views.overlay.simplefastpoint;

import android.graphics.Color;
import android.graphics.Paint;

public class SimpleFastPointOverlayOptions {
    protected Paint mPointStyle;
    protected Paint mSelectedPointStyle;
    protected Paint mTextStyle;
    protected float mCircleRadius = 5.0f;
    protected float mSelectedCircleRadius = 13.0f;
    protected boolean mClickable = true;
    protected int mCellSize = 10;
    protected RenderingAlgorithm mAlgorithm = RenderingAlgorithm.MAXIMUM_OPTIMIZATION;
    protected Shape mSymbol = Shape.CIRCLE;
    protected LabelPolicy mLabelPolicy = LabelPolicy.ZOOM_THRESHOLD;
    protected int mMaxNShownLabels = 250;
    protected int mMinZoomShowLabels = 11;

    public SimpleFastPointOverlayOptions() {
        this.mPointStyle = new Paint();
        this.mPointStyle.setStyle(Paint.Style.FILL);
        this.mPointStyle.setColor(Color.parseColor((String)"#ff7700"));
        this.mSelectedPointStyle = new Paint();
        this.mSelectedPointStyle.setStrokeWidth(5.0f);
        this.mSelectedPointStyle.setStyle(Paint.Style.STROKE);
        this.mSelectedPointStyle.setColor(Color.parseColor((String)"#ffff00"));
        this.mTextStyle = new Paint();
        this.mTextStyle.setStyle(Paint.Style.FILL);
        this.mTextStyle.setColor(Color.parseColor((String)"#ffff00"));
        this.mTextStyle.setTextAlign(Paint.Align.CENTER);
        this.mTextStyle.setTextSize(24.0f);
    }

    public static SimpleFastPointOverlayOptions getDefaultStyle() {
        return new SimpleFastPointOverlayOptions();
    }

    public SimpleFastPointOverlayOptions setPointStyle(Paint style) {
        this.mPointStyle = style;
        return this;
    }

    public SimpleFastPointOverlayOptions setSelectedPointStyle(Paint style) {
        this.mSelectedPointStyle = style;
        return this;
    }

    public SimpleFastPointOverlayOptions setRadius(float radius) {
        this.mCircleRadius = radius;
        return this;
    }

    public SimpleFastPointOverlayOptions setSelectedRadius(float radius) {
        this.mSelectedCircleRadius = radius;
        return this;
    }

    public SimpleFastPointOverlayOptions setIsClickable(boolean clickable) {
        this.mClickable = clickable;
        return this;
    }

    public SimpleFastPointOverlayOptions setCellSize(int cellSize) {
        this.mCellSize = cellSize;
        return this;
    }

    public SimpleFastPointOverlayOptions setAlgorithm(RenderingAlgorithm algorithm) {
        this.mAlgorithm = algorithm;
        return this;
    }

    public SimpleFastPointOverlayOptions setSymbol(Shape symbol) {
        this.mSymbol = symbol;
        return this;
    }

    public SimpleFastPointOverlayOptions setTextStyle(Paint textStyle) {
        this.mTextStyle = textStyle;
        return this;
    }

    public SimpleFastPointOverlayOptions setMinZoomShowLabels(int minZoomShowLabels) {
        this.mMinZoomShowLabels = minZoomShowLabels;
        return this;
    }

    public SimpleFastPointOverlayOptions setMaxNShownLabels(int maxNShownLabels) {
        this.mMaxNShownLabels = maxNShownLabels;
        return this;
    }

    public SimpleFastPointOverlayOptions setLabelPolicy(LabelPolicy labelPolicy) {
        this.mLabelPolicy = labelPolicy;
        return this;
    }

    public static enum LabelPolicy {
        ZOOM_THRESHOLD,
        DENSITY_THRESHOLD;

    }

    public static enum Shape {
        CIRCLE,
        SQUARE;

    }

    public static enum RenderingAlgorithm {
        NO_OPTIMIZATION,
        MEDIUM_OPTIMIZATION,
        MAXIMUM_OPTIMIZATION;

    }
}

