/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.tileprovider.tilesource;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.Log;
import java.io.File;
import java.io.InputStream;
import java.util.Random;
import org.osmdroid.tileprovider.BitmapPool;
import org.osmdroid.tileprovider.MapTile;
import org.osmdroid.tileprovider.ReusableBitmapDrawable;
import org.osmdroid.tileprovider.tilesource.ITileSource;
import org.osmdroid.tileprovider.util.Counters;

public abstract class BitmapTileSourceBase
implements ITileSource {
    private static int globalOrdinal = 0;
    private final int mMinimumZoomLevel;
    private final int mMaximumZoomLevel;
    private final int mOrdinal;
    protected String mName;
    protected final String mImageFilenameEnding;
    protected final Random random = new Random();
    private final int mTileSizePixels;

    public BitmapTileSourceBase(String aName, int aZoomMinLevel, int aZoomMaxLevel, int aTileSizePixels, String aImageFilenameEnding) {
        this.mOrdinal = globalOrdinal++;
        this.mName = aName;
        this.mMinimumZoomLevel = aZoomMinLevel;
        this.mMaximumZoomLevel = aZoomMaxLevel;
        this.mTileSizePixels = aTileSizePixels;
        this.mImageFilenameEnding = aImageFilenameEnding;
    }

    @Override
    public int ordinal() {
        return this.mOrdinal;
    }

    @Override
    public String name() {
        return this.mName;
    }

    public String pathBase() {
        return this.mName;
    }

    public String imageFilenameEnding() {
        return this.mImageFilenameEnding;
    }

    @Override
    public int getMinimumZoomLevel() {
        return this.mMinimumZoomLevel;
    }

    @Override
    public int getMaximumZoomLevel() {
        return this.mMaximumZoomLevel;
    }

    @Override
    public int getTileSizePixels() {
        return this.mTileSizePixels;
    }

    @Override
    public Drawable getDrawable(String aFilePath) throws LowMemoryException {
        try {
            BitmapFactory.Options bitmapOptions = new BitmapFactory.Options();
            BitmapPool.getInstance().applyReusableOptions(bitmapOptions);
            Bitmap bitmap = Build.VERSION.SDK_INT == 15 ? BitmapFactory.decodeFile((String)aFilePath) : BitmapFactory.decodeFile((String)aFilePath, (BitmapFactory.Options)bitmapOptions);
            if (bitmap != null) {
                return new ReusableBitmapDrawable(bitmap);
            }
            File bmp = new File(aFilePath);
            if (bmp.exists()) {
                Log.d((String)"OsmDroid", (String)(aFilePath + " is an invalid image file, deleting..."));
                try {
                    new File(aFilePath).delete();
                }
                catch (Throwable e) {
                    Log.e((String)"OsmDroid", (String)("Error deleting invalid file: " + aFilePath), (Throwable)e);
                }
            } else {
                Log.d((String)"OsmDroid", (String)("Request tile: " + aFilePath + " does not exist"));
            }
        }
        catch (OutOfMemoryError e) {
            Log.e((String)"OsmDroid", (String)("OutOfMemoryError loading bitmap: " + aFilePath));
            System.gc();
            throw new LowMemoryException(e);
        }
        catch (Exception e) {
            Log.e((String)"OsmDroid", (String)("Unexpected error loading bitmap: " + aFilePath), (Throwable)e);
            ++Counters.tileDownloadErrors;
            System.gc();
        }
        return null;
    }

    @Override
    public String getTileRelativeFilenameString(MapTile tile) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.pathBase());
        sb.append('/');
        sb.append(tile.getZoomLevel());
        sb.append('/');
        sb.append(tile.getX());
        sb.append('/');
        sb.append(tile.getY());
        sb.append(this.imageFilenameEnding());
        return sb.toString();
    }

    @Override
    public Drawable getDrawable(InputStream aFileInputStream) throws LowMemoryException {
        try {
            BitmapFactory.Options bitmapOptions = new BitmapFactory.Options();
            BitmapPool.getInstance().applyReusableOptions(bitmapOptions);
            Bitmap bitmap = BitmapFactory.decodeStream((InputStream)aFileInputStream, null, (BitmapFactory.Options)bitmapOptions);
            if (bitmap != null) {
                return new ReusableBitmapDrawable(bitmap);
            }
        }
        catch (OutOfMemoryError e) {
            Log.e((String)"OsmDroid", (String)"OutOfMemoryError loading bitmap");
            System.gc();
            throw new LowMemoryException(e);
        }
        return null;
    }

    public static final class LowMemoryException
    extends Exception {
        private static final long serialVersionUID = 146526524087765134L;

        public LowMemoryException(String pDetailMessage) {
            super(pDetailMessage);
        }

        public LowMemoryException(Throwable pThrowable) {
            super(pThrowable);
        }
    }
}

