/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.tileprovider;

import android.graphics.drawable.Drawable;
import org.osmdroid.config.Configuration;
import org.osmdroid.tileprovider.LRUMapTileCache;
import org.osmdroid.tileprovider.MapTile;

public class MapTileCache {
    protected final Object mCachedTilesLockObject = new Object();
    protected LRUMapTileCache mCachedTiles;

    public MapTileCache() {
        this(Configuration.getInstance().getCacheMapTileCount());
    }

    public MapTileCache(int aMaximumCacheSize) {
        this.mCachedTiles = new LRUMapTileCache(aMaximumCacheSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ensureCapacity(int aCapacity) {
        Object object = this.mCachedTilesLockObject;
        synchronized (object) {
            this.mCachedTiles.ensureCapacity(aCapacity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Drawable getMapTile(MapTile aTile) {
        Object object = this.mCachedTilesLockObject;
        synchronized (object) {
            return (Drawable)this.mCachedTiles.get(aTile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putTile(MapTile aTile, Drawable aDrawable) {
        if (aDrawable != null) {
            Object object = this.mCachedTilesLockObject;
            synchronized (object) {
                this.mCachedTiles.put(aTile, aDrawable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsTile(MapTile aTile) {
        Object object = this.mCachedTilesLockObject;
        synchronized (object) {
            return this.mCachedTiles.containsKey(aTile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.mCachedTilesLockObject;
        synchronized (object) {
            this.mCachedTiles.clear();
        }
    }
}

