/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.tileprovider.modules;

import android.util.Log;
import java.io.File;
import java.util.ArrayList;
import org.osmdroid.tileprovider.IMapTileProviderCallback;
import org.osmdroid.tileprovider.IRegisterReceiver;
import org.osmdroid.tileprovider.MapTileProviderArray;
import org.osmdroid.tileprovider.modules.ArchiveFileFactory;
import org.osmdroid.tileprovider.modules.IArchiveFile;
import org.osmdroid.tileprovider.modules.MapTileFileArchiveProvider;
import org.osmdroid.tileprovider.tilesource.FileBasedTileSource;

public class OfflineTileProvider
extends MapTileProviderArray
implements IMapTileProviderCallback {
    IArchiveFile[] archives;

    public OfflineTileProvider(IRegisterReceiver pRegisterReceiver, File[] source) throws Exception {
        super(FileBasedTileSource.getSource(source[0].getName()), pRegisterReceiver);
        ArrayList<IArchiveFile> files = new ArrayList<IArchiveFile>();
        for (int i = 0; i < source.length; ++i) {
            IArchiveFile temp = ArchiveFileFactory.getArchiveFile(source[i]);
            if (temp != null) {
                files.add(temp);
                continue;
            }
            Log.w((String)"OsmDroid", (String)("Skipping " + source[i] + ", no tile provider is registered to handle the file extension"));
        }
        this.archives = new IArchiveFile[files.size()];
        this.archives = files.toArray(this.archives);
        this.mTileProviderList.add(new MapTileFileArchiveProvider(pRegisterReceiver, this.getTileSource(), this.archives));
    }

    public IArchiveFile[] getArchives() {
        return this.archives;
    }

    @Override
    public void detach() {
        if (this.archives != null) {
            for (int i = 0; i < this.archives.length; ++i) {
                this.archives[i].close();
            }
        }
        super.detach();
    }
}

