/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.views.overlay.infowindow;

import android.content.Context;
import android.text.Html;
import android.text.Spanned;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.widget.TextView;
import org.osmdroid.views.MapView;
import org.osmdroid.views.overlay.OverlayWithIW;
import org.osmdroid.views.overlay.infowindow.InfoWindow;

public class BasicInfoWindow
extends InfoWindow {
    public static final int UNDEFINED_RES_ID = 0;
    static int mTitleId = 0;
    static int mDescriptionId = 0;
    static int mSubDescriptionId = 0;
    static int mImageId = 0;

    private static void setResIds(Context context) {
        String packageName = context.getPackageName();
        mTitleId = context.getResources().getIdentifier("id/bubble_title", null, packageName);
        mDescriptionId = context.getResources().getIdentifier("id/bubble_description", null, packageName);
        mSubDescriptionId = context.getResources().getIdentifier("id/bubble_subdescription", null, packageName);
        mImageId = context.getResources().getIdentifier("id/bubble_image", null, packageName);
        if (mTitleId == 0 || mDescriptionId == 0 || mSubDescriptionId == 0 || mImageId == 0) {
            Log.e((String)"OsmDroid", (String)("BasicInfoWindow: unable to get res ids in " + packageName));
        }
    }

    public BasicInfoWindow(int layoutResId, MapView mapView) {
        super(layoutResId, mapView);
        if (mTitleId == 0) {
            BasicInfoWindow.setResIds(mapView.getContext());
        }
        this.mView.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent e) {
                if (e.getAction() == 1) {
                    BasicInfoWindow.this.close();
                }
                return true;
            }
        });
    }

    @Override
    public void onOpen(Object item) {
        OverlayWithIW overlay = (OverlayWithIW)item;
        String title = overlay.getTitle();
        if (title == null) {
            title = "";
        }
        ((TextView)this.mView.findViewById(mTitleId)).setText((CharSequence)title);
        String snippet = overlay.getSnippet();
        if (snippet == null) {
            snippet = "";
        }
        Spanned snippetHtml = Html.fromHtml((String)snippet);
        ((TextView)this.mView.findViewById(mDescriptionId)).setText((CharSequence)snippetHtml);
        TextView subDescText = (TextView)this.mView.findViewById(mSubDescriptionId);
        String subDesc = overlay.getSubDescription();
        if (subDesc != null && !"".equals(subDesc)) {
            subDescText.setText((CharSequence)Html.fromHtml((String)subDesc));
            subDescText.setVisibility(0);
        } else {
            subDescText.setVisibility(8);
        }
    }

    @Override
    public void onClose() {
    }
}

