/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.views.overlay.infowindow;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import java.util.ArrayList;
import org.osmdroid.util.GeoPoint;
import org.osmdroid.views.MapView;

public abstract class InfoWindow {
    protected View mView;
    protected boolean mIsVisible;
    protected MapView mMapView;

    public InfoWindow(int layoutResId, MapView mapView) {
        this.mMapView = mapView;
        this.mIsVisible = false;
        ViewGroup parent = (ViewGroup)mapView.getParent();
        Context context = mapView.getContext();
        LayoutInflater inflater = (LayoutInflater)context.getSystemService("layout_inflater");
        this.mView = inflater.inflate(layoutResId, parent, false);
        this.mView.setTag((Object)this);
    }

    public MapView getMapView() {
        return this.mMapView;
    }

    public View getView() {
        return this.mView;
    }

    public void open(Object object, GeoPoint position, int offsetX, int offsetY) {
        this.close();
        this.onOpen(object);
        MapView.LayoutParams lp = new MapView.LayoutParams(-2, -2, position, 8, offsetX, offsetY);
        this.mMapView.addView(this.mView, lp);
        this.mIsVisible = true;
    }

    public void close() {
        if (this.mIsVisible) {
            this.mIsVisible = false;
            ((ViewGroup)this.mView.getParent()).removeView(this.mView);
            this.onClose();
        }
    }

    public boolean isOpen() {
        return this.mIsVisible;
    }

    public static void closeAllInfoWindowsOn(MapView mapView) {
        ArrayList<InfoWindow> opened = InfoWindow.getOpenedInfoWindowsOn(mapView);
        for (InfoWindow infoWindow : opened) {
            infoWindow.close();
        }
    }

    public static ArrayList<InfoWindow> getOpenedInfoWindowsOn(MapView mapView) {
        int count = mapView.getChildCount();
        ArrayList<InfoWindow> opened = new ArrayList<InfoWindow>(count);
        for (int i = 0; i < count; ++i) {
            View child = mapView.getChildAt(i);
            Object tag = child.getTag();
            if (tag == null || !(tag instanceof InfoWindow)) continue;
            InfoWindow infoWindow = (InfoWindow)tag;
            opened.add(infoWindow);
        }
        return opened;
    }

    public abstract void onOpen(Object var1);

    public abstract void onClose();
}

