/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.views.overlay;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.os.Build;
import android.util.DisplayMetrics;
import android.view.WindowManager;
import java.lang.reflect.Field;
import org.osmdroid.api.IGeoPoint;
import org.osmdroid.library.R;
import org.osmdroid.util.GeoPoint;
import org.osmdroid.util.constants.GeoConstants;
import org.osmdroid.views.MapView;
import org.osmdroid.views.Projection;
import org.osmdroid.views.overlay.Overlay;

public class ScaleBarOverlay
extends Overlay
implements GeoConstants {
    private static final Rect sTextBoundsRect = new Rect();
    int xOffset = 10;
    int yOffset = 10;
    int minZoom = 0;
    UnitsOfMeasure unitsOfMeasure = UnitsOfMeasure.metric;
    boolean latitudeBar = true;
    boolean longitudeBar = false;
    protected boolean alignBottom = false;
    protected boolean alignRight = false;
    private final Context context;
    private final MapView mMapView;
    protected final Path barPath = new Path();
    protected final Rect latitudeBarRect = new Rect();
    protected final Rect longitudeBarRect = new Rect();
    private int lastZoomLevel = -1;
    private float lastLatitude = 0.0f;
    public float xdpi;
    public float ydpi;
    public int screenWidth;
    public int screenHeight;
    private Paint barPaint;
    private Paint bgPaint;
    private Paint textPaint;
    private boolean centred = false;
    private boolean adjustLength = false;
    private float maxLength;

    public ScaleBarOverlay(MapView mapView) {
        super(mapView.getContext());
        this.mMapView = mapView;
        this.context = mapView.getContext();
        DisplayMetrics dm = this.context.getResources().getDisplayMetrics();
        this.barPaint = new Paint();
        this.barPaint.setColor(-16777216);
        this.barPaint.setAntiAlias(true);
        this.barPaint.setStyle(Paint.Style.STROKE);
        this.barPaint.setAlpha(255);
        this.barPaint.setStrokeWidth(2.0f * dm.density);
        this.bgPaint = null;
        this.textPaint = new Paint();
        this.textPaint.setColor(-16777216);
        this.textPaint.setAntiAlias(true);
        this.textPaint.setStyle(Paint.Style.FILL);
        this.textPaint.setAlpha(255);
        this.textPaint.setTextSize(10.0f * dm.density);
        this.xdpi = dm.xdpi;
        this.ydpi = dm.ydpi;
        this.screenWidth = dm.widthPixels;
        this.screenHeight = dm.heightPixels;
        String manufacturer = null;
        try {
            Field field = Build.class.getField("MANUFACTURER");
            manufacturer = (String)field.get(null);
        }
        catch (Exception ignore) {
            // empty catch block
        }
        if ("motorola".equals(manufacturer) && "DROIDX".equals(Build.MODEL)) {
            WindowManager windowManager = (WindowManager)this.context.getSystemService("window");
            if (windowManager.getDefaultDisplay().getOrientation() > 0) {
                this.xdpi = (float)((double)this.screenWidth / 3.75);
                this.ydpi = (float)((double)this.screenHeight / 2.1);
            } else {
                this.xdpi = (float)((double)this.screenWidth / 2.1);
                this.ydpi = (float)((double)this.screenHeight / 3.75);
            }
        } else if ("motorola".equals(manufacturer) && "Droid".equals(Build.MODEL)) {
            this.xdpi = 264.0f;
            this.ydpi = 264.0f;
        }
        this.maxLength = 2.54f;
    }

    public void setMinZoom(int zoom) {
        this.minZoom = zoom;
    }

    public void setScaleBarOffset(int x, int y) {
        this.xOffset = x;
        this.yOffset = y;
    }

    public void setLineWidth(float width) {
        this.barPaint.setStrokeWidth(width);
    }

    public void setTextSize(float size) {
        this.textPaint.setTextSize(size);
    }

    public void setUnitsOfMeasure(UnitsOfMeasure unitsOfMeasure) {
        this.unitsOfMeasure = unitsOfMeasure;
        this.lastZoomLevel = -1;
    }

    public UnitsOfMeasure getUnitsOfMeasure() {
        return this.unitsOfMeasure;
    }

    public void drawLatitudeScale(boolean latitude) {
        this.latitudeBar = latitude;
        this.lastZoomLevel = -1;
    }

    public void drawLongitudeScale(boolean longitude) {
        this.longitudeBar = longitude;
        this.lastZoomLevel = -1;
    }

    public void setCentred(boolean centred) {
        this.centred = centred;
        this.alignBottom = !centred;
        this.alignRight = !centred;
        this.lastZoomLevel = -1;
    }

    public void setAlignBottom(boolean alignBottom) {
        this.centred = false;
        this.alignBottom = alignBottom;
        this.lastZoomLevel = -1;
    }

    public void setAlignRight(boolean alignRight) {
        this.centred = false;
        this.alignRight = alignRight;
        this.lastZoomLevel = -1;
    }

    public Paint getBarPaint() {
        return this.barPaint;
    }

    public void setBarPaint(Paint pBarPaint) {
        if (pBarPaint == null) {
            throw new IllegalArgumentException("pBarPaint argument cannot be null");
        }
        this.barPaint = pBarPaint;
        this.lastZoomLevel = -1;
    }

    public Paint getTextPaint() {
        return this.textPaint;
    }

    public void setTextPaint(Paint pTextPaint) {
        if (pTextPaint == null) {
            throw new IllegalArgumentException("pTextPaint argument cannot be null");
        }
        this.textPaint = pTextPaint;
        this.lastZoomLevel = -1;
    }

    public void setBackgroundPaint(Paint pBgPaint) {
        this.bgPaint = pBgPaint;
        this.lastZoomLevel = -1;
    }

    public void setEnableAdjustLength(boolean adjustLength) {
        this.adjustLength = adjustLength;
        this.lastZoomLevel = -1;
    }

    public void setMaxLength(float pMaxLengthInCm) {
        this.maxLength = pMaxLengthInCm;
        this.lastZoomLevel = -1;
    }

    @Override
    protected void draw(Canvas c, MapView mapView, boolean shadow) {
        if (shadow) {
            return;
        }
        if (mapView.isAnimating()) {
            return;
        }
        int zoomLevel = mapView.getZoomLevel();
        if (zoomLevel >= this.minZoom) {
            Projection projection = mapView.getProjection();
            if (projection == null) {
                return;
            }
            this.screenWidth = mapView.getWidth();
            this.screenHeight = mapView.getHeight();
            IGeoPoint center = projection.fromPixels(this.screenWidth / 2, this.screenHeight / 2, null);
            if (zoomLevel != this.lastZoomLevel || (int)((double)center.getLatitudeE6() / 1000000.0) != (int)((double)this.lastLatitude / 1000000.0)) {
                this.lastZoomLevel = zoomLevel;
                this.lastLatitude = center.getLatitudeE6();
                this.rebuildBarPath(projection);
            }
            int offsetX = this.xOffset;
            int offsetY = this.yOffset;
            if (this.alignBottom) {
                offsetY *= -1;
            }
            if (this.alignRight) {
                offsetX *= -1;
            }
            if (this.centred && this.latitudeBar) {
                offsetX += -this.latitudeBarRect.width() / 2;
            }
            if (this.centred && this.longitudeBar) {
                offsetY += -this.longitudeBarRect.height() / 2;
            }
            c.save();
            c.concat(projection.getInvertedScaleRotateCanvasMatrix());
            c.translate((float)offsetX, (float)offsetY);
            if (this.latitudeBar && this.bgPaint != null) {
                c.drawRect(this.latitudeBarRect, this.bgPaint);
            }
            if (this.longitudeBar && this.bgPaint != null) {
                int offsetTop = this.latitudeBar ? this.latitudeBarRect.height() : 0;
                c.drawRect((float)this.longitudeBarRect.left, (float)(this.longitudeBarRect.top + offsetTop), (float)this.longitudeBarRect.right, (float)this.longitudeBarRect.bottom, this.bgPaint);
            }
            c.drawPath(this.barPath, this.barPaint);
            if (this.latitudeBar) {
                this.drawLatitudeText(c, projection);
            }
            if (this.longitudeBar) {
                this.drawLongitudeText(c, projection);
            }
            c.restore();
        }
    }

    public void disableScaleBar() {
        this.setEnabled(false);
    }

    public void enableScaleBar() {
        this.setEnabled(true);
    }

    private void drawLatitudeText(Canvas canvas, Projection projection) {
        int xdpcm = (int)((double)this.xdpi / 2.54);
        int xLen = (int)(this.maxLength * (float)xdpcm);
        IGeoPoint p1 = projection.fromPixels(this.screenWidth / 2 - xLen / 2, this.yOffset, null);
        IGeoPoint p2 = projection.fromPixels(this.screenWidth / 2 + xLen / 2, this.yOffset, null);
        int xMeters = ((GeoPoint)p1).distanceTo(p2);
        double xMetersAdjusted = this.adjustLength ? this.adjustScaleBarLength(xMeters) : (double)xMeters;
        int xBarLengthPixels = (int)((double)xLen * xMetersAdjusted / (double)xMeters);
        String xMsg = this.scaleBarLengthText((int)xMetersAdjusted);
        this.textPaint.getTextBounds(xMsg, 0, xMsg.length(), sTextBoundsRect);
        int xTextSpacing = (int)((double)sTextBoundsRect.height() / 5.0);
        float x = xBarLengthPixels / 2 - sTextBoundsRect.width() / 2;
        if (this.alignRight) {
            x += (float)(this.screenWidth - xBarLengthPixels);
        }
        float y = this.alignBottom ? (float)(this.screenHeight - xTextSpacing * 2) : (float)(sTextBoundsRect.height() + xTextSpacing);
        canvas.drawText(xMsg, x, y, this.textPaint);
    }

    private void drawLongitudeText(Canvas canvas, Projection projection) {
        int ydpcm = (int)((double)this.ydpi / 2.54);
        int yLen = (int)(this.maxLength * (float)ydpcm);
        IGeoPoint p1 = projection.fromPixels(this.screenWidth / 2, this.screenHeight / 2 - yLen / 2, null);
        IGeoPoint p2 = projection.fromPixels(this.screenWidth / 2, this.screenHeight / 2 + yLen / 2, null);
        int yMeters = ((GeoPoint)p1).distanceTo(p2);
        double yMetersAdjusted = this.adjustLength ? this.adjustScaleBarLength(yMeters) : (double)yMeters;
        int yBarLengthPixels = (int)((double)yLen * yMetersAdjusted / (double)yMeters);
        String yMsg = this.scaleBarLengthText((int)yMetersAdjusted);
        this.textPaint.getTextBounds(yMsg, 0, yMsg.length(), sTextBoundsRect);
        int yTextSpacing = (int)((double)sTextBoundsRect.height() / 5.0);
        float x = this.alignRight ? (float)(this.screenWidth - yTextSpacing * 2) : (float)(sTextBoundsRect.height() + yTextSpacing);
        float y = yBarLengthPixels / 2 + sTextBoundsRect.width() / 2;
        if (this.alignBottom) {
            y += (float)(this.screenHeight - yBarLengthPixels);
        }
        canvas.save();
        canvas.rotate(-90.0f, x, y);
        canvas.drawText(yMsg, x, y, this.textPaint);
        canvas.restore();
    }

    protected void rebuildBarPath(Projection projection) {
        int xdpcm = (int)((double)this.xdpi / 2.54);
        int ydpcm = (int)((double)this.ydpi / 2.54);
        int xLen = (int)(this.maxLength * (float)xdpcm);
        int yLen = (int)(this.maxLength * (float)ydpcm);
        IGeoPoint p1 = projection.fromPixels(this.screenWidth / 2 - xLen / 2, this.yOffset, null);
        IGeoPoint p2 = projection.fromPixels(this.screenWidth / 2 + xLen / 2, this.yOffset, null);
        int xMeters = ((GeoPoint)p1).distanceTo(p2);
        double xMetersAdjusted = this.adjustLength ? this.adjustScaleBarLength(xMeters) : (double)xMeters;
        int xBarLengthPixels = (int)((double)xLen * xMetersAdjusted / (double)xMeters);
        p1 = projection.fromPixels(this.screenWidth / 2, this.screenHeight / 2 - yLen / 2, null);
        p2 = projection.fromPixels(this.screenWidth / 2, this.screenHeight / 2 + yLen / 2, null);
        int yMeters = ((GeoPoint)p1).distanceTo(p2);
        double yMetersAdjusted = this.adjustLength ? this.adjustScaleBarLength(yMeters) : (double)yMeters;
        int yBarLengthPixels = (int)((double)yLen * yMetersAdjusted / (double)yMeters);
        String xMsg = this.scaleBarLengthText((int)xMetersAdjusted);
        Rect xTextRect = new Rect();
        this.textPaint.getTextBounds(xMsg, 0, xMsg.length(), xTextRect);
        int xTextSpacing = (int)((double)xTextRect.height() / 5.0);
        String yMsg = this.scaleBarLengthText((int)yMetersAdjusted);
        Rect yTextRect = new Rect();
        this.textPaint.getTextBounds(yMsg, 0, yMsg.length(), yTextRect);
        int yTextSpacing = (int)((double)yTextRect.height() / 5.0);
        int xTextHeight = xTextRect.height();
        int yTextHeight = yTextRect.height();
        this.barPath.rewind();
        int barOriginX = 0;
        int barOriginY = 0;
        int barToX = xBarLengthPixels;
        int barToY = yBarLengthPixels;
        if (this.alignBottom) {
            xTextSpacing *= -1;
            xTextHeight *= -1;
            barOriginY = this.mMapView.getHeight();
            barToY = barOriginY - yBarLengthPixels;
        }
        if (this.alignRight) {
            yTextSpacing *= -1;
            yTextHeight *= -1;
            barOriginX = this.mMapView.getWidth();
            barToX = barOriginX - xBarLengthPixels;
        }
        if (this.latitudeBar) {
            this.barPath.moveTo((float)barToX, (float)(barOriginY + xTextHeight + xTextSpacing * 2));
            this.barPath.lineTo((float)barToX, (float)barOriginY);
            this.barPath.lineTo((float)barOriginX, (float)barOriginY);
            if (!this.longitudeBar) {
                this.barPath.lineTo((float)barOriginX, (float)(barOriginY + xTextHeight + xTextSpacing * 2));
            }
            this.latitudeBarRect.set(barOriginX, barOriginY, barToX, barOriginY + xTextHeight + xTextSpacing * 2);
        }
        if (this.longitudeBar) {
            if (!this.latitudeBar) {
                this.barPath.moveTo((float)(barOriginX + yTextHeight + yTextSpacing * 2), (float)barOriginY);
                this.barPath.lineTo((float)barOriginX, (float)barOriginY);
            }
            this.barPath.lineTo((float)barOriginX, (float)barToY);
            this.barPath.lineTo((float)(barOriginX + yTextHeight + yTextSpacing * 2), (float)barToY);
            this.longitudeBarRect.set(barOriginX, barOriginY, barOriginX + yTextHeight + yTextSpacing * 2, barToY);
        }
    }

    private double adjustScaleBarLength(double length) {
        long pow = 0L;
        boolean feet = false;
        if (this.unitsOfMeasure == UnitsOfMeasure.imperial) {
            if (length >= 321.8688) {
                length /= 1609.344;
            } else {
                length *= 3.2808399;
                feet = true;
            }
        } else if (this.unitsOfMeasure == UnitsOfMeasure.nautical) {
            if (length >= 370.4) {
                length /= 1852.0;
            } else {
                length *= 3.2808399;
                feet = true;
            }
        }
        while (length >= 10.0) {
            ++pow;
            length /= 10.0;
        }
        while (length < 1.0 && length > 0.0) {
            --pow;
            length *= 10.0;
        }
        length = length < 2.0 ? 1.0 : (length < 5.0 ? 2.0 : 5.0);
        if (feet) {
            length /= 3.2808399;
        } else if (this.unitsOfMeasure == UnitsOfMeasure.imperial) {
            length *= 1609.344;
        } else if (this.unitsOfMeasure == UnitsOfMeasure.nautical) {
            length *= 1852.0;
        }
        return length *= Math.pow(10.0, pow);
    }

    protected String scaleBarLengthText(int meters) {
        switch (this.unitsOfMeasure) {
            default: {
                if (meters >= 5000) {
                    return this.context.getResources().getString(R.string.format_distance_kilometers, new Object[]{meters / 1000});
                }
                if (meters >= 200) {
                    return this.context.getResources().getString(R.string.format_distance_kilometers, new Object[]{(double)((int)((double)meters / 100.0)) / 10.0});
                }
                return this.context.getResources().getString(R.string.format_distance_meters, new Object[]{meters});
            }
            case imperial: {
                if ((double)meters >= 8046.72) {
                    return this.context.getResources().getString(R.string.format_distance_miles, new Object[]{(int)((double)meters / 1609.344)});
                }
                if ((double)meters >= 321.8688) {
                    return this.context.getResources().getString(R.string.format_distance_miles, new Object[]{(double)((int)((double)meters / 160.9344)) / 10.0});
                }
                return this.context.getResources().getString(R.string.format_distance_feet, new Object[]{(int)((double)meters * 3.2808399)});
            }
            case nautical: 
        }
        if ((double)meters >= 9260.0) {
            return this.context.getResources().getString(R.string.format_distance_nautical_miles, new Object[]{(int)((double)meters / 1852.0)});
        }
        if ((double)meters >= 370.4) {
            return this.context.getResources().getString(R.string.format_distance_nautical_miles, new Object[]{(double)((int)((double)meters / 185.2)) / 10.0});
        }
        return this.context.getResources().getString(R.string.format_distance_feet, new Object[]{(int)((double)meters * 3.2808399)});
    }

    public static enum UnitsOfMeasure {
        metric,
        imperial,
        nautical;

    }
}

