/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.tileprovider.modules;

import android.util.Log;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.NoSuchElementException;
import org.osmdroid.tileprovider.MapTile;
import org.osmdroid.tileprovider.constants.OpenStreetMapTileProviderConstants;
import org.osmdroid.tileprovider.modules.IFilesystemCache;
import org.osmdroid.tileprovider.tilesource.ITileSource;
import org.osmdroid.tileprovider.util.StreamUtils;

public class TileWriter
implements IFilesystemCache {
    private static long mUsedCacheSpace;

    public TileWriter() {
        Thread t = new Thread(){

            @Override
            public void run() {
                mUsedCacheSpace = 0L;
                TileWriter.this.calculateDirectorySize(OpenStreetMapTileProviderConstants.TILE_PATH_BASE);
                if (mUsedCacheSpace > OpenStreetMapTileProviderConstants.TILE_MAX_CACHE_SIZE_BYTES) {
                    TileWriter.this.cutCurrentCache();
                }
                if (OpenStreetMapTileProviderConstants.DEBUGMODE) {
                    Log.d((String)"OsmDroid", (String)"Finished init thread");
                }
            }
        };
        t.setPriority(1);
        t.start();
    }

    public static long getUsedCacheSpace() {
        return mUsedCacheSpace;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean saveFile(ITileSource pTileSource, MapTile pTile, InputStream pStream) {
        File parent;
        File file = new File(OpenStreetMapTileProviderConstants.TILE_PATH_BASE, pTileSource.getTileRelativeFilenameString(pTile) + ".tile");
        if (OpenStreetMapTileProviderConstants.DEBUG_TILE_PROVIDERS) {
            Log.d((String)"OsmDroid", (String)("TileWrite " + file.getAbsolutePath()));
        }
        if (!(parent = file.getParentFile()).exists() && !this.createFolderAndCheckIfExists(parent)) {
            return false;
        }
        BufferedOutputStream outputStream = null;
        try {
            outputStream = new BufferedOutputStream(new FileOutputStream(file.getPath()), 8192);
            long length = StreamUtils.copy(pStream, outputStream);
            if ((mUsedCacheSpace += length) > OpenStreetMapTileProviderConstants.TILE_MAX_CACHE_SIZE_BYTES) {
                this.cutCurrentCache();
            }
            if (outputStream == null) return true;
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (outputStream != null) {
                StreamUtils.closeStream(outputStream);
            }
        }
        StreamUtils.closeStream(outputStream);
        return true;
    }

    private boolean createFolderAndCheckIfExists(File pFile) {
        if (pFile.mkdirs()) {
            return true;
        }
        if (OpenStreetMapTileProviderConstants.DEBUGMODE) {
            Log.d((String)"OsmDroid", (String)("Failed to create " + pFile + " - wait and check again"));
        }
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (pFile.exists()) {
            if (OpenStreetMapTileProviderConstants.DEBUGMODE) {
                Log.d((String)"OsmDroid", (String)("Seems like another thread created " + pFile));
            }
            return true;
        }
        if (OpenStreetMapTileProviderConstants.DEBUGMODE) {
            Log.d((String)"OsmDroid", (String)("File still doesn't exist: " + pFile));
        }
        return false;
    }

    private void calculateDirectorySize(File pDirectory) {
        File[] z = pDirectory.listFiles();
        if (z != null) {
            for (File file : z) {
                if (file.isFile()) {
                    mUsedCacheSpace += file.length();
                }
                if (!file.isDirectory() || this.isSymbolicDirectoryLink(pDirectory, file)) continue;
                this.calculateDirectorySize(file);
            }
        }
    }

    private boolean isSymbolicDirectoryLink(File pParentDirectory, File pDirectory) {
        try {
            String canonicalParentPath1 = pParentDirectory.getCanonicalPath();
            String canonicalParentPath2 = pDirectory.getCanonicalFile().getParent();
            return !canonicalParentPath1.equals(canonicalParentPath2);
        }
        catch (IOException e) {
            return true;
        }
        catch (NoSuchElementException e) {
            return true;
        }
    }

    private List<File> getDirectoryFileList(File aDirectory) {
        ArrayList<File> files = new ArrayList<File>();
        File[] z = aDirectory.listFiles();
        if (z != null) {
            for (File file : z) {
                if (file.isFile()) {
                    files.add(file);
                }
                if (!file.isDirectory()) continue;
                files.addAll(this.getDirectoryFileList(file));
            }
        }
        return files;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cutCurrentCache() {
        File lock;
        File file = lock = OpenStreetMapTileProviderConstants.TILE_PATH_BASE;
        synchronized (file) {
            if (mUsedCacheSpace > OpenStreetMapTileProviderConstants.TILE_TRIM_CACHE_SIZE_BYTES) {
                Log.d((String)"OsmDroid", (String)("Trimming tile cache from " + mUsedCacheSpace + " to " + OpenStreetMapTileProviderConstants.TILE_TRIM_CACHE_SIZE_BYTES));
                List<File> z = this.getDirectoryFileList(OpenStreetMapTileProviderConstants.TILE_PATH_BASE);
                File[] files = z.toArray(new File[0]);
                Arrays.sort(files, new Comparator<File>(){

                    @Override
                    public int compare(File f1, File f2) {
                        return Long.valueOf(f1.lastModified()).compareTo(f2.lastModified());
                    }
                });
                for (File file2 : files) {
                    if (mUsedCacheSpace <= OpenStreetMapTileProviderConstants.TILE_TRIM_CACHE_SIZE_BYTES) break;
                    long length = file2.length();
                    if (!file2.delete()) continue;
                    if (OpenStreetMapTileProviderConstants.DEBUG_TILE_PROVIDERS) {
                        Log.d((String)"OsmDroid", (String)("Cache trim deleting " + file2.getAbsolutePath()));
                    }
                    mUsedCacheSpace -= length;
                }
                Log.d((String)"OsmDroid", (String)"Finished trimming tile cache");
            }
        }
    }
}

