/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.tileprovider.cachemanager;

import android.app.ProgressDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.graphics.Point;
import android.os.AsyncTask;
import android.util.Log;
import android.widget.Toast;
import java.io.File;
import org.osmdroid.tileprovider.MapTile;
import org.osmdroid.tileprovider.MapTileProviderBase;
import org.osmdroid.tileprovider.constants.OpenStreetMapTileProviderConstants;
import org.osmdroid.tileprovider.modules.TileWriter;
import org.osmdroid.tileprovider.tilesource.ITileSource;
import org.osmdroid.tileprovider.tilesource.OnlineTileSourceBase;
import org.osmdroid.util.BoundingBoxE6;
import org.osmdroid.util.MyMath;
import org.osmdroid.views.MapView;

public class CacheManager {
    protected final MapTileProviderBase mTileProvider;
    protected final TileWriter mTileWriter;
    protected final MapView mMapView;

    public CacheManager(MapView mapView) {
        this.mTileProvider = mapView.getTileProvider();
        this.mTileWriter = new TileWriter();
        this.mMapView = mapView;
    }

    public Point getMapTileFromCoordinates(double aLat, double aLon, int zoom) {
        int y = (int)Math.floor((1.0 - Math.log(Math.tan(aLat * Math.PI / 180.0) + 1.0 / Math.cos(aLat * Math.PI / 180.0)) / Math.PI) / 2.0 * (double)(1 << zoom));
        int x = (int)Math.floor((aLon + 180.0) / 360.0 * (double)(1 << zoom));
        return new Point(x, y);
    }

    public File getFileName(ITileSource tileSource, MapTile tile) {
        File file = new File(OpenStreetMapTileProviderConstants.TILE_PATH_BASE, tileSource.getTileRelativeFilenameString(tile) + ".tile");
        return file;
    }

    /*
     * Exception decompiling
     */
    public boolean loadTile(OnlineTileSourceBase tileSource, MapTile tile) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public int possibleTilesInArea(BoundingBoxE6 bb, int zoomMin, int zoomMax) {
        int total = 0;
        for (int zoomLevel = zoomMin; zoomLevel <= zoomMax; ++zoomLevel) {
            Point mLowerRight = this.getMapTileFromCoordinates((double)bb.getLatSouthE6() * 1.0E-6, (double)bb.getLonEastE6() * 1.0E-6, zoomLevel);
            Point mUpperLeft = this.getMapTileFromCoordinates((double)bb.getLatNorthE6() * 1.0E-6, (double)bb.getLonWestE6() * 1.0E-6, zoomLevel);
            int y = mLowerRight.y - mUpperLeft.y + 1;
            int x = mLowerRight.x - mUpperLeft.x + 1;
            int nbTilesForZoomLevel = x * y;
            total += nbTilesForZoomLevel;
        }
        return total;
    }

    protected String zoomMessage(int zoomLevel, int zoomMin, int zoomMax) {
        return "Handling zoom level: " + zoomLevel + " (from " + zoomMin + " to " + zoomMax + ")";
    }

    public void downloadAreaAsync(Context ctx, BoundingBoxE6 bb, int zoomMin, int zoomMax) {
        new DownloadingTask(ctx, bb, zoomMin, zoomMax, null).execute(new Object[0]);
    }

    public void downloadAreaAsync(Context ctx, BoundingBoxE6 bb, int zoomMin, int zoomMax, CacheManagerCallback callback) {
        new DownloadingTask(ctx, bb, zoomMin, zoomMax, callback).execute(new Object[0]);
    }

    public void cleanAreaAsync(Context ctx, BoundingBoxE6 bb, int zoomMin, int zoomMax) {
        new CleaningTask(ctx, bb, zoomMin, zoomMax).execute(new Object[0]);
    }

    public long currentCacheUsage() {
        return this.directorySize(OpenStreetMapTileProviderConstants.TILE_PATH_BASE);
    }

    public long cacheCapacity() {
        return OpenStreetMapTileProviderConstants.TILE_MAX_CACHE_SIZE_BYTES;
    }

    public long directorySize(File pDirectory) {
        long usedCacheSpace = 0L;
        File[] z = pDirectory.listFiles();
        if (z != null) {
            for (File file : z) {
                if (file.isFile()) {
                    usedCacheSpace += file.length();
                    continue;
                }
                if (!file.isDirectory()) continue;
                usedCacheSpace += this.directorySize(file);
            }
        }
        return usedCacheSpace;
    }

    protected class CleaningTask
    extends CacheManagerTask {
        public CleaningTask(Context pCtx, BoundingBoxE6 pBB, int pZoomMin, int pZoomMax) {
            super(pCtx, pBB, pZoomMin, pZoomMax);
        }

        protected void onPreExecute() {
            this.mProgressDialog.setTitle((CharSequence)"Cleaning tiles");
            this.mProgressDialog.setMessage((CharSequence)CacheManager.this.zoomMessage(this.mZoomMin, this.mZoomMin, this.mZoomMax));
            int total = CacheManager.this.possibleTilesInArea(this.mBB, this.mZoomMin, this.mZoomMax);
            this.mProgressDialog.setMax(total);
            this.mProgressDialog.show();
        }

        protected void onPostExecute(Integer deleted) {
            Toast.makeText((Context)this.mCtx, (CharSequence)("Cleaning completed, " + deleted + " tiles deleted."), (int)0).show();
            if (this.mProgressDialog.isShowing()) {
                this.mProgressDialog.dismiss();
            }
        }

        protected Integer doInBackground(Object ... params) {
            int errors = this.cleanArea();
            return errors;
        }

        protected int cleanArea() {
            ITileSource tileSource = CacheManager.this.mTileProvider.getTileSource();
            int deleted = 0;
            int tileCounter = 0;
            for (int zoomLevel = this.mZoomMin; zoomLevel <= this.mZoomMax; ++zoomLevel) {
                Point mLowerRight = CacheManager.this.getMapTileFromCoordinates((double)this.mBB.getLatSouthE6() * 1.0E-6, (double)this.mBB.getLonEastE6() * 1.0E-6, zoomLevel);
                Point mUpperLeft = CacheManager.this.getMapTileFromCoordinates((double)this.mBB.getLatNorthE6() * 1.0E-6, (double)this.mBB.getLonWestE6() * 1.0E-6, zoomLevel);
                int mapTileUpperBound = 1 << zoomLevel;
                for (int y = mUpperLeft.y; y <= mLowerRight.y; ++y) {
                    for (int x = mUpperLeft.x; x <= mLowerRight.x; ++x) {
                        int tileY = MyMath.mod(y, mapTileUpperBound);
                        int tileX = MyMath.mod(x, mapTileUpperBound);
                        MapTile tile = new MapTile(zoomLevel, tileX, tileY);
                        File file = CacheManager.this.getFileName(tileSource, tile);
                        if (file.exists()) {
                            file.delete();
                            ++deleted;
                        }
                        if (++tileCounter % 1000 != 0) continue;
                        if (this.isCancelled()) {
                            return deleted;
                        }
                        this.publishProgress(new Integer[]{tileCounter, zoomLevel});
                    }
                }
            }
            return deleted;
        }
    }

    protected class DownloadingTask
    extends CacheManagerTask {
        public DownloadingTask(Context pCtx, BoundingBoxE6 pBB, int pZoomMin, int pZoomMax, CacheManagerCallback callback) {
            super(pCtx, pBB, pZoomMin, pZoomMax, callback);
        }

        protected void onPreExecute() {
            this.mProgressDialog.setTitle((CharSequence)"Downloading tiles");
            this.mProgressDialog.setMessage((CharSequence)CacheManager.this.zoomMessage(this.mZoomMin, this.mZoomMin, this.mZoomMax));
            int total = CacheManager.this.possibleTilesInArea(this.mBB, this.mZoomMin, this.mZoomMax);
            this.mProgressDialog.setMax(total);
            this.mProgressDialog.show();
        }

        protected void onPostExecute(Integer errors) {
            if (errors != 0) {
                Toast.makeText((Context)this.mCtx, (CharSequence)("Loading completed with " + errors + " errors."), (int)0).show();
            }
            if (this.mProgressDialog.isShowing()) {
                this.mProgressDialog.dismiss();
            }
            if (this.callback != null) {
                try {
                    this.callback.onTaskComplete();
                }
                catch (Exception ex) {
                    Log.w((String)"OsmDroid", (String)"Error caught processing cachemanager callback, your implementation is faulty", (Throwable)ex);
                }
            }
        }

        protected Integer doInBackground(Object ... params) {
            int errors = this.downloadArea();
            return errors;
        }

        protected int downloadArea() {
            if (!(CacheManager.this.mTileProvider.getTileSource() instanceof OnlineTileSourceBase)) {
                Log.e((String)"BONUSPACK", (String)"TileSource is not an online tile source");
                return 0;
            }
            OnlineTileSourceBase tileSource = (OnlineTileSourceBase)CacheManager.this.mTileProvider.getTileSource();
            int tileCounter = 0;
            int errors = 0;
            for (int zoomLevel = this.mZoomMin; zoomLevel <= this.mZoomMax; ++zoomLevel) {
                Point mLowerRight = CacheManager.this.getMapTileFromCoordinates((double)this.mBB.getLatSouthE6() * 1.0E-6, (double)this.mBB.getLonEastE6() * 1.0E-6, zoomLevel);
                Point mUpperLeft = CacheManager.this.getMapTileFromCoordinates((double)this.mBB.getLatNorthE6() * 1.0E-6, (double)this.mBB.getLonWestE6() * 1.0E-6, zoomLevel);
                int mapTileUpperBound = 1 << zoomLevel;
                for (int y = mUpperLeft.y; y <= mLowerRight.y; ++y) {
                    for (int x = mUpperLeft.x; x <= mLowerRight.x; ++x) {
                        int tileY = MyMath.mod(y, mapTileUpperBound);
                        int tileX = MyMath.mod(x, mapTileUpperBound);
                        MapTile tile = new MapTile(zoomLevel, tileX, tileY);
                        boolean ok = CacheManager.this.loadTile(tileSource, tile);
                        if (!ok) {
                            ++errors;
                        }
                        if (++tileCounter % 20 != 0) continue;
                        if (this.isCancelled()) {
                            return errors;
                        }
                        this.publishProgress(new Integer[]{tileCounter, zoomLevel});
                    }
                }
            }
            return errors;
        }
    }

    protected abstract class CacheManagerTask
    extends AsyncTask<Object, Integer, Integer> {
        ProgressDialog mProgressDialog;
        int mZoomMin;
        int mZoomMax;
        BoundingBoxE6 mBB;
        Context mCtx;
        CacheManagerCallback callback = null;

        public CacheManagerTask(Context pCtx, BoundingBoxE6 pBB, int pZoomMin, int pZoomMax, CacheManagerCallback callback) {
            this(pCtx, pBB, pZoomMin, pZoomMax);
            this.callback = callback;
        }

        public CacheManagerTask(Context pCtx, BoundingBoxE6 pBB, int pZoomMin, int pZoomMax) {
            this.mCtx = pCtx;
            this.mProgressDialog = this.createProgressDialog(pCtx);
            this.mBB = pBB;
            this.mZoomMin = Math.max(pZoomMin, CacheManager.this.mMapView.getMinZoomLevel());
            this.mZoomMax = Math.min(pZoomMax, CacheManager.this.mMapView.getMaxZoomLevel());
        }

        protected ProgressDialog createProgressDialog(Context pCtx) {
            ProgressDialog pd = new ProgressDialog(pCtx);
            pd.setProgressStyle(1);
            pd.setCancelable(true);
            pd.setOnCancelListener(new DialogInterface.OnCancelListener(){

                public void onCancel(DialogInterface dialog) {
                    CacheManagerTask.this.cancel(true);
                }
            });
            return pd;
        }

        protected void onProgressUpdate(Integer ... count) {
            this.mProgressDialog.setProgress(count[0].intValue());
            this.mProgressDialog.setMessage((CharSequence)CacheManager.this.zoomMessage(count[1], this.mZoomMin, this.mZoomMax));
        }
    }

    public static interface CacheManagerCallback {
        public void onTaskComplete();
    }
}

