/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.tileprovider;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Build;
import java.util.LinkedList;
import org.osmdroid.tileprovider.ReusableBitmapDrawable;

public class BitmapPool {
    final LinkedList<Bitmap> mPool = new LinkedList();
    private static BitmapPool sInstance;

    public static BitmapPool getInstance() {
        if (sInstance == null) {
            sInstance = new BitmapPool();
        }
        return sInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void returnDrawableToPool(ReusableBitmapDrawable drawable) {
        Bitmap b = drawable.tryRecycle();
        if (b != null && b.isMutable()) {
            LinkedList<Bitmap> linkedList = this.mPool;
            synchronized (linkedList) {
                this.mPool.addLast(b);
            }
        }
    }

    public void applyReusableOptions(BitmapFactory.Options aBitmapOptions) {
        if (Build.VERSION.SDK_INT >= 11) {
            aBitmapOptions.inBitmap = this.obtainBitmapFromPool();
            aBitmapOptions.inSampleSize = 1;
            aBitmapOptions.inMutable = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bitmap obtainBitmapFromPool() {
        LinkedList<Bitmap> linkedList = this.mPool;
        synchronized (linkedList) {
            if (this.mPool.isEmpty()) {
                return null;
            }
            Bitmap bitmap = this.mPool.removeFirst();
            if (bitmap.isRecycled()) {
                return this.obtainBitmapFromPool();
            }
            return bitmap;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bitmap obtainSizedBitmapFromPool(int aWidth, int aHeight) {
        LinkedList<Bitmap> linkedList = this.mPool;
        synchronized (linkedList) {
            if (this.mPool.isEmpty()) {
                return null;
            }
            for (Bitmap bitmap : this.mPool) {
                if (bitmap.isRecycled()) {
                    this.mPool.remove(bitmap);
                    return this.obtainSizedBitmapFromPool(aWidth, aHeight);
                }
                if (bitmap.getWidth() != aWidth || bitmap.getHeight() != aHeight) continue;
                this.mPool.remove(bitmap);
                return bitmap;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearBitmapPool() {
        LinkedList<Bitmap> linkedList = BitmapPool.sInstance.mPool;
        synchronized (linkedList) {
            while (!BitmapPool.sInstance.mPool.isEmpty()) {
                Bitmap bitmap = BitmapPool.sInstance.mPool.remove();
                bitmap.recycle();
            }
        }
    }
}

