/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.views.overlay;

import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.view.MotionEvent;
import java.util.ArrayList;
import org.osmdroid.ResourceProxy;
import org.osmdroid.views.MapView;
import org.osmdroid.views.Projection;
import org.osmdroid.views.overlay.Overlay;
import org.osmdroid.views.overlay.OverlayItem;

public abstract class ItemizedOverlay<Item extends OverlayItem>
extends Overlay
implements Overlay.Snappable {
    protected final Drawable mDefaultMarker;
    private final ArrayList<Item> mInternalItemList;
    private final Rect mRect = new Rect();
    private final Point mCurScreenCoords = new Point();
    protected boolean mDrawFocusedItem = true;
    private Item mFocusedItem;
    private boolean mPendingFocusChangedEvent = false;
    private OnFocusChangeListener mOnFocusChangeListener;
    private final float[] mMatrixValues = new float[9];
    private final Matrix mMatrix = new Matrix();
    protected float scaleX = 1.0f;
    protected float scaleY = 1.0f;

    protected abstract Item createItem(int var1);

    public abstract int size();

    public ItemizedOverlay(Drawable pDefaultMarker, ResourceProxy pResourceProxy) {
        super(pResourceProxy);
        if (pDefaultMarker == null) {
            throw new IllegalArgumentException("You must pass a default marker to ItemizedOverlay.");
        }
        this.mDefaultMarker = pDefaultMarker;
        this.mInternalItemList = new ArrayList();
    }

    @Override
    protected void draw(Canvas canvas, MapView mapView, boolean shadow) {
        if (shadow) {
            return;
        }
        if (this.mPendingFocusChangedEvent && this.mOnFocusChangeListener != null) {
            this.mOnFocusChangeListener.onFocusChanged(this, (OverlayItem)this.mFocusedItem);
        }
        this.mPendingFocusChangedEvent = false;
        Projection pj = mapView.getProjection();
        int size = this.mInternalItemList.size() - 1;
        canvas.getMatrix(this.mMatrix);
        this.mMatrix.getValues(this.mMatrixValues);
        this.scaleX = (float)Math.sqrt(this.mMatrixValues[0] * this.mMatrixValues[0] + this.mMatrixValues[3] * this.mMatrixValues[3]);
        this.scaleY = (float)Math.sqrt(this.mMatrixValues[4] * this.mMatrixValues[4] + this.mMatrixValues[1] * this.mMatrixValues[1]);
        for (int i = size; i >= 0; --i) {
            Item item = this.getItem(i);
            if (item == null) continue;
            pj.toPixels(((OverlayItem)item).getPoint(), this.mCurScreenCoords);
            this.onDrawItem(canvas, item, this.mCurScreenCoords, mapView.getMapOrientation());
        }
    }

    protected final void populate() {
        int size = this.size();
        this.mInternalItemList.clear();
        this.mInternalItemList.ensureCapacity(size);
        for (int a = 0; a < size; ++a) {
            this.mInternalItemList.add(this.createItem(a));
        }
    }

    public final Item getItem(int position) {
        try {
            return (Item)((OverlayItem)this.mInternalItemList.get(position));
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
    }

    protected void onDrawItem(Canvas canvas, Item item, Point curScreenCoords, float aMapOrientation) {
        int state = this.mDrawFocusedItem && this.mFocusedItem == item ? 4 : 0;
        Drawable marker = ((OverlayItem)item).getMarker(state) == null ? this.getDefaultMarker(state) : ((OverlayItem)item).getMarker(state);
        OverlayItem.HotspotPlace hotspot = ((OverlayItem)item).getMarkerHotspot();
        this.boundToHotspot(marker, hotspot);
        int x = this.mCurScreenCoords.x;
        int y = this.mCurScreenCoords.y;
        canvas.save();
        canvas.rotate(-aMapOrientation, (float)x, (float)y);
        marker.copyBounds(this.mRect);
        marker.setBounds(this.mRect.left + x, this.mRect.top + y, this.mRect.right + x, this.mRect.bottom + y);
        canvas.scale(1.0f / this.scaleX, 1.0f / this.scaleY, (float)x, (float)y);
        marker.draw(canvas);
        marker.setBounds(this.mRect);
        canvas.restore();
    }

    protected Drawable getDefaultMarker(int state) {
        OverlayItem.setState(this.mDefaultMarker, state);
        return this.mDefaultMarker;
    }

    protected boolean hitTest(Item item, Drawable marker, int hitX, int hitY) {
        return marker.getBounds().contains(hitX, hitY);
    }

    @Override
    public boolean onSingleTapConfirmed(MotionEvent e, MapView mapView) {
        Projection pj = mapView.getProjection();
        Rect screenRect = pj.getIntrinsicScreenRect();
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            Item item = this.getItem(i);
            if (item == null) continue;
            pj.toPixels(((OverlayItem)item).getPoint(), this.mCurScreenCoords);
            int state = this.mDrawFocusedItem && this.mFocusedItem == item ? 4 : 0;
            Drawable marker = ((OverlayItem)item).getMarker(state) == null ? this.getDefaultMarker(state) : ((OverlayItem)item).getMarker(state);
            this.boundToHotspot(marker, ((OverlayItem)item).getMarkerHotspot());
            if (!this.hitTest(item, marker, -this.mCurScreenCoords.x + screenRect.left + (int)e.getX(), -this.mCurScreenCoords.y + screenRect.top + (int)e.getY()) || !this.onTap(i)) continue;
            return true;
        }
        return super.onSingleTapConfirmed(e, mapView);
    }

    protected boolean onTap(int index) {
        return false;
    }

    public void setDrawFocusedItem(boolean drawFocusedItem) {
        this.mDrawFocusedItem = drawFocusedItem;
    }

    public void setFocus(Item item) {
        this.mPendingFocusChangedEvent = item != this.mFocusedItem;
        this.mFocusedItem = item;
    }

    public Item getFocus() {
        return this.mFocusedItem;
    }

    protected synchronized Drawable boundToHotspot(Drawable marker, OverlayItem.HotspotPlace hotspot) {
        int markerWidth = marker.getIntrinsicWidth();
        int markerHeight = marker.getIntrinsicHeight();
        this.mRect.set(0, 0, 0 + markerWidth, 0 + markerHeight);
        if (hotspot == null) {
            hotspot = OverlayItem.HotspotPlace.BOTTOM_CENTER;
        }
        switch (hotspot) {
            default: {
                break;
            }
            case CENTER: {
                this.mRect.offset(-markerWidth / 2, -markerHeight / 2);
                break;
            }
            case BOTTOM_CENTER: {
                this.mRect.offset(-markerWidth / 2, -markerHeight);
                break;
            }
            case TOP_CENTER: {
                this.mRect.offset(-markerWidth / 2, 0);
                break;
            }
            case RIGHT_CENTER: {
                this.mRect.offset(-markerWidth, -markerHeight / 2);
                break;
            }
            case LEFT_CENTER: {
                this.mRect.offset(0, -markerHeight / 2);
                break;
            }
            case UPPER_RIGHT_CORNER: {
                this.mRect.offset(-markerWidth, 0);
                break;
            }
            case LOWER_RIGHT_CORNER: {
                this.mRect.offset(-markerWidth, -markerHeight);
                break;
            }
            case UPPER_LEFT_CORNER: {
                this.mRect.offset(0, 0);
                break;
            }
            case LOWER_LEFT_CORNER: {
                this.mRect.offset(0, -markerHeight);
            }
        }
        marker.setBounds(this.mRect);
        return marker;
    }

    public void setOnFocusChangeListener(OnFocusChangeListener l) {
        this.mOnFocusChangeListener = l;
    }

    public static interface OnFocusChangeListener {
        public void onFocusChanged(ItemizedOverlay<?> var1, OverlayItem var2);
    }
}

