/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.util;

import android.graphics.Point;
import org.osmdroid.util.GeoPoint;

public final class TileSystem {
    public static void setTileSize(int tileSize) {
        microsoft.mappoint.TileSystem.setTileSize(tileSize);
    }

    public static int getTileSize() {
        return microsoft.mappoint.TileSystem.getTileSize();
    }

    public static int MapSize(int levelOfDetail) {
        return microsoft.mappoint.TileSystem.MapSize(levelOfDetail);
    }

    public static double GroundResolution(double latitude, int levelOfDetail) {
        return microsoft.mappoint.TileSystem.GroundResolution(TileSystem.wrap(latitude, -90.0, 90.0, 180.0), levelOfDetail);
    }

    public static double MapScale(double latitude, int levelOfDetail, int screenDpi) {
        return microsoft.mappoint.TileSystem.MapScale(latitude, levelOfDetail, screenDpi);
    }

    public static Point LatLongToPixelXY(double latitude, double longitude, int levelOfDetail, Point reuse) {
        return microsoft.mappoint.TileSystem.LatLongToPixelXY(TileSystem.wrap(latitude, -90.0, 90.0, 180.0), TileSystem.wrap(longitude, -180.0, 180.0, 360.0), levelOfDetail, reuse);
    }

    public static GeoPoint PixelXYToLatLong(int pixelX, int pixelY, int levelOfDetail, GeoPoint reuse) {
        int mapSize = TileSystem.MapSize(levelOfDetail);
        return microsoft.mappoint.TileSystem.PixelXYToLatLong((int)TileSystem.wrap(pixelX, 0.0, mapSize - 1, mapSize), (int)TileSystem.wrap(pixelY, 0.0, mapSize - 1, mapSize), levelOfDetail, reuse);
    }

    public static Point PixelXYToTileXY(int pixelX, int pixelY, Point reuse) {
        return microsoft.mappoint.TileSystem.PixelXYToTileXY(pixelX, pixelY, reuse);
    }

    public static Point TileXYToPixelXY(int tileX, int tileY, Point reuse) {
        return microsoft.mappoint.TileSystem.TileXYToPixelXY(tileX, tileY, reuse);
    }

    public static String TileXYToQuadKey(int tileX, int tileY, int levelOfDetail) {
        return microsoft.mappoint.TileSystem.TileXYToQuadKey(tileX, tileY, levelOfDetail);
    }

    public static Point QuadKeyToTileXY(String quadKey, Point reuse) {
        return microsoft.mappoint.TileSystem.QuadKeyToTileXY(quadKey, reuse);
    }

    private static double wrap(double n, double minValue, double maxValue, double interval) {
        if (minValue > maxValue) {
            throw new IllegalArgumentException("minValue must be smaller than maxValue: " + minValue + ">" + maxValue);
        }
        if (interval > maxValue - minValue + 1.0) {
            throw new IllegalArgumentException("interval must be equal or smaller than maxValue-minValue: min: " + minValue + " max:" + maxValue + " int:" + interval);
        }
        while (n < minValue) {
            n += interval;
        }
        while (n > maxValue) {
            n -= interval;
        }
        return n;
    }
}

