/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.tileprovider.modules;

import android.content.ContentValues;
import android.database.sqlite.SQLiteDatabase;
import android.util.Log;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import org.osmdroid.tileprovider.MapTile;
import org.osmdroid.tileprovider.constants.OpenStreetMapTileProviderConstants;
import org.osmdroid.tileprovider.modules.IFilesystemCache;
import org.osmdroid.tileprovider.tilesource.ITileSource;

public class SqlTileWriter
implements IFilesystemCache {
    final File db_file = new File(OpenStreetMapTileProviderConstants.TILE_PATH_BASE.getAbsolutePath() + File.separator + "cache.db");
    final SQLiteDatabase db = SQLiteDatabase.openOrCreateDatabase((File)this.db_file, null);
    final int questimate = 8000;

    public SqlTileWriter() {
        try {
            this.db.execSQL("CREATE TABLE tiles (key INTEGER , provider TEXT, tile BLOB, expires INTEGER, PRIMARY KEY (key, provider));");
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        Thread t = new Thread(){

            @Override
            public void run() {
                long now = System.currentTimeMillis();
                int rows = SqlTileWriter.this.db.delete("tiles", "expires < ?", new String[]{System.currentTimeMillis() + ""});
                Log.d((String)"OsmDroid", (String)("Local storage cahce purged " + rows + " expired tiles in " + (System.currentTimeMillis() - now) + "ms, cache size is " + SqlTileWriter.this.db_file.length() + "bytes"));
                now = System.currentTimeMillis();
                if (SqlTileWriter.this.db_file.length() > OpenStreetMapTileProviderConstants.TILE_MAX_CACHE_SIZE_BYTES) {
                    long diff = OpenStreetMapTileProviderConstants.TILE_MAX_CACHE_SIZE_BYTES - SqlTileWriter.this.db_file.length();
                    long tilesToKill = diff / 8000L;
                    try {
                        SqlTileWriter.this.db.execSQL("DELETE FROM tiles ORDER BY expires DESC LIMIT " + tilesToKill);
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                    Log.d((String)"OsmDroid", (String)("purge completed in " + (System.currentTimeMillis() - now) + "ms, cache size is " + SqlTileWriter.this.db_file.length() + "bytes"));
                }
                if (OpenStreetMapTileProviderConstants.DEBUGMODE) {
                    Log.d((String)"OsmDroid", (String)"Finished init thread");
                }
            }
        };
        t.setPriority(1);
        t.start();
    }

    @Override
    public boolean saveFile(ITileSource pTileSourceInfo, MapTile pTile, InputStream pStream) {
        try {
            ContentValues cv = new ContentValues();
            long x = pTile.getX();
            long y = pTile.getY();
            long z = pTile.getZoomLevel();
            long index = ((z << (int)z) + x << (int)z) + y;
            cv.put("provider", pTileSourceInfo.name());
            BufferedInputStream bis = new BufferedInputStream(pStream);
            ArrayList<Byte> list = new ArrayList<Byte>();
            int current = 0;
            while ((current = bis.read()) != -1) {
                list.add((byte)current);
            }
            byte[] bits = new byte[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                bits[i] = (Byte)list.get(i);
            }
            cv.put("key", Long.valueOf(index));
            cv.put("tile", bits);
            if (pTile.getExpires() != null) {
                cv.put("expires", Long.valueOf(pTile.getExpires().getTime()));
            }
            this.db.delete("tiles", "key=? and provider=?", new String[]{index + "", pTileSourceInfo.name()});
            this.db.insert("tiles", null, cv);
            Log.d((String)"OsmDroid", (String)("tile inserted " + pTileSourceInfo.name() + pTile.toString()));
        }
        catch (Throwable ex) {
            Log.e((String)"OsmDroid", (String)("Unable to store cached tile from " + pTileSourceInfo.name() + " " + pTile.toString()), (Throwable)ex);
        }
        return false;
    }
}

