/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.views.overlay;

import android.content.Context;
import android.graphics.Point;
import android.graphics.drawable.Drawable;
import android.view.MotionEvent;
import java.util.List;
import org.osmdroid.DefaultResourceProxyImpl;
import org.osmdroid.ResourceProxy;
import org.osmdroid.api.IMapView;
import org.osmdroid.views.MapView;
import org.osmdroid.views.Projection;
import org.osmdroid.views.overlay.ItemizedOverlay;
import org.osmdroid.views.overlay.OverlayItem;

public class ItemizedIconOverlay<Item extends OverlayItem>
extends ItemizedOverlay<Item> {
    protected final List<Item> mItemList;
    protected OnItemGestureListener<Item> mOnItemGestureListener;
    private int mDrawnItemsLimit = Integer.MAX_VALUE;
    private final Point mItemPoint = new Point();

    public ItemizedIconOverlay(List<Item> pList, Drawable pDefaultMarker, OnItemGestureListener<Item> pOnItemGestureListener, ResourceProxy pResourceProxy) {
        super(pDefaultMarker, pResourceProxy);
        this.mItemList = pList;
        this.mOnItemGestureListener = pOnItemGestureListener;
        this.populate();
    }

    public ItemizedIconOverlay(List<Item> pList, OnItemGestureListener<Item> pOnItemGestureListener, ResourceProxy pResourceProxy) {
        this(pList, pResourceProxy.getDrawable(ResourceProxy.bitmap.marker_default), pOnItemGestureListener, pResourceProxy);
    }

    public ItemizedIconOverlay(Context pContext, List<Item> pList, OnItemGestureListener<Item> pOnItemGestureListener) {
        this(pList, new DefaultResourceProxyImpl(pContext).getDrawable(ResourceProxy.bitmap.marker_default), pOnItemGestureListener, new DefaultResourceProxyImpl(pContext));
    }

    @Override
    public boolean onSnapToItem(int pX, int pY, Point pSnapPoint, IMapView pMapView) {
        return false;
    }

    @Override
    protected Item createItem(int index) {
        return (Item)((OverlayItem)this.mItemList.get(index));
    }

    @Override
    public int size() {
        return Math.min(this.mItemList.size(), this.mDrawnItemsLimit);
    }

    public boolean addItem(Item item) {
        boolean result = this.mItemList.add(item);
        this.populate();
        return result;
    }

    public void addItem(int location, Item item) {
        this.mItemList.add(location, item);
        this.populate();
    }

    public boolean addItems(List<Item> items) {
        boolean result = this.mItemList.addAll(items);
        this.populate();
        return result;
    }

    public void removeAllItems() {
        this.removeAllItems(true);
    }

    public void removeAllItems(boolean withPopulate) {
        this.mItemList.clear();
        if (withPopulate) {
            this.populate();
        }
    }

    public boolean removeItem(Item item) {
        boolean result = this.mItemList.remove(item);
        this.populate();
        return result;
    }

    public Item removeItem(int position) {
        OverlayItem result = (OverlayItem)this.mItemList.remove(position);
        this.populate();
        return (Item)result;
    }

    @Override
    public boolean onSingleTapConfirmed(MotionEvent event, final MapView mapView) {
        return this.activateSelectedItems(event, mapView, new ActiveItem(){

            @Override
            public boolean run(int index) {
                ItemizedIconOverlay that = ItemizedIconOverlay.this;
                if (that.mOnItemGestureListener == null) {
                    return false;
                }
                return ItemizedIconOverlay.this.onSingleTapUpHelper(index, (OverlayItem)that.mItemList.get(index), mapView);
            }
        }) ? true : super.onSingleTapConfirmed(event, mapView);
    }

    protected boolean onSingleTapUpHelper(int index, Item item, MapView mapView) {
        return this.mOnItemGestureListener.onItemSingleTapUp(index, item);
    }

    @Override
    public boolean onLongPress(MotionEvent event, MapView mapView) {
        return this.activateSelectedItems(event, mapView, new ActiveItem(){

            @Override
            public boolean run(int index) {
                ItemizedIconOverlay that = ItemizedIconOverlay.this;
                if (that.mOnItemGestureListener == null) {
                    return false;
                }
                return ItemizedIconOverlay.this.onLongPressHelper(index, ItemizedIconOverlay.this.getItem(index));
            }
        }) ? true : super.onLongPress(event, mapView);
    }

    protected boolean onLongPressHelper(int index, Item item) {
        return this.mOnItemGestureListener.onItemLongPress(index, item);
    }

    private boolean activateSelectedItems(MotionEvent event, MapView mapView, ActiveItem task) {
        Projection pj = mapView.getProjection();
        int eventX = (int)event.getX();
        int eventY = (int)event.getY();
        for (int i = 0; i < this.mItemList.size(); ++i) {
            Object item = this.getItem(i);
            if (item == null) continue;
            Drawable marker = ((OverlayItem)item).getMarker(0) == null ? this.mDefaultMarker : ((OverlayItem)item).getMarker(0);
            pj.toPixels(((OverlayItem)item).getPoint(), this.mItemPoint);
            if (!this.hitTest(item, marker, eventX - this.mItemPoint.x, eventY - this.mItemPoint.y) || !task.run(i)) continue;
            return true;
        }
        return false;
    }

    public int getDrawnItemsLimit() {
        return this.mDrawnItemsLimit;
    }

    public void setDrawnItemsLimit(int aLimit) {
        this.mDrawnItemsLimit = aLimit;
    }

    public static interface ActiveItem {
        public boolean run(int var1);
    }

    public static interface OnItemGestureListener<T> {
        public boolean onItemSingleTapUp(int var1, T var2);

        public boolean onItemLongPress(int var1, T var2);
    }
}

