/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.tileprovider.modules;

import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.util.Log;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import org.osmdroid.tileprovider.MapTile;
import org.osmdroid.tileprovider.modules.IArchiveFile;
import org.osmdroid.tileprovider.tilesource.ITileSource;

public class DatabaseFileArchive
implements IArchiveFile {
    private SQLiteDatabase mDatabase;

    public DatabaseFileArchive() {
    }

    private DatabaseFileArchive(SQLiteDatabase pDatabase) {
        this.mDatabase = pDatabase;
    }

    public static DatabaseFileArchive getDatabaseFileArchive(File pFile) throws SQLiteException {
        return new DatabaseFileArchive(SQLiteDatabase.openDatabase((String)pFile.getAbsolutePath(), null, (int)1));
    }

    @Override
    public Set<String> getTileSources() {
        HashSet<String> ret = new HashSet<String>();
        try {
            String[] tile = new String[]{"provider"};
            Cursor cur = this.mDatabase.rawQuery("SELECT distinct provider FROM tiles", null);
            while (cur.moveToNext()) {
                ret.add(cur.getString(0));
            }
            cur.close();
        }
        catch (Exception e) {
            Log.w((String)"OsmDroid", (String)"Error getting tile sources: ", (Throwable)e);
        }
        return ret;
    }

    @Override
    public void init(File pFile) throws Exception {
        this.mDatabase = SQLiteDatabase.openDatabase((String)pFile.getAbsolutePath(), null, (int)1);
    }

    @Override
    public InputStream getInputStream(ITileSource pTileSource, MapTile pTile) {
        try {
            ByteArrayInputStream ret = null;
            String[] tile = new String[]{"tile"};
            long x = pTile.getX();
            long y = pTile.getY();
            long z = pTile.getZoomLevel();
            long index = ((z << (int)z) + x << (int)z) + y;
            Cursor cur = this.mDatabase.query("tiles", tile, "key = " + index + " and provider = '" + pTileSource.name() + "'", null, null, null, null);
            if (cur.getCount() != 0) {
                cur.moveToFirst();
                ret = new ByteArrayInputStream(cur.getBlob(0));
            }
            cur.close();
            if (ret != null) {
                return ret;
            }
        }
        catch (Throwable e) {
            Log.w((String)"OsmDroid", (String)("Error getting db stream: " + pTile), (Throwable)e);
        }
        return null;
    }

    @Override
    public void close() {
        this.mDatabase.close();
    }

    public String toString() {
        return "DatabaseFileArchive [mDatabase=" + this.mDatabase.getPath() + "]";
    }
}

