/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.tileprovider;

import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;

public class ExpirableBitmapDrawable
extends BitmapDrawable {
    private static final int EXPIRED = -1;
    private int[] mState = new int[0];

    public ExpirableBitmapDrawable(Bitmap pBitmap) {
        super(pBitmap);
    }

    public int[] getState() {
        return this.mState;
    }

    public boolean isStateful() {
        return this.mState.length > 0;
    }

    public boolean setState(int[] pStateSet) {
        this.mState = pStateSet;
        return true;
    }

    public static boolean isDrawableExpired(Drawable pTile) {
        if (!pTile.isStateful()) {
            return false;
        }
        int[] state = pTile.getState();
        for (int i = 0; i < state.length; ++i) {
            if (state[i] != -1) continue;
            return true;
        }
        return false;
    }

    public static void setDrawableExpired(Drawable pTile) {
        pTile.setState(new int[]{-1});
    }
}

