/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.views;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ValueAnimator;
import android.graphics.Point;
import android.graphics.Rect;
import android.os.Build;
import android.view.View;
import android.view.animation.Animation;
import android.view.animation.ScaleAnimation;
import java.util.LinkedList;
import org.osmdroid.api.IGeoPoint;
import org.osmdroid.api.IMapController;
import org.osmdroid.util.BoundingBoxE6;
import org.osmdroid.views.MapView;
import org.osmdroid.views.util.MyMath;
import org.osmdroid.views.util.constants.MapViewConstants;

public class MapController
implements IMapController,
MapViewConstants,
MapView.OnFirstLayoutListener {
    protected final MapView mMapView;
    private ValueAnimator mZoomInAnimation;
    private ValueAnimator mZoomOutAnimation;
    private ScaleAnimation mZoomInAnimationOld;
    private ScaleAnimation mZoomOutAnimationOld;
    private Animator mCurrentAnimator;
    private ReplayController mReplayController;

    public MapController(MapView mapView) {
        this.mMapView = mapView;
        this.mReplayController = new ReplayController();
        if (!this.mMapView.isLayoutOccurred()) {
            this.mMapView.addOnFirstLayoutListener(this);
        }
        if (Build.VERSION.SDK_INT >= 11) {
            this.mZoomInAnimation = ValueAnimator.ofFloat((float[])new float[]{1.0f, 2.0f});
            this.mZoomInAnimation.addListener((Animator.AnimatorListener)new MyZoomAnimatorListener());
            this.mZoomInAnimation.addUpdateListener((ValueAnimator.AnimatorUpdateListener)new MyZoomAnimatorUpdateListener());
            this.mZoomInAnimation.setDuration(500L);
            this.mZoomOutAnimation = ValueAnimator.ofFloat((float[])new float[]{1.0f, 0.5f});
            this.mZoomOutAnimation.addListener((Animator.AnimatorListener)new MyZoomAnimatorListener());
            this.mZoomOutAnimation.addUpdateListener((ValueAnimator.AnimatorUpdateListener)new MyZoomAnimatorUpdateListener());
            this.mZoomOutAnimation.setDuration(500L);
        } else {
            this.mZoomInAnimationOld = new ScaleAnimation(1.0f, 2.0f, 1.0f, 2.0f, 1, 0.5f, 1, 0.5f);
            this.mZoomOutAnimationOld = new ScaleAnimation(1.0f, 0.5f, 1.0f, 0.5f, 1, 0.5f, 1, 0.5f);
            this.mZoomInAnimationOld.setDuration(500L);
            this.mZoomOutAnimationOld.setDuration(500L);
            this.mZoomInAnimationOld.setAnimationListener((Animation.AnimationListener)new MyZoomAnimationListener());
            this.mZoomOutAnimationOld.setAnimationListener((Animation.AnimationListener)new MyZoomAnimationListener());
        }
    }

    @Override
    public void onFirstLayout(View v, int left, int top, int right, int bottom) {
        this.mReplayController.replayCalls();
    }

    public void zoomToSpan(BoundingBoxE6 bb) {
        this.zoomToSpan(bb.getLatitudeSpanE6(), bb.getLongitudeSpanE6());
    }

    @Override
    public void zoomToSpan(int latSpanE6, int lonSpanE6) {
        int curLonSpan;
        float diffNeededLon;
        if (latSpanE6 <= 0 || lonSpanE6 <= 0) {
            return;
        }
        if (!this.mMapView.isLayoutOccurred()) {
            this.mReplayController.zoomToSpan(latSpanE6, lonSpanE6);
            return;
        }
        BoundingBoxE6 bb = this.mMapView.getProjection().getBoundingBox();
        int curZoomLevel = this.mMapView.getProjection().getZoomLevel();
        int curLatSpan = bb.getLatitudeSpanE6();
        float diffNeededLat = (float)latSpanE6 / (float)curLatSpan;
        float diffNeeded = Math.max(diffNeededLat, diffNeededLon = (float)lonSpanE6 / (float)(curLonSpan = bb.getLongitudeSpanE6()));
        if (diffNeeded > 1.0f) {
            this.mMapView.setZoomLevel(curZoomLevel - MyMath.getNextSquareNumberAbove(diffNeeded));
        } else if ((double)diffNeeded < 0.5) {
            this.mMapView.setZoomLevel(curZoomLevel + MyMath.getNextSquareNumberAbove(1.0f / diffNeeded) - 1);
        }
    }

    @Override
    public void animateTo(IGeoPoint point) {
        if (!this.mMapView.isLayoutOccurred()) {
            this.mReplayController.animateTo(point);
            return;
        }
        Point p = this.mMapView.getProjection().toPixels(point, null);
        this.animateTo(p.x, p.y);
    }

    public void animateTo(int x, int y) {
        if (!this.mMapView.isLayoutOccurred()) {
            this.mReplayController.animateTo(x, y);
            return;
        }
        if (!this.mMapView.isAnimating()) {
            this.mMapView.mIsFlinging = false;
            Point mercatorPoint = this.mMapView.getProjection().toMercatorPixels(x, y, null);
            mercatorPoint.offset(-this.mMapView.getWidth() / 2, -this.mMapView.getHeight() / 2);
            int xStart = this.mMapView.getScrollX();
            int yStart = this.mMapView.getScrollY();
            this.mMapView.getScroller().startScroll(xStart, yStart, mercatorPoint.x - xStart, mercatorPoint.y - yStart, 1000);
            this.mMapView.postInvalidate();
        }
    }

    @Override
    public void scrollBy(int x, int y) {
        this.mMapView.scrollBy(x, y);
    }

    @Override
    public void setCenter(IGeoPoint point) {
        if (!this.mMapView.isLayoutOccurred()) {
            this.mReplayController.setCenter(point);
            return;
        }
        Point p = this.mMapView.getProjection().toPixels(point, null);
        p = this.mMapView.getProjection().toMercatorPixels(p.x, p.y, p);
        p.offset(-this.mMapView.getWidth() / 2, -this.mMapView.getHeight() / 2);
        this.mMapView.scrollTo(p.x, p.y);
    }

    @Override
    public void stopPanning() {
        this.mMapView.mIsFlinging = false;
        this.mMapView.getScroller().forceFinished(true);
    }

    @Override
    public void stopAnimation(boolean jumpToTarget) {
        if (!this.mMapView.getScroller().isFinished()) {
            if (jumpToTarget) {
                this.mMapView.mIsFlinging = false;
                this.mMapView.getScroller().abortAnimation();
            } else {
                this.stopPanning();
            }
        }
        if (Build.VERSION.SDK_INT >= 11) {
            Animator currentAnimator = this.mCurrentAnimator;
            if (this.mMapView.mIsAnimating.get()) {
                currentAnimator.end();
            }
        } else if (this.mMapView.mIsAnimating.get()) {
            this.mMapView.clearAnimation();
        }
    }

    @Override
    public int setZoom(int zoomlevel) {
        return this.mMapView.setZoomLevel(zoomlevel);
    }

    @Override
    public boolean zoomIn() {
        return this.zoomInFixing(this.mMapView.getWidth() / 2, this.mMapView.getHeight() / 2);
    }

    @Override
    public boolean zoomInFixing(int xPixel, int yPixel) {
        this.mMapView.mMultiTouchScalePoint.set((float)xPixel, (float)yPixel);
        if (this.mMapView.canZoomIn()) {
            if (this.mMapView.mIsAnimating.getAndSet(true)) {
                return false;
            }
            this.mMapView.mTargetZoomLevel.set(this.mMapView.getZoomLevel(false) + 1);
            if (Build.VERSION.SDK_INT >= 11) {
                this.mCurrentAnimator = this.mZoomInAnimation;
                this.mZoomInAnimation.start();
            } else {
                this.mMapView.startAnimation((Animation)this.mZoomInAnimationOld);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean zoomOut() {
        return this.zoomOutFixing(this.mMapView.getWidth() / 2, this.mMapView.getHeight() / 2);
    }

    @Override
    public boolean zoomOutFixing(int xPixel, int yPixel) {
        this.mMapView.mMultiTouchScalePoint.set((float)xPixel, (float)yPixel);
        if (this.mMapView.canZoomOut()) {
            if (this.mMapView.mIsAnimating.getAndSet(true)) {
                return false;
            }
            this.mMapView.mTargetZoomLevel.set(this.mMapView.getZoomLevel(false) - 1);
            if (Build.VERSION.SDK_INT >= 11) {
                this.mCurrentAnimator = this.mZoomOutAnimation;
                this.mZoomOutAnimation.start();
            } else {
                this.mMapView.startAnimation((Animation)this.mZoomOutAnimationOld);
            }
            return true;
        }
        return false;
    }

    protected void onAnimationStart() {
        this.mMapView.mIsAnimating.set(true);
    }

    protected void onAnimationEnd() {
        Rect screenRect = this.mMapView.getProjection().getScreenRect();
        Point p = this.mMapView.getProjection().unrotateAndScalePoint(screenRect.centerX(), screenRect.centerY(), null);
        p = this.mMapView.getProjection().toMercatorPixels(p.x, p.y, p);
        p.offset(-this.mMapView.getWidth() / 2, -this.mMapView.getHeight() / 2);
        this.mMapView.mIsAnimating.set(false);
        this.mMapView.scrollTo(p.x, p.y);
        this.setZoom(this.mMapView.mTargetZoomLevel.get());
        this.mMapView.mMultiTouchScale = 1.0f;
        if (Build.VERSION.SDK_INT >= 11) {
            this.mCurrentAnimator = null;
        }
        if (Build.VERSION.SDK_INT <= 10) {
            this.mMapView.clearAnimation();
            this.mZoomInAnimationOld.reset();
            this.mZoomOutAnimationOld.reset();
        }
    }

    private class ReplayController {
        private LinkedList<ReplayClass> mReplayList = new LinkedList();

        private ReplayController() {
        }

        public void animateTo(IGeoPoint geoPoint) {
            this.mReplayList.add(new ReplayClass(ReplayType.AnimateToGeoPoint, null, geoPoint));
        }

        public void animateTo(int x, int y) {
            this.mReplayList.add(new ReplayClass(ReplayType.AnimateToPoint, new Point(x, y), null));
        }

        public void setCenter(IGeoPoint geoPoint) {
            this.mReplayList.add(new ReplayClass(ReplayType.SetCenterPoint, null, geoPoint));
        }

        public void zoomToSpan(int x, int y) {
            this.mReplayList.add(new ReplayClass(ReplayType.ZoomToSpanPoint, new Point(x, y), null));
        }

        public void replayCalls() {
            for (ReplayClass replay : this.mReplayList) {
                switch (replay.mReplayType) {
                    case AnimateToGeoPoint: {
                        MapController.this.animateTo(replay.mGeoPoint);
                        break;
                    }
                    case AnimateToPoint: {
                        MapController.this.animateTo(((ReplayClass)replay).mPoint.x, ((ReplayClass)replay).mPoint.y);
                        break;
                    }
                    case SetCenterPoint: {
                        MapController.this.setCenter(replay.mGeoPoint);
                        break;
                    }
                    case ZoomToSpanPoint: {
                        MapController.this.zoomToSpan(((ReplayClass)replay).mPoint.x, ((ReplayClass)replay).mPoint.y);
                    }
                }
            }
            this.mReplayList.clear();
        }

        private class ReplayClass {
            private ReplayType mReplayType;
            private Point mPoint;
            private IGeoPoint mGeoPoint;

            public ReplayClass(ReplayType mReplayType, Point mPoint, IGeoPoint mGeoPoint) {
                this.mReplayType = mReplayType;
                this.mPoint = mPoint;
                this.mGeoPoint = mGeoPoint;
            }
        }
    }

    private static enum ReplayType {
        ZoomToSpanPoint,
        AnimateToPoint,
        AnimateToGeoPoint,
        SetCenterPoint;

    }

    protected class MyZoomAnimationListener
    implements Animation.AnimationListener {
        protected MyZoomAnimationListener() {
        }

        public void onAnimationStart(Animation animation) {
            MapController.this.onAnimationStart();
        }

        public void onAnimationEnd(Animation animation) {
            MapController.this.onAnimationEnd();
        }

        public void onAnimationRepeat(Animation animation) {
        }
    }

    protected class MyZoomAnimatorUpdateListener
    implements ValueAnimator.AnimatorUpdateListener {
        protected MyZoomAnimatorUpdateListener() {
        }

        public void onAnimationUpdate(ValueAnimator animation) {
            MapController.this.mMapView.mMultiTouchScale = ((Float)animation.getAnimatedValue()).floatValue();
            MapController.this.mMapView.invalidate();
        }
    }

    protected class MyZoomAnimatorListener
    extends AnimatorListenerAdapter {
        protected MyZoomAnimatorListener() {
        }

        public void onAnimationStart(Animator animation) {
            MapController.this.onAnimationStart();
            super.onAnimationStart(animation);
        }

        public void onAnimationEnd(Animator animation) {
            MapController.this.onAnimationEnd();
            super.onAnimationEnd(animation);
        }
    }
}

