/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.tileprovider;

import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import java.util.LinkedHashMap;
import java.util.Map;
import org.osmdroid.tileprovider.BitmapPool;
import org.osmdroid.tileprovider.MapTile;
import org.osmdroid.tileprovider.ReusableBitmapDrawable;
import org.osmdroid.tileprovider.constants.OpenStreetMapTileProviderConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LRUMapTileCache
extends LinkedHashMap<MapTile, Drawable>
implements OpenStreetMapTileProviderConstants {
    private static final Logger logger = LoggerFactory.getLogger(LRUMapTileCache.class);
    private static final long serialVersionUID = -541142277575493335L;
    private int mCapacity;
    private TileRemovedListener mTileRemovedListener;

    public LRUMapTileCache(int aCapacity) {
        super(aCapacity + 2, 0.1f, true);
        this.mCapacity = aCapacity;
    }

    public void ensureCapacity(int aCapacity) {
        if (aCapacity > this.mCapacity) {
            logger.info("Tile cache increased from " + this.mCapacity + " to " + aCapacity);
            this.mCapacity = aCapacity;
        }
    }

    @Override
    public Drawable remove(Object aKey) {
        Bitmap bitmap2;
        Drawable drawable = (Drawable)super.remove(aKey);
        if (Build.VERSION.SDK_INT < 9 && drawable instanceof BitmapDrawable && (bitmap2 = ((BitmapDrawable)drawable).getBitmap()) != null) {
            bitmap2.recycle();
        }
        if (this.getTileRemovedListener() != null && aKey instanceof MapTile) {
            this.getTileRemovedListener().onTileRemoved((MapTile)aKey);
        }
        if (drawable instanceof ReusableBitmapDrawable) {
            BitmapPool.getInstance().returnDrawableToPool((ReusableBitmapDrawable)drawable);
        }
        return drawable;
    }

    @Override
    public void clear() {
        while (!this.isEmpty()) {
            this.remove(this.keySet().iterator().next());
        }
        super.clear();
    }

    @Override
    protected boolean removeEldestEntry(Map.Entry<MapTile, Drawable> aEldest) {
        if (this.size() > this.mCapacity) {
            MapTile eldest = aEldest.getKey();
            this.remove(eldest);
        }
        return false;
    }

    public TileRemovedListener getTileRemovedListener() {
        return this.mTileRemovedListener;
    }

    public void setTileRemovedListener(TileRemovedListener tileRemovedListener) {
        this.mTileRemovedListener = tileRemovedListener;
    }

    public static interface TileRemovedListener {
        public void onTileRemoved(MapTile var1);
    }
}

