/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.views.overlay;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.view.Menu;
import android.view.MenuItem;
import android.view.SubMenu;
import org.osmdroid.DefaultResourceProxyImpl;
import org.osmdroid.ResourceProxy;
import org.osmdroid.tileprovider.MapTile;
import org.osmdroid.tileprovider.MapTileProviderBase;
import org.osmdroid.tileprovider.ReusableBitmapDrawable;
import org.osmdroid.tileprovider.tilesource.ITileSource;
import org.osmdroid.tileprovider.tilesource.TileSourceFactory;
import org.osmdroid.util.TileLooper;
import org.osmdroid.util.TileSystem;
import org.osmdroid.views.MapView;
import org.osmdroid.views.Projection;
import org.osmdroid.views.overlay.IOverlayMenuProvider;
import org.osmdroid.views.overlay.Overlay;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TilesOverlay
extends Overlay
implements IOverlayMenuProvider {
    private static final Logger logger = LoggerFactory.getLogger(TilesOverlay.class);
    public static final int MENU_MAP_MODE = TilesOverlay.getSafeMenuId();
    public static final int MENU_TILE_SOURCE_STARTING_ID = TilesOverlay.getSafeMenuIdSequence(TileSourceFactory.getTileSources().size());
    public static final int MENU_OFFLINE = TilesOverlay.getSafeMenuId();
    protected final MapTileProviderBase mTileProvider;
    protected final Paint mDebugPaint = new Paint();
    private final Rect mTileRect = new Rect();
    private final Point mTilePoint = new Point();
    private final Rect mViewPort = new Rect();
    private Point mTopLeftMercator = new Point();
    private Point mBottomRightMercator = new Point();
    private Point mTilePointMercator = new Point();
    private Projection mProjection;
    private boolean mOptionsMenuEnabled = true;
    private BitmapDrawable mLoadingTile = null;
    private int mLoadingBackgroundColor = Color.rgb((int)216, (int)208, (int)208);
    private int mLoadingLineColor = Color.rgb((int)200, (int)192, (int)192);
    private int mOvershootTileCache = 0;
    private final TileLooper mTileLooper = new TileLooper(){

        @Override
        public void initialiseLoop(int pZoomLevel, int pTileSizePx) {
            int numNeeded = (this.mLowerRight.y - this.mUpperLeft.y + 1) * (this.mLowerRight.x - this.mUpperLeft.x + 1);
            TilesOverlay.this.mTileProvider.ensureCapacity(numNeeded + TilesOverlay.this.mOvershootTileCache);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleTile(Canvas pCanvas, int pTileSizePx, MapTile pTile, int pX, int pY) {
            ReusableBitmapDrawable reusableBitmapDrawable;
            Drawable currentMapTile = TilesOverlay.this.mTileProvider.getMapTile(pTile);
            boolean isReusable = currentMapTile instanceof ReusableBitmapDrawable;
            ReusableBitmapDrawable reusableBitmapDrawable2 = reusableBitmapDrawable = isReusable ? (ReusableBitmapDrawable)currentMapTile : null;
            if (currentMapTile == null) {
                currentMapTile = TilesOverlay.this.getLoadingTile();
            }
            if (currentMapTile != null) {
                TilesOverlay.this.mTilePoint.set(pX * pTileSizePx, pY * pTileSizePx);
                TilesOverlay.this.mTileRect.set(((TilesOverlay)TilesOverlay.this).mTilePoint.x, ((TilesOverlay)TilesOverlay.this).mTilePoint.y, ((TilesOverlay)TilesOverlay.this).mTilePoint.x + pTileSizePx, ((TilesOverlay)TilesOverlay.this).mTilePoint.y + pTileSizePx);
                if (isReusable) {
                    reusableBitmapDrawable.beginUsingDrawable();
                }
                try {
                    if (isReusable && !((ReusableBitmapDrawable)currentMapTile).isBitmapValid()) {
                        currentMapTile = TilesOverlay.this.getLoadingTile();
                        isReusable = false;
                    }
                    TilesOverlay.this.onTileReadyToDraw(pCanvas, currentMapTile, TilesOverlay.this.mTileRect);
                }
                finally {
                    if (isReusable) {
                        reusableBitmapDrawable.finishUsingDrawable();
                    }
                }
            }
        }

        @Override
        public void finaliseLoop() {
        }
    };

    public TilesOverlay(MapTileProviderBase aTileProvider, Context aContext) {
        this(aTileProvider, new DefaultResourceProxyImpl(aContext));
    }

    public TilesOverlay(MapTileProviderBase aTileProvider, ResourceProxy pResourceProxy) {
        super(pResourceProxy);
        if (aTileProvider == null) {
            throw new IllegalArgumentException("You must pass a valid tile provider to the tiles overlay.");
        }
        this.mTileProvider = aTileProvider;
    }

    @Override
    public void onDetach(MapView pMapView) {
        this.mTileProvider.detach();
    }

    public int getMinimumZoomLevel() {
        return this.mTileProvider.getMinimumZoomLevel();
    }

    public int getMaximumZoomLevel() {
        return this.mTileProvider.getMaximumZoomLevel();
    }

    public boolean useDataConnection() {
        return this.mTileProvider.useDataConnection();
    }

    public void setUseDataConnection(boolean aMode) {
        this.mTileProvider.setUseDataConnection(aMode);
    }

    @Override
    protected void draw(Canvas c, MapView osmv, boolean shadow) {
        if (shadow) {
            return;
        }
        Projection projection = osmv.getProjection();
        Rect screenRect = projection.getScreenRect();
        projection.toMercatorPixels(screenRect.left, screenRect.top, this.mTopLeftMercator);
        projection.toMercatorPixels(screenRect.right, screenRect.bottom, this.mBottomRightMercator);
        this.mViewPort.set(this.mTopLeftMercator.x, this.mTopLeftMercator.y, this.mBottomRightMercator.x, this.mBottomRightMercator.y);
        this.drawTiles(c, projection, projection.getZoomLevel(), TileSystem.getTileSize(), this.mViewPort);
    }

    public void drawTiles(Canvas c, Projection projection, int zoomLevel, int tileSizePx, Rect viewPort) {
        this.mProjection = projection;
        this.mTileLooper.loop(c, zoomLevel, tileSizePx, viewPort);
    }

    protected void onTileReadyToDraw(Canvas c, Drawable currentMapTile, Rect tileRect) {
        this.mProjection.toPixelsFromMercator(tileRect.left, tileRect.top, this.mTilePointMercator);
        tileRect.offsetTo(this.mTilePointMercator.x, this.mTilePointMercator.y);
        currentMapTile.setBounds(tileRect);
        currentMapTile.draw(c);
    }

    @Override
    public void setOptionsMenuEnabled(boolean pOptionsMenuEnabled) {
        this.mOptionsMenuEnabled = pOptionsMenuEnabled;
    }

    @Override
    public boolean isOptionsMenuEnabled() {
        return this.mOptionsMenuEnabled;
    }

    @Override
    public boolean onCreateOptionsMenu(Menu pMenu, int pMenuIdOffset, MapView pMapView) {
        SubMenu mapMenu = pMenu.addSubMenu(0, MENU_MAP_MODE + pMenuIdOffset, 0, (CharSequence)this.mResourceProxy.getString(ResourceProxy.string.map_mode)).setIcon(this.mResourceProxy.getDrawable(ResourceProxy.bitmap.ic_menu_mapmode));
        for (int a = 0; a < TileSourceFactory.getTileSources().size(); ++a) {
            ITileSource tileSource = TileSourceFactory.getTileSources().get(a);
            mapMenu.add(MENU_MAP_MODE + pMenuIdOffset, MENU_TILE_SOURCE_STARTING_ID + a + pMenuIdOffset, 0, (CharSequence)tileSource.localizedName(this.mResourceProxy));
        }
        mapMenu.setGroupCheckable(MENU_MAP_MODE + pMenuIdOffset, true, true);
        String title = pMapView.getResourceProxy().getString(pMapView.useDataConnection() ? ResourceProxy.string.offline_mode : ResourceProxy.string.online_mode);
        Drawable icon = pMapView.getResourceProxy().getDrawable(ResourceProxy.bitmap.ic_menu_offline);
        pMenu.add(0, MENU_OFFLINE + pMenuIdOffset, 0, (CharSequence)title).setIcon(icon);
        return true;
    }

    @Override
    public boolean onPrepareOptionsMenu(Menu pMenu, int pMenuIdOffset, MapView pMapView) {
        int index = TileSourceFactory.getTileSources().indexOf(pMapView.getTileProvider().getTileSource());
        if (index >= 0) {
            pMenu.findItem(MENU_TILE_SOURCE_STARTING_ID + index + pMenuIdOffset).setChecked(true);
        }
        pMenu.findItem(MENU_OFFLINE + pMenuIdOffset).setTitle((CharSequence)pMapView.getResourceProxy().getString(pMapView.useDataConnection() ? ResourceProxy.string.offline_mode : ResourceProxy.string.online_mode));
        return true;
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem pItem, int pMenuIdOffset, MapView pMapView) {
        int menuId = pItem.getItemId() - pMenuIdOffset;
        if (menuId >= MENU_TILE_SOURCE_STARTING_ID && menuId < MENU_TILE_SOURCE_STARTING_ID + TileSourceFactory.getTileSources().size()) {
            pMapView.setTileSource(TileSourceFactory.getTileSources().get(menuId - MENU_TILE_SOURCE_STARTING_ID));
            return true;
        }
        if (menuId == MENU_OFFLINE) {
            boolean useDataConnection = !pMapView.useDataConnection();
            pMapView.setUseDataConnection(useDataConnection);
            return true;
        }
        return false;
    }

    public int getLoadingBackgroundColor() {
        return this.mLoadingBackgroundColor;
    }

    public void setLoadingBackgroundColor(int pLoadingBackgroundColor) {
        if (this.mLoadingBackgroundColor != pLoadingBackgroundColor) {
            this.mLoadingBackgroundColor = pLoadingBackgroundColor;
            this.clearLoadingTile();
        }
    }

    public int getLoadingLineColor() {
        return this.mLoadingLineColor;
    }

    public void setLoadingLineColor(int pLoadingLineColor) {
        if (this.mLoadingLineColor != pLoadingLineColor) {
            this.mLoadingLineColor = pLoadingLineColor;
            this.clearLoadingTile();
        }
    }

    private Drawable getLoadingTile() {
        if (this.mLoadingTile == null && this.mLoadingBackgroundColor != 0) {
            try {
                int tileSize = this.mTileProvider.getTileSource() != null ? this.mTileProvider.getTileSource().getTileSizePixels() : 256;
                Bitmap bitmap2 = Bitmap.createBitmap((int)tileSize, (int)tileSize, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                Canvas canvas = new Canvas(bitmap2);
                Paint paint = new Paint();
                canvas.drawColor(this.mLoadingBackgroundColor);
                paint.setColor(this.mLoadingLineColor);
                paint.setStrokeWidth(0.0f);
                int lineSize = tileSize / 16;
                for (int a = 0; a < tileSize; a += lineSize) {
                    canvas.drawLine(0.0f, (float)a, (float)tileSize, (float)a, paint);
                    canvas.drawLine((float)a, 0.0f, (float)a, (float)tileSize, paint);
                }
                this.mLoadingTile = new BitmapDrawable(bitmap2);
            }
            catch (OutOfMemoryError e) {
                logger.error("OutOfMemoryError getting loading tile");
                System.gc();
            }
        }
        return this.mLoadingTile;
    }

    private void clearLoadingTile() {
        BitmapDrawable bitmapDrawable = this.mLoadingTile;
        this.mLoadingTile = null;
        if (Build.VERSION.SDK_INT < 9 && bitmapDrawable != null) {
            bitmapDrawable.getBitmap().recycle();
        }
    }

    public void setOvershootTileCache(int overshootTileCache) {
        this.mOvershootTileCache = overshootTileCache;
    }

    public int getOvershootTileCache() {
        return this.mOvershootTileCache;
    }
}

