/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.views;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ValueAnimator;
import android.graphics.Matrix;
import android.graphics.Point;
import android.graphics.Rect;
import android.os.Build;
import android.view.animation.Animation;
import android.view.animation.ScaleAnimation;
import org.osmdroid.api.IGeoPoint;
import org.osmdroid.api.IMapController;
import org.osmdroid.util.BoundingBoxE6;
import org.osmdroid.views.MapView;
import org.osmdroid.views.util.MyMath;
import org.osmdroid.views.util.constants.MapViewConstants;

public class MapController
implements IMapController,
MapViewConstants {
    protected final MapView mMapView;
    private ValueAnimator mZoomInAnimation;
    private ValueAnimator mZoomOutAnimation;
    private ScaleAnimation mZoomInAnimationOld;
    private ScaleAnimation mZoomOutAnimationOld;
    private Animator mCurrentAnimator;

    public MapController(MapView mapView) {
        this.mMapView = mapView;
        if (Build.VERSION.SDK_INT >= 11) {
            this.mZoomInAnimation = ValueAnimator.ofFloat((float[])new float[]{1.0f, 2.0f});
            this.mZoomInAnimation.addListener((Animator.AnimatorListener)new MyZoomAnimatorListener());
            this.mZoomInAnimation.addUpdateListener((ValueAnimator.AnimatorUpdateListener)new MyZoomAnimatorUpdateListener());
            this.mZoomInAnimation.setDuration(500L);
            this.mZoomOutAnimation = ValueAnimator.ofFloat((float[])new float[]{1.0f, 0.5f});
            this.mZoomOutAnimation.addListener((Animator.AnimatorListener)new MyZoomAnimatorListener());
            this.mZoomOutAnimation.addUpdateListener((ValueAnimator.AnimatorUpdateListener)new MyZoomAnimatorUpdateListener());
            this.mZoomOutAnimation.setDuration(500L);
        } else {
            this.mZoomInAnimationOld = new ScaleAnimation(1.0f, 2.0f, 1.0f, 2.0f, 1, 0.5f, 1, 0.5f);
            this.mZoomOutAnimationOld = new ScaleAnimation(1.0f, 0.5f, 1.0f, 0.5f, 1, 0.5f, 1, 0.5f);
            this.mZoomInAnimationOld.setDuration(500L);
            this.mZoomOutAnimationOld.setDuration(500L);
            this.mZoomInAnimationOld.setAnimationListener((Animation.AnimationListener)new MyZoomAnimationListener());
            this.mZoomOutAnimationOld.setAnimationListener((Animation.AnimationListener)new MyZoomAnimationListener());
        }
    }

    public void zoomToSpan(BoundingBoxE6 bb) {
        this.zoomToSpan(bb.getLatitudeSpanE6(), bb.getLongitudeSpanE6());
    }

    @Override
    public void zoomToSpan(int latSpanE6, int lonSpanE6) {
        int curLonSpan;
        float diffNeededLon;
        if (latSpanE6 <= 0 || lonSpanE6 <= 0) {
            return;
        }
        BoundingBoxE6 bb = this.mMapView.getBoundingBox();
        int curZoomLevel = this.mMapView.getZoomLevel();
        int curLatSpan = bb.getLatitudeSpanE6();
        float diffNeededLat = (float)latSpanE6 / (float)curLatSpan;
        float diffNeeded = Math.max(diffNeededLat, diffNeededLon = (float)lonSpanE6 / (float)(curLonSpan = bb.getLongitudeSpanE6()));
        if (diffNeeded > 1.0f) {
            this.mMapView.setZoomLevel(curZoomLevel - MyMath.getNextSquareNumberAbove(diffNeeded));
        } else if ((double)diffNeeded < 0.5) {
            this.mMapView.setZoomLevel(curZoomLevel + MyMath.getNextSquareNumberAbove(1.0f / diffNeeded) - 1);
        }
    }

    @Override
    public void animateTo(IGeoPoint point) {
        Point p = this.mMapView.getProjection().toMapPixels(point, null);
        this.animateTo(p.x, p.y);
    }

    public void animateTo(int x, int y) {
        if (!this.mMapView.isAnimating()) {
            this.mMapView.mIsFlinging = false;
            int xStart = this.mMapView.getScrollX();
            int yStart = this.mMapView.getScrollY();
            this.mMapView.getScroller().startScroll(xStart, yStart, x - xStart, y - yStart, 1000);
            this.mMapView.postInvalidate();
        }
    }

    @Override
    public void scrollBy(int x, int y) {
        this.mMapView.scrollBy(x, y);
    }

    @Override
    public void setCenter(IGeoPoint point) {
        Point p = this.mMapView.getProjection().toMapPixels(point, null);
        this.mMapView.scrollTo(p.x, p.y);
    }

    @Override
    public void stopPanning() {
        this.mMapView.mIsFlinging = false;
        this.mMapView.getScroller().forceFinished(true);
    }

    @Override
    public void stopAnimation(boolean jumpToTarget) {
        if (!this.mMapView.getScroller().isFinished()) {
            if (jumpToTarget) {
                this.mMapView.mIsFlinging = false;
                this.mMapView.getScroller().abortAnimation();
            } else {
                this.stopPanning();
            }
        }
        if (Build.VERSION.SDK_INT >= 11) {
            Animator currentAnimator = this.mCurrentAnimator;
            if (this.mMapView.mIsAnimating.get()) {
                currentAnimator.end();
            }
        } else if (this.mMapView.mIsAnimating.get()) {
            this.mMapView.clearAnimation();
        }
    }

    @Override
    public int setZoom(int zoomlevel) {
        return this.mMapView.setZoomLevel(zoomlevel);
    }

    @Override
    public boolean zoomIn() {
        Point coords = this.mMapView.getProjection().toMapPixels(this.mMapView.getMapCenter(), null);
        return this.zoomInFixing(coords.x, coords.y);
    }

    @Override
    public boolean zoomInFixing(int xPixel, int yPixel) {
        this.mMapView.mMultiTouchScalePoint.set((float)xPixel, (float)yPixel);
        if (this.mMapView.canZoomIn()) {
            if (this.mMapView.mIsAnimating.getAndSet(true)) {
                return false;
            }
            this.mMapView.mTargetZoomLevel.set(this.mMapView.getZoomLevel(false) + 1);
            if (Build.VERSION.SDK_INT >= 11) {
                this.mCurrentAnimator = this.mZoomInAnimation;
                this.mZoomInAnimation.start();
            } else {
                this.mMapView.startAnimation((Animation)this.mZoomInAnimationOld);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean zoomOut() {
        Point coords = this.mMapView.getProjection().toMapPixels(this.mMapView.getMapCenter(), null);
        return this.zoomOutFixing(coords.x, coords.y);
    }

    @Override
    public boolean zoomOutFixing(int xPixel, int yPixel) {
        this.mMapView.mMultiTouchScalePoint.set((float)xPixel, (float)yPixel);
        if (this.mMapView.canZoomOut()) {
            if (this.mMapView.mIsAnimating.getAndSet(true)) {
                return false;
            }
            this.mMapView.mTargetZoomLevel.set(this.mMapView.getZoomLevel(false) - 1);
            if (Build.VERSION.SDK_INT >= 11) {
                this.mCurrentAnimator = this.mZoomOutAnimation;
                this.mZoomOutAnimation.start();
            } else {
                this.mMapView.startAnimation((Animation)this.mZoomOutAnimationOld);
            }
            return true;
        }
        return false;
    }

    protected void onAnimationStart() {
        this.mMapView.mIsAnimating.set(true);
    }

    protected void onAnimationEnd() {
        Rect screenRect = this.mMapView.getProjection().getScreenRect();
        Matrix m = new Matrix();
        m.setScale(1.0f / this.mMapView.mMultiTouchScale, 1.0f / this.mMapView.mMultiTouchScale, this.mMapView.mMultiTouchScalePoint.x, this.mMapView.mMultiTouchScalePoint.y);
        m.postRotate(-this.mMapView.getMapOrientation(), screenRect.exactCenterX(), screenRect.exactCenterY());
        float[] pts = new float[]{this.mMapView.getScrollX(), this.mMapView.getScrollY()};
        m.mapPoints(pts);
        this.mMapView.scrollTo((int)pts[0], (int)pts[1]);
        this.setZoom(this.mMapView.mTargetZoomLevel.get());
        this.mMapView.mMultiTouchScale = 1.0f;
        if (Build.VERSION.SDK_INT >= 11) {
            this.mCurrentAnimator = null;
        }
        this.mMapView.mIsAnimating.set(false);
    }

    protected class MyZoomAnimationListener
    implements Animation.AnimationListener {
        protected MyZoomAnimationListener() {
        }

        public void onAnimationStart(Animation animation) {
            MapController.this.onAnimationStart();
        }

        public void onAnimationEnd(Animation animation) {
            MapController.this.onAnimationEnd();
        }

        public void onAnimationRepeat(Animation animation) {
        }
    }

    protected class MyZoomAnimatorUpdateListener
    implements ValueAnimator.AnimatorUpdateListener {
        protected MyZoomAnimatorUpdateListener() {
        }

        public void onAnimationUpdate(ValueAnimator animation) {
            MapController.this.mMapView.mMultiTouchScale = ((Float)animation.getAnimatedValue()).floatValue();
            MapController.this.mMapView.invalidate();
        }
    }

    protected class MyZoomAnimatorListener
    extends AnimatorListenerAdapter {
        protected MyZoomAnimatorListener() {
        }

        public void onAnimationStart(Animator animation) {
            MapController.this.onAnimationStart();
            super.onAnimationStart(animation);
        }

        public void onAnimationEnd(Animator animation) {
            MapController.this.onAnimationEnd();
            super.onAnimationEnd(animation);
        }
    }
}

