/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.views.overlay;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Picture;
import android.graphics.Rect;
import android.os.Build;
import android.view.WindowManager;
import java.lang.reflect.Field;
import org.osmdroid.DefaultResourceProxyImpl;
import org.osmdroid.ResourceProxy;
import org.osmdroid.api.IGeoPoint;
import org.osmdroid.util.GeoPoint;
import org.osmdroid.util.constants.GeoConstants;
import org.osmdroid.views.MapView;
import org.osmdroid.views.overlay.SafeDrawOverlay;
import org.osmdroid.views.safecanvas.ISafeCanvas;

public class ScaleBarOverlay
extends SafeDrawOverlay
implements GeoConstants {
    float xOffset = 10.0f;
    float yOffset = 10.0f;
    float lineWidth = 2.0f;
    final int textSize = 12;
    int minZoom = 0;
    boolean imperial = false;
    boolean nautical = false;
    boolean latitudeBar = true;
    boolean longitudeBar = false;
    private final Context context;
    protected final Picture scaleBarPicture = new Picture();
    private int lastZoomLevel = -1;
    private float lastLatitude = 0.0f;
    public float xdpi;
    public float ydpi;
    public int screenWidth;
    public int screenHeight;
    private final ResourceProxy resourceProxy;
    private Paint barPaint;
    private Paint bgPaint;
    private Paint textPaint;
    private MapView.Projection projection;
    private final Rect mBounds = new Rect();
    private final Matrix mIdentityMatrix = new Matrix();
    private boolean centred = false;
    private boolean adjustLength = false;
    private float maxLength;

    public ScaleBarOverlay(Context context) {
        this(context, new DefaultResourceProxyImpl(context));
    }

    public ScaleBarOverlay(Context context, ResourceProxy pResourceProxy) {
        super(pResourceProxy);
        this.resourceProxy = pResourceProxy;
        this.context = context;
        this.barPaint = new Paint();
        this.barPaint.setColor(-16777216);
        this.barPaint.setAntiAlias(true);
        this.barPaint.setStyle(Paint.Style.FILL);
        this.barPaint.setAlpha(255);
        this.bgPaint = null;
        this.textPaint = new Paint();
        this.textPaint.setColor(-16777216);
        this.textPaint.setAntiAlias(true);
        this.textPaint.setStyle(Paint.Style.FILL);
        this.textPaint.setAlpha(255);
        this.textPaint.setTextSize(12.0f);
        this.xdpi = this.context.getResources().getDisplayMetrics().xdpi;
        this.ydpi = this.context.getResources().getDisplayMetrics().ydpi;
        this.screenWidth = this.context.getResources().getDisplayMetrics().widthPixels;
        this.screenHeight = this.context.getResources().getDisplayMetrics().heightPixels;
        String manufacturer = null;
        try {
            Field field = Build.class.getField("MANUFACTURER");
            manufacturer = (String)field.get(null);
        }
        catch (Exception ignore) {
            // empty catch block
        }
        if ("motorola".equals(manufacturer) && "DROIDX".equals(Build.MODEL)) {
            WindowManager windowManager = (WindowManager)this.context.getSystemService("window");
            if (windowManager.getDefaultDisplay().getOrientation() > 0) {
                this.xdpi = (float)((double)this.screenWidth / 3.75);
                this.ydpi = (float)((double)this.screenHeight / 2.1);
            } else {
                this.xdpi = (float)((double)this.screenWidth / 2.1);
                this.ydpi = (float)((double)this.screenHeight / 3.75);
            }
        } else if ("motorola".equals(manufacturer) && "Droid".equals(Build.MODEL)) {
            this.xdpi = 264.0f;
            this.ydpi = 264.0f;
        }
        this.maxLength = 2.54f;
    }

    public void setMinZoom(int zoom) {
        this.minZoom = zoom;
    }

    public void setScaleBarOffset(float x, float y) {
        this.xOffset = x;
        this.yOffset = y;
    }

    public void setLineWidth(float width) {
        this.lineWidth = width;
    }

    public void setTextSize(float size) {
        this.textPaint.setTextSize(size);
    }

    public void setImperial() {
        this.imperial = true;
        this.nautical = false;
        this.lastZoomLevel = -1;
    }

    public void setNautical() {
        this.nautical = true;
        this.imperial = false;
        this.lastZoomLevel = -1;
    }

    public void setMetric() {
        this.nautical = false;
        this.imperial = false;
        this.lastZoomLevel = -1;
    }

    public void drawLatitudeScale(boolean latitude) {
        this.latitudeBar = latitude;
        this.lastZoomLevel = -1;
    }

    public void drawLongitudeScale(boolean longitude) {
        this.longitudeBar = longitude;
        this.lastZoomLevel = -1;
    }

    public void setCentred(boolean centred) {
        this.centred = centred;
        this.lastZoomLevel = -1;
    }

    public Paint getBarPaint() {
        return this.barPaint;
    }

    public void setBarPaint(Paint pBarPaint) {
        if (pBarPaint == null) {
            throw new IllegalArgumentException("pBarPaint argument cannot be null");
        }
        this.barPaint = pBarPaint;
        this.lastZoomLevel = -1;
    }

    public Paint getTextPaint() {
        return this.textPaint;
    }

    public void setTextPaint(Paint pTextPaint) {
        if (pTextPaint == null) {
            throw new IllegalArgumentException("pTextPaint argument cannot be null");
        }
        this.textPaint = pTextPaint;
        this.lastZoomLevel = -1;
    }

    public void setBackgroundPaint(Paint pBgPaint) {
        this.bgPaint = pBgPaint;
        this.lastZoomLevel = -1;
    }

    public void setEnableAdjustLength(boolean adjustLength) {
        this.adjustLength = adjustLength;
        this.lastZoomLevel = -1;
    }

    public void setMaxLength(float pMaxLengthInCm) {
        this.maxLength = pMaxLengthInCm;
        this.lastZoomLevel = -1;
    }

    @Override
    public void drawSafe(ISafeCanvas c, MapView mapView, boolean shadow) {
        if (shadow) {
            return;
        }
        if (mapView.isAnimating()) {
            return;
        }
        int zoomLevel = mapView.getZoomLevel();
        if (zoomLevel >= this.minZoom) {
            MapView.Projection projection = mapView.getProjection();
            if (projection == null) {
                return;
            }
            IGeoPoint center = projection.fromPixels(this.screenWidth / 2, this.screenHeight / 2);
            if (zoomLevel != this.lastZoomLevel || (int)((double)center.getLatitudeE6() / 1000000.0) != (int)((double)this.lastLatitude / 1000000.0)) {
                this.lastZoomLevel = zoomLevel;
                this.lastLatitude = center.getLatitudeE6();
                this.createScaleBarPicture(mapView);
            }
            this.mBounds.set(0, 0, this.scaleBarPicture.getWidth(), this.scaleBarPicture.getHeight());
            this.mBounds.offset((int)this.xOffset, (int)this.yOffset);
            if (this.centred && this.latitudeBar) {
                this.mBounds.offset(-this.scaleBarPicture.getWidth() / 2, 0);
            }
            if (this.centred && this.longitudeBar) {
                this.mBounds.offset(0, -this.scaleBarPicture.getHeight() / 2);
            }
            this.mBounds.set(this.mBounds);
            c.save();
            c.setMatrix(this.mIdentityMatrix);
            c.getWrappedCanvas().drawPicture(this.scaleBarPicture, this.mBounds);
            c.restore();
        }
    }

    public void disableScaleBar() {
        this.setEnabled(false);
    }

    public void enableScaleBar() {
        this.setEnabled(true);
    }

    private void createScaleBarPicture(MapView mapView) {
        this.projection = mapView.getProjection();
        if (this.projection == null) {
            return;
        }
        int xdpcm = (int)((double)this.xdpi / 2.54);
        int ydpcm = (int)((double)this.ydpi / 2.54);
        int xLen = (int)(this.maxLength * (float)xdpcm);
        int yLen = (int)(this.maxLength * (float)ydpcm);
        IGeoPoint p1 = this.projection.fromPixels((float)(this.screenWidth / 2 - xLen / 2), this.yOffset);
        IGeoPoint p2 = this.projection.fromPixels((float)(this.screenWidth / 2 + xLen / 2), this.yOffset);
        int xMeters = ((GeoPoint)p1).distanceTo(p2);
        double xMetersAdjusted = this.adjustLength ? this.adjustScaleBarLength(xMeters) : (double)xMeters;
        int xBarLengthPixels = (int)((double)xLen * xMetersAdjusted / (double)xMeters);
        p1 = this.projection.fromPixels(this.screenWidth / 2, this.screenHeight / 2 - yLen / 2);
        p2 = this.projection.fromPixels(this.screenWidth / 2, this.screenHeight / 2 + yLen / 2);
        int yMeters = ((GeoPoint)p1).distanceTo(p2);
        double yMetersAdjusted = this.adjustLength ? this.adjustScaleBarLength(yMeters) : (double)yMeters;
        int yBarLengthPixels = (int)((double)yLen * yMetersAdjusted / (double)yMeters);
        Canvas canvas = this.scaleBarPicture.beginRecording(xBarLengthPixels, yBarLengthPixels);
        String xMsg = this.scaleBarLengthText((int)xMetersAdjusted, this.imperial, this.nautical);
        Rect xTextRect = new Rect();
        this.textPaint.getTextBounds(xMsg, 0, xMsg.length(), xTextRect);
        int xTextSpacing = (int)((double)xTextRect.height() / 5.0);
        String yMsg = this.scaleBarLengthText((int)yMetersAdjusted, this.imperial, this.nautical);
        Rect yTextRect = new Rect();
        this.textPaint.getTextBounds(yMsg, 0, yMsg.length(), yTextRect);
        int yTextSpacing = (int)((double)yTextRect.height() / 5.0);
        if (this.bgPaint != null) {
            canvas.drawRect(0.0f, 0.0f, (float)yTextRect.height() + 2.0f * this.lineWidth + (float)yTextSpacing, (float)xTextRect.height() + 2.0f * this.lineWidth + (float)xTextSpacing, this.bgPaint);
            if (this.latitudeBar) {
                canvas.drawRect((float)yTextRect.height() + 2.0f * this.lineWidth + (float)yTextSpacing, 0.0f, (float)xBarLengthPixels + this.lineWidth, (float)xTextRect.height() + 2.0f * this.lineWidth + (float)xTextSpacing, this.bgPaint);
            }
            if (this.longitudeBar) {
                canvas.drawRect(0.0f, (float)xTextRect.height() + 2.0f * this.lineWidth + (float)xTextSpacing, (float)yTextRect.height() + 2.0f * this.lineWidth + (float)yTextSpacing, (float)yBarLengthPixels + this.lineWidth, this.bgPaint);
            }
        }
        if (this.latitudeBar) {
            canvas.drawRect(0.0f, 0.0f, (float)xBarLengthPixels, this.lineWidth, this.barPaint);
            canvas.drawRect((float)xBarLengthPixels, 0.0f, (float)xBarLengthPixels + this.lineWidth, (float)xTextRect.height() + this.lineWidth + (float)xTextSpacing, this.barPaint);
            if (!this.longitudeBar) {
                canvas.drawRect(0.0f, 0.0f, this.lineWidth, (float)xTextRect.height() + this.lineWidth + (float)xTextSpacing, this.barPaint);
            }
            canvas.drawText(xMsg, (float)(xBarLengthPixels / 2 - xTextRect.width() / 2), (float)xTextRect.height() + this.lineWidth + (float)xTextSpacing, this.textPaint);
        }
        if (this.longitudeBar) {
            canvas.drawRect(0.0f, 0.0f, this.lineWidth, (float)yBarLengthPixels, this.barPaint);
            canvas.drawRect(0.0f, (float)yBarLengthPixels, (float)yTextRect.height() + this.lineWidth + (float)yTextSpacing, (float)yBarLengthPixels + this.lineWidth, this.barPaint);
            if (!this.latitudeBar) {
                canvas.drawRect(0.0f, 0.0f, (float)yTextRect.height() + this.lineWidth + (float)yTextSpacing, this.lineWidth, this.barPaint);
            }
            float x = (float)yTextRect.height() + this.lineWidth + (float)yTextSpacing;
            float y = yBarLengthPixels / 2 + yTextRect.width() / 2;
            canvas.rotate(-90.0f, x, y);
            canvas.drawText(yMsg, x, y, this.textPaint);
        }
        this.scaleBarPicture.endRecording();
    }

    private double adjustScaleBarLength(double length) {
        long pow = 0L;
        boolean feet = false;
        if (this.imperial) {
            if (length >= 321.8688) {
                length /= 1609.344;
            } else {
                length *= 3.2808399;
                feet = true;
            }
        } else if (this.nautical) {
            if (length >= 370.4) {
                length /= 1852.0;
            } else {
                length *= 3.2808399;
                feet = true;
            }
        }
        while (length >= 10.0) {
            ++pow;
            length /= 10.0;
        }
        while (length < 1.0 && length > 0.0) {
            --pow;
            length *= 10.0;
        }
        length = length < 2.0 ? 1.0 : (length < 5.0 ? 2.0 : 5.0);
        if (feet) {
            length /= 3.2808399;
        } else if (this.imperial) {
            length *= 1609.344;
        } else if (this.nautical) {
            length *= 1852.0;
        }
        return length *= Math.pow(10.0, pow);
    }

    protected String scaleBarLengthText(int meters, boolean imperial, boolean nautical) {
        if (this.imperial) {
            if ((double)meters >= 8046.72) {
                return this.resourceProxy.getString(ResourceProxy.string.format_distance_miles, (int)((double)meters / 1609.344));
            }
            if ((double)meters >= 321.8688) {
                return this.resourceProxy.getString(ResourceProxy.string.format_distance_miles, (double)((int)((double)meters / 160.9344)) / 10.0);
            }
            return this.resourceProxy.getString(ResourceProxy.string.format_distance_feet, (int)((double)meters * 3.2808399));
        }
        if (this.nautical) {
            if ((double)meters >= 9260.0) {
                return this.resourceProxy.getString(ResourceProxy.string.format_distance_nautical_miles, (int)((double)meters / 1852.0));
            }
            if ((double)meters >= 370.4) {
                return this.resourceProxy.getString(ResourceProxy.string.format_distance_nautical_miles, (double)((int)((double)meters / 185.2)) / 10.0);
            }
            return this.resourceProxy.getString(ResourceProxy.string.format_distance_feet, (int)((double)meters * 3.2808399));
        }
        if (meters >= 5000) {
            return this.resourceProxy.getString(ResourceProxy.string.format_distance_kilometers, meters / 1000);
        }
        if (meters >= 200) {
            return this.resourceProxy.getString(ResourceProxy.string.format_distance_kilometers, (double)((int)((double)meters / 100.0)) / 10.0);
        }
        return this.resourceProxy.getString(ResourceProxy.string.format_distance_meters, meters);
    }
}

