/*
 * Decompiled with CFR 0.152.
 */
package org.osgl.mvc.result;

import org.osgl.http.H;
import org.osgl.http.util.Path;
import org.osgl.mvc.result.Result;
import org.osgl.util.S;

public abstract class RedirectBase
extends Result {
    protected String url;

    protected RedirectBase(H.Status status) {
        super(status);
    }

    public RedirectBase(H.Status status, String url) {
        super(status);
        this.url = url.trim();
    }

    public RedirectBase(H.Status status, String url, Object ... args) {
        super(status);
        this.url = S.fmt((String)url, (Object[])args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void apply(H.Request req, H.Response resp) {
        this.applyBeforeCommitHandler(req, resp);
        try {
            this._applyStatus(req, resp);
            this.applyCookies(resp);
            this.applyHeaders(resp);
            String url = this.fullUrl(req);
            resp.header("Location", url);
            resp.commit();
            this.applyAfterCommitHandler(req, resp);
        }
        finally {
            RedirectBase.clearThreadLocals();
        }
    }

    protected String url() {
        return this.url;
    }

    protected void _applyStatus(H.Request request, H.Response response) {
        this.applyStatus(response);
    }

    protected String fullUrl(H.Request request) {
        return Path.fullUrl((String)this.url(), (H.Request)request);
    }
}

