/*
 * Decompiled with CFR 0.152.
 */
package org.javanetworkanalyzer.data;

import org.javanetworkanalyzer.data.PathLengthData;

public class WeightedPathLengthData
extends PathLengthData<Double> {
    private double maxLength = 0.0;
    private double totalLength = 0.0;

    @Override
    public void clear() {
        super.clear();
        this.totalLength = 0.0;
        this.maxLength = 0.0;
    }

    @Override
    public void addSPLength(Double length) {
        ++this.count;
        this.totalLength += length.doubleValue();
        if (this.maxLength < length) {
            this.maxLength = length;
        }
    }

    @Override
    public Double getMaxLength() {
        return this.maxLength;
    }

    @Override
    public Double getTotalLength() {
        return this.totalLength;
    }

    @Override
    public double getAverageLength() {
        if (this.getCount() == 0) {
            throw new IllegalStateException("No shortest path lengths accumulated in this instance.");
        }
        return this.getTotalLength() / (double)this.getCount();
    }
}

