/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.solver.termination;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.optaplanner.core.impl.phase.scope.AbstractPhaseScope;
import org.optaplanner.core.impl.phase.scope.AbstractStepScope;
import org.optaplanner.core.impl.solver.scope.SolverScope;
import org.optaplanner.core.impl.solver.termination.AbstractTermination;
import org.optaplanner.core.impl.solver.termination.Termination;
import org.optaplanner.core.impl.solver.thread.ChildThreadType;

public abstract class AbstractCompositeTermination<Solution_>
extends AbstractTermination<Solution_> {
    protected final List<Termination<Solution_>> terminationList;

    protected AbstractCompositeTermination(List<Termination<Solution_>> terminationList) {
        this.terminationList = terminationList;
    }

    public AbstractCompositeTermination(Termination<Solution_> ... terminations) {
        this(Arrays.asList(terminations));
    }

    @Override
    public void solvingStarted(SolverScope<Solution_> solverScope) {
        for (Termination<Solution_> termination : this.terminationList) {
            termination.solvingStarted(solverScope);
        }
    }

    @Override
    public void phaseStarted(AbstractPhaseScope<Solution_> phaseScope) {
        for (Termination<Solution_> termination : this.terminationList) {
            termination.phaseStarted(phaseScope);
        }
    }

    @Override
    public void stepStarted(AbstractStepScope<Solution_> stepScope) {
        for (Termination<Solution_> termination : this.terminationList) {
            termination.stepStarted(stepScope);
        }
    }

    @Override
    public void stepEnded(AbstractStepScope<Solution_> stepScope) {
        for (Termination<Solution_> termination : this.terminationList) {
            termination.stepEnded(stepScope);
        }
    }

    @Override
    public void phaseEnded(AbstractPhaseScope<Solution_> phaseScope) {
        for (Termination<Solution_> termination : this.terminationList) {
            termination.phaseEnded(phaseScope);
        }
    }

    @Override
    public void solvingEnded(SolverScope<Solution_> solverScope) {
        for (Termination<Solution_> termination : this.terminationList) {
            termination.solvingEnded(solverScope);
        }
    }

    protected List<Termination<Solution_>> createChildThreadTerminationList(SolverScope<Solution_> solverScope, ChildThreadType childThreadType) {
        ArrayList<Termination<Solution_>> childThreadTerminationList = new ArrayList<Termination<Solution_>>(this.terminationList.size());
        for (Termination<Solution_> termination : this.terminationList) {
            childThreadTerminationList.add(termination.createChildThreadTermination(solverScope, childThreadType));
        }
        return childThreadTerminationList;
    }
}

