/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.drools.common;

import java.util.Objects;
import org.drools.core.WorkingMemory;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.rule.Declaration;
import org.drools.core.spi.Tuple;
import org.drools.model.Variable;
import org.optaplanner.core.api.function.QuadFunction;
import org.optaplanner.core.api.score.stream.tri.TriConstraintCollector;
import org.optaplanner.core.impl.score.stream.drools.common.AbstractAccumulator;

final class TriAccumulator<A, B, C, ResultContainer_, Result_>
extends AbstractAccumulator<ResultContainer_, Result_> {
    private final String varA;
    private final String varB;
    private final String varC;
    private final QuadFunction<ResultContainer_, A, B, C, Runnable> accumulator;
    private Declaration declarationA;
    private Declaration declarationB;
    private Declaration declarationC;
    private int offsetToA;
    private int offsetToB;
    private int offsetToC;

    public TriAccumulator(Variable<A> varA, Variable<B> varB, Variable<C> varC, TriConstraintCollector<A, B, C, ResultContainer_, Result_> collector) {
        super(collector.supplier(), collector.finisher());
        this.accumulator = Objects.requireNonNull(collector.accumulator());
        this.varA = varA.getName();
        this.varB = varB.getName();
        this.varC = varC.getName();
    }

    public Object accumulate(Object workingMemoryContext, Object context, Tuple leftTuple, InternalFactHandle handle, Declaration[] declarations, Declaration[] innerDeclarations, WorkingMemory workingMemory) {
        if (this.declarationA == null) {
            this.init(leftTuple, innerDeclarations);
        }
        Object a = TriAccumulator.extractValue(this.declarationA, this.offsetToA, leftTuple);
        Object b = TriAccumulator.extractValue(this.declarationB, this.offsetToB, leftTuple);
        Object c = TriAccumulator.extractValue(this.declarationC, this.offsetToC, leftTuple);
        return this.accumulator.apply(context, a, b, c);
    }

    private void init(Tuple leftTuple, Declaration[] innerDeclarations) {
        for (Declaration declaration : innerDeclarations) {
            if (declaration.getBindingName().equals(this.varA)) {
                this.declarationA = declaration;
                continue;
            }
            if (declaration.getBindingName().equals(this.varB)) {
                this.declarationB = declaration;
                continue;
            }
            if (!declaration.getBindingName().equals(this.varC)) continue;
            this.declarationC = declaration;
        }
        this.offsetToA = TriAccumulator.findTupleOffset(this.declarationA, leftTuple);
        this.offsetToB = TriAccumulator.findTupleOffset(this.declarationB, leftTuple);
        this.offsetToC = TriAccumulator.findTupleOffset(this.declarationC, leftTuple);
    }
}

