/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.localsearch.decider.acceptor.simulatedannealing;

import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.impl.localsearch.decider.acceptor.AbstractAcceptor;
import org.optaplanner.core.impl.localsearch.scope.LocalSearchMoveScope;
import org.optaplanner.core.impl.localsearch.scope.LocalSearchPhaseScope;
import org.optaplanner.core.impl.localsearch.scope.LocalSearchStepScope;
import org.optaplanner.core.impl.phase.scope.AbstractPhaseScope;
import org.optaplanner.core.impl.score.ScoreUtils;

public class SimulatedAnnealingAcceptor<Solution_>
extends AbstractAcceptor<Solution_> {
    protected Score startingTemperature;
    protected int levelsLength = -1;
    protected double[] startingTemperatureLevels;
    protected double[] temperatureLevels;
    protected double temperatureMinimum = 1.0E-100;

    public void setStartingTemperature(Score startingTemperature) {
        this.startingTemperature = startingTemperature;
    }

    @Override
    public void phaseStarted(LocalSearchPhaseScope<Solution_> phaseScope) {
        super.phaseStarted(phaseScope);
        for (double startingTemperatureLevel : ScoreUtils.extractLevelDoubles(this.startingTemperature)) {
            if (!(startingTemperatureLevel < 0.0)) continue;
            throw new IllegalArgumentException("The startingTemperature (" + this.startingTemperature + ") cannot have negative level (" + startingTemperatureLevel + ").");
        }
        this.startingTemperatureLevels = ScoreUtils.extractLevelDoubles(this.startingTemperature);
        this.temperatureLevels = this.startingTemperatureLevels;
        this.levelsLength = this.startingTemperatureLevels.length;
    }

    @Override
    public void phaseEnded(LocalSearchPhaseScope<Solution_> phaseScope) {
        super.phaseEnded(phaseScope);
        this.startingTemperatureLevels = null;
        this.temperatureLevels = null;
        this.levelsLength = -1;
    }

    @Override
    public boolean isAccepted(LocalSearchMoveScope<Solution_> moveScope) {
        AbstractPhaseScope phaseScope = ((LocalSearchStepScope)moveScope.getStepScope()).getPhaseScope();
        Score<?> lastStepScore = ((LocalSearchPhaseScope)phaseScope).getLastCompletedStepScope().getScore();
        Object moveScore = moveScope.getScore();
        if (moveScore.compareTo(lastStepScore) >= 0) {
            return true;
        }
        Object moveScoreDifference = lastStepScore.subtract(moveScore);
        double[] moveScoreDifferenceLevels = ScoreUtils.extractLevelDoubles(moveScoreDifference);
        double acceptChance = 1.0;
        for (int i = 0; i < this.levelsLength; ++i) {
            double moveScoreDifferenceLevel = moveScoreDifferenceLevels[i];
            double temperatureLevel = this.temperatureLevels[i];
            double acceptChanceLevel = moveScoreDifferenceLevel <= 0.0 ? 1.0 : Math.exp(-moveScoreDifferenceLevel / temperatureLevel);
            acceptChance *= acceptChanceLevel;
        }
        return moveScope.getWorkingRandom().nextDouble() < acceptChance;
    }

    @Override
    public void stepStarted(LocalSearchStepScope<Solution_> stepScope) {
        super.stepStarted(stepScope);
        double timeGradient = stepScope.getTimeGradient();
        double reverseTimeGradient = 1.0 - timeGradient;
        this.temperatureLevels = new double[this.levelsLength];
        for (int i = 0; i < this.levelsLength; ++i) {
            this.temperatureLevels[i] = this.startingTemperatureLevels[i] * reverseTimeGradient;
            if (!(this.temperatureLevels[i] < this.temperatureMinimum)) continue;
            this.temperatureLevels[i] = this.temperatureMinimum;
        }
    }
}

