/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.move.generic.chained;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import org.optaplanner.core.api.score.director.ScoreDirector;
import org.optaplanner.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import org.optaplanner.core.impl.domain.variable.inverserelation.SingletonInverseVariableSupply;
import org.optaplanner.core.impl.heuristic.move.AbstractMove;
import org.optaplanner.core.impl.heuristic.selector.value.chained.SubChain;
import org.optaplanner.core.impl.score.director.InnerScoreDirector;

public class SubChainSwapMove<Solution_>
extends AbstractMove<Solution_> {
    protected final GenuineVariableDescriptor<Solution_> variableDescriptor;
    protected final SubChain leftSubChain;
    protected final Object leftTrailingLastEntity;
    protected final SubChain rightSubChain;
    protected final Object rightTrailingLastEntity;

    public SubChainSwapMove(GenuineVariableDescriptor<Solution_> variableDescriptor, SingletonInverseVariableSupply inverseVariableSupply, SubChain leftSubChain, SubChain rightSubChain) {
        this.variableDescriptor = variableDescriptor;
        this.leftSubChain = leftSubChain;
        this.leftTrailingLastEntity = inverseVariableSupply.getInverseSingleton(leftSubChain.getLastEntity());
        this.rightSubChain = rightSubChain;
        this.rightTrailingLastEntity = inverseVariableSupply.getInverseSingleton(rightSubChain.getLastEntity());
    }

    public SubChainSwapMove(GenuineVariableDescriptor<Solution_> variableDescriptor, SubChain leftSubChain, Object leftTrailingLastEntity, SubChain rightSubChain, Object rightTrailingLastEntity) {
        this.variableDescriptor = variableDescriptor;
        this.leftSubChain = leftSubChain;
        this.rightSubChain = rightSubChain;
        this.leftTrailingLastEntity = leftTrailingLastEntity;
        this.rightTrailingLastEntity = rightTrailingLastEntity;
    }

    public String getVariableName() {
        return this.variableDescriptor.getVariableName();
    }

    public SubChain getLeftSubChain() {
        return this.leftSubChain;
    }

    public SubChain getRightSubChain() {
        return this.rightSubChain;
    }

    @Override
    public boolean isMoveDoable(ScoreDirector<Solution_> scoreDirector) {
        for (Object leftEntity : this.leftSubChain.getEntityList()) {
            if (!this.rightSubChain.getEntityList().contains(leftEntity)) continue;
            return false;
        }
        return true;
    }

    @Override
    public SubChainSwapMove<Solution_> createUndoMove(ScoreDirector<Solution_> scoreDirector) {
        return new SubChainSwapMove<Solution_>(this.variableDescriptor, this.rightSubChain, this.leftTrailingLastEntity, this.leftSubChain, this.rightTrailingLastEntity);
    }

    @Override
    protected void doMoveOnGenuineVariables(ScoreDirector<Solution_> scoreDirector) {
        Object leftFirstEntity = this.leftSubChain.getFirstEntity();
        Object leftFirstValue = this.variableDescriptor.getValue(leftFirstEntity);
        Object leftLastEntity = this.leftSubChain.getLastEntity();
        Object rightFirstEntity = this.rightSubChain.getFirstEntity();
        Object rightFirstValue = this.variableDescriptor.getValue(rightFirstEntity);
        Object rightLastEntity = this.rightSubChain.getLastEntity();
        InnerScoreDirector innerScoreDirector = (InnerScoreDirector)scoreDirector;
        if (leftLastEntity != rightFirstValue) {
            innerScoreDirector.changeVariableFacade(this.variableDescriptor, leftFirstEntity, rightFirstValue);
        }
        if (rightLastEntity != leftFirstValue) {
            innerScoreDirector.changeVariableFacade(this.variableDescriptor, rightFirstEntity, leftFirstValue);
        }
        if (this.leftTrailingLastEntity != null) {
            if (this.leftTrailingLastEntity != rightFirstEntity) {
                innerScoreDirector.changeVariableFacade(this.variableDescriptor, this.leftTrailingLastEntity, rightLastEntity);
            } else {
                innerScoreDirector.changeVariableFacade(this.variableDescriptor, leftFirstEntity, rightLastEntity);
            }
        }
        if (this.rightTrailingLastEntity != null) {
            if (this.rightTrailingLastEntity != leftFirstEntity) {
                innerScoreDirector.changeVariableFacade(this.variableDescriptor, this.rightTrailingLastEntity, leftLastEntity);
            } else {
                innerScoreDirector.changeVariableFacade(this.variableDescriptor, rightFirstEntity, leftLastEntity);
            }
        }
    }

    @Override
    public SubChainSwapMove<Solution_> rebase(ScoreDirector<Solution_> destinationScoreDirector) {
        return new SubChainSwapMove<Solution_>(this.variableDescriptor, this.leftSubChain.rebase(destinationScoreDirector), destinationScoreDirector.lookUpWorkingObject(this.leftTrailingLastEntity), this.rightSubChain.rebase(destinationScoreDirector), destinationScoreDirector.lookUpWorkingObject(this.rightTrailingLastEntity));
    }

    @Override
    public String getSimpleMoveTypeDescription() {
        return this.getClass().getSimpleName() + "(" + this.variableDescriptor.getSimpleEntityAndVariableName() + ")";
    }

    @Override
    public Collection<? extends Object> getPlanningEntities() {
        ArrayList<Object> entities = new ArrayList<Object>(this.leftSubChain.getSize() + this.rightSubChain.getSize());
        entities.addAll(this.leftSubChain.getEntityList());
        entities.addAll(this.rightSubChain.getEntityList());
        return entities;
    }

    @Override
    public Collection<? extends Object> getPlanningValues() {
        ArrayList<Object> values = new ArrayList<Object>(2);
        values.add(this.variableDescriptor.getValue(this.leftSubChain.getFirstEntity()));
        values.add(this.variableDescriptor.getValue(this.rightSubChain.getFirstEntity()));
        return values;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SubChainSwapMove other = (SubChainSwapMove)o;
        return Objects.equals(this.variableDescriptor, other.variableDescriptor) && Objects.equals(this.leftSubChain, other.leftSubChain) && Objects.equals(this.rightSubChain, other.rightSubChain);
    }

    public int hashCode() {
        return Objects.hash(this.variableDescriptor, this.leftSubChain, this.rightSubChain);
    }

    public String toString() {
        Object oldLeftValue = this.variableDescriptor.getValue(this.leftSubChain.getFirstEntity());
        Object oldRightValue = this.variableDescriptor.getValue(this.rightSubChain.getFirstEntity());
        return this.leftSubChain.toDottedString() + " {" + oldLeftValue + "} <-> " + this.rightSubChain.toDottedString() + " {" + oldRightValue + "}";
    }
}

